/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.addons.redis;

import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.Map;
import org.nodex.java.addons.redis.InternalConnection;
import org.nodex.java.addons.redis.RedisDeferred;
import org.nodex.java.addons.redis.RedisReply;
import org.nodex.java.addons.redis.ReplyParser;
import org.nodex.java.core.ConnectionPool;
import org.nodex.java.core.Deferred;
import org.nodex.java.core.DeferredAction;
import org.nodex.java.core.Future;
import org.nodex.java.core.Handler;
import org.nodex.java.core.buffer.Buffer;
import org.nodex.java.core.internal.NodexInternal;

public class RedisConnection {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final byte[] APPEND_COMMAND = "APPEND".getBytes(UTF8);
    private static final byte[] AUTH_COMMAND = "AUTH".getBytes(UTF8);
    private static final byte[] BGREWRITEAOF_COMMAND = "BGREWRITEAOF".getBytes(UTF8);
    private static final byte[] BGSAVE_COMMAND = "BGSAVE".getBytes(UTF8);
    private static final byte[] BLPOP_COMMAND = "BLPOP".getBytes(UTF8);
    private static final byte[] BRPOP_COMMAND = "BRPOP".getBytes(UTF8);
    private static final byte[] BRPOPLPUSH_COMMAND = "BRPOPLPUSH".getBytes(UTF8);
    private static final byte[] CONFIG_GET_COMMAND = "CONFIG GET".getBytes(UTF8);
    private static final byte[] CONFIG_SET_COMMAND = "CONFIG SET".getBytes(UTF8);
    private static final byte[] CONFIG_RESET_STAT_COMMAND = "CONFIG RESET STAT".getBytes(UTF8);
    private static final byte[] DB_SIZE_COMMAND = "DBSIZE".getBytes(UTF8);
    private static final byte[] DEBUG_OBJECT_COMMAND = "DEBUG OBJECT".getBytes(UTF8);
    private static final byte[] DEBUG_SEG_FAULT_COMMAND = "DEBUG SEGFAULT".getBytes(UTF8);
    private static final byte[] DECR_COMMAND = "DECR".getBytes(UTF8);
    private static final byte[] DECRBY_COMMAND = "DECRBY".getBytes(UTF8);
    private static final byte[] DEL_COMMAND = "DEL".getBytes(UTF8);
    private static final byte[] DISCARD_COMMAND = "DISCARD".getBytes(UTF8);
    private static final byte[] ECHO_COMMAND = "ECHO".getBytes(UTF8);
    private static final byte[] EXEC_COMMAND = "EXEC".getBytes(UTF8);
    private static final byte[] EXISTS_COMMAND = "EXISTS".getBytes(UTF8);
    private static final byte[] EXPIRE_COMMAND = "EXPIRE".getBytes(UTF8);
    private static final byte[] EXPIREAT_COMMAND = "EXPIREAT".getBytes(UTF8);
    private static final byte[] FLUSHALL_COMMAND = "FLUSHALL".getBytes(UTF8);
    private static final byte[] FLUSHDB_COMMAND = "FLUSHDB".getBytes(UTF8);
    private static final byte[] GET_COMMAND = "GET".getBytes(UTF8);
    private static final byte[] GETBIT_COMMAND = "GETBIT".getBytes(UTF8);
    private static final byte[] GETRANGE_COMMAND = "GETRANGE".getBytes(UTF8);
    private static final byte[] GETSET_COMMAND = "GETSET".getBytes(UTF8);
    private static final byte[] HDEL_COMMAND = "HDEL".getBytes(UTF8);
    private static final byte[] HEXISTS_COMMAND = "HEXISTS".getBytes(UTF8);
    private static final byte[] HGET_COMMAND = "HGET".getBytes(UTF8);
    private static final byte[] HGETALL_COMMAND = "HGETALL".getBytes(UTF8);
    private static final byte[] HINCRBY_COMMAND = "HINCRBY".getBytes(UTF8);
    private static final byte[] HKEYS_COMMAND = "HKEYS".getBytes(UTF8);
    private static final byte[] HLEN_COMMAND = "HLEN".getBytes(UTF8);
    private static final byte[] HMGET_COMMAND = "HMGET".getBytes(UTF8);
    private static final byte[] HMSET_COMMAND = "HMSET".getBytes(UTF8);
    private static final byte[] HSET_COMMAND = "HSET".getBytes(UTF8);
    private static final byte[] HSETNX_COMMAND = "HSETNX".getBytes(UTF8);
    private static final byte[] HVALS_COMMAND = "HVALS".getBytes(UTF8);
    private static final byte[] INCR_COMMAND = "INCR".getBytes(UTF8);
    private static final byte[] INCRBY_COMMAND = "INCRBY".getBytes(UTF8);
    private static final byte[] INFO_COMMAND = "INFO".getBytes(UTF8);
    private static final byte[] KEYS_COMMAND = "KEYS".getBytes(UTF8);
    private static final byte[] LASTSAVE_COMMAND = "LASTSAVE".getBytes(UTF8);
    private static final byte[] LINDEX_COMMAND = "LINDEX".getBytes(UTF8);
    private static final byte[] LINSERT_COMMAND = "LINSERT".getBytes(UTF8);
    private static final byte[] LLEN_COMMAND = "LLEN".getBytes(UTF8);
    private static final byte[] LPOP_COMMAND = "LPOP".getBytes(UTF8);
    private static final byte[] LPUSH_COMMAND = "LPUSH".getBytes(UTF8);
    private static final byte[] LPUSHX_COMMAND = "LPUSHX".getBytes(UTF8);
    private static final byte[] LRANGE_COMMAND = "LRANGE".getBytes(UTF8);
    private static final byte[] LREM_COMMAND = "LREM".getBytes(UTF8);
    private static final byte[] LSET_COMMAND = "LSET".getBytes(UTF8);
    private static final byte[] LTRIM_COMMAND = "LTRIM".getBytes(UTF8);
    private static final byte[] MGET_COMMAND = "MGET".getBytes(UTF8);
    private static final byte[] MOVE_COMMAND = "MOVE".getBytes(UTF8);
    private static final byte[] MSET_COMMAND = "MSET".getBytes(UTF8);
    private static final byte[] MSETNX_COMMAND = "MSETNX".getBytes(UTF8);
    private static final byte[] MULTI_COMMAND = "MULTI".getBytes(UTF8);
    private static final byte[] PERSIST_COMMAND = "PERSIST".getBytes(UTF8);
    private static final byte[] PING_COMMAND = "PING".getBytes(UTF8);
    private static final byte[] PSUBSCRIBE_COMMAND = "PSUBSCRIBE".getBytes(UTF8);
    private static final byte[] PUNSUBSCRIBE_COMMAND = "PUNSUBSCRIBE".getBytes(UTF8);
    private static final byte[] PUBLISH_COMMAND = "PUBLISH".getBytes(UTF8);
    private static final byte[] QUIT_COMMAND = "QUIT".getBytes(UTF8);
    private static final byte[] RANDOMKEY_COMMAND = "RANDOMKEY".getBytes(UTF8);
    private static final byte[] RENAME_COMMAND = "RENAME".getBytes(UTF8);
    private static final byte[] RENAMENX_COMMAND = "RENAMENX".getBytes(UTF8);
    private static final byte[] RPOP_COMMAND = "RPOP".getBytes(UTF8);
    private static final byte[] RPOPLPUSH_COMMAND = "RPOPLPUSH".getBytes(UTF8);
    private static final byte[] RPUSH_COMMAND = "RPUSH".getBytes(UTF8);
    private static final byte[] RPUSHX_COMMAND = "RPUSHX".getBytes(UTF8);
    private static final byte[] SADD_COMMAND = "SADD".getBytes(UTF8);
    private static final byte[] SAVE_COMMAND = "SAVE".getBytes(UTF8);
    private static final byte[] SCARD_COMMAND = "SCARD".getBytes(UTF8);
    private static final byte[] SDIFF_COMMAND = "SDIFF".getBytes(UTF8);
    private static final byte[] SDIFFSTORE_COMMAND = "SDIFFSTORE".getBytes(UTF8);
    private static final byte[] SELECT_COMMAND = "SELECT".getBytes(UTF8);
    private static final byte[] SET_COMMAND = "SET".getBytes(UTF8);
    private static final byte[] SETBIT_COMMAND = "SETBIT".getBytes(UTF8);
    private static final byte[] SETEX_COMMAND = "SETEX".getBytes(UTF8);
    private static final byte[] SETNX_COMMAND = "SETNX".getBytes(UTF8);
    private static final byte[] SETRANGE_COMMAND = "SETRANGE".getBytes(UTF8);
    private static final byte[] SHUTDOWN_COMMAND = "SHUTDOWN".getBytes(UTF8);
    private static final byte[] SINTER_COMMAND = "SINTER".getBytes(UTF8);
    private static final byte[] SINTERSTORE_COMMAND = "SINTERSTORE".getBytes(UTF8);
    private static final byte[] SISMEMBER_COMMAND = "SISMEMBER".getBytes(UTF8);
    private static final byte[] SLAVEOF_COMMAND = "SLAVEOF".getBytes(UTF8);
    private static final byte[] SMEMBERS_COMMAND = "SMEMBERS".getBytes(UTF8);
    private static final byte[] SMOVE_COMMAND = "SMOVE".getBytes(UTF8);
    private static final byte[] SORT_COMMAND = "SORT".getBytes(UTF8);
    private static final byte[] SPOP_COMMAND = "SPOP".getBytes(UTF8);
    private static final byte[] SRANDMEMBER_COMMAND = "SRANDMEMBER".getBytes(UTF8);
    private static final byte[] SREM_COMMAND = "SREM".getBytes(UTF8);
    private static final byte[] STRLEN_COMMAND = "STRLEN".getBytes(UTF8);
    private static final byte[] SUBSCRIBE_COMMAND = "SUBSCRIBE".getBytes(UTF8);
    private static final byte[] SUNION_COMMAND = "SUNION".getBytes(UTF8);
    private static final byte[] SUNIONSTORE_COMMAND = "SUNIONSTORE".getBytes(UTF8);
    private static final byte[] TTL_COMMAND = "TTL".getBytes(UTF8);
    private static final byte[] TYPE_COMMAND = "TYPE".getBytes(UTF8);
    private static final byte[] UNSUBSCRIBE_COMMAND = "UNSUBSCRIBE".getBytes(UTF8);
    private static final byte[] UNWATCH_COMMAND = "UNWATCH".getBytes(UTF8);
    private static final byte[] WATCH_COMMAND = "WATCH".getBytes(UTF8);
    private static final byte[] ZADD_COMMAND = "ZADD".getBytes(UTF8);
    private static final byte[] ZCARD_COMMAND = "ZCARD".getBytes(UTF8);
    private static final byte[] ZCOUNT_COMMAND = "ZCOUNT".getBytes(UTF8);
    private static final byte[] ZINCRBY_COMMAND = "ZINCRBY".getBytes(UTF8);
    private static final byte[] ZINTERSTORE_COMMAND = "ZINTERSTORE".getBytes(UTF8);
    private static final byte[] ZRANGE_COMMAND = "ZRANGE".getBytes(UTF8);
    private static final byte[] ZRANGEBYSCORE_COMMAND = "ZRANGEBYSCORE".getBytes(UTF8);
    private static final byte[] ZRANK_COMMAND = "ZRANK".getBytes(UTF8);
    private static final byte[] ZREM_COMMAND = "ZREM".getBytes(UTF8);
    private static final byte[] ZREMRANGEBYRANK_COMMAND = "ZREMRANGEBYRANK".getBytes(UTF8);
    private static final byte[] ZREMRANGEBYSCORE_COMMAND = "ZREMRANGEBYSCORE".getBytes(UTF8);
    private static final byte[] ZREVRANGE_COMMAND = "ZREVRANGE".getBytes(UTF8);
    private static final byte[] ZREVRANGEBYSCORE_COMMAND = "ZREVRANGEBYSCORE".getBytes(UTF8);
    private static final byte[] ZREVRANK_COMMAND = "ZREVRANK".getBytes(UTF8);
    private static final byte[] ZSCORE_COMMAND = "ZSCORE".getBytes(UTF8);
    private static final byte[] ZUNIONSTORE_COMMAND = "ZUNIONSTORE".getBytes(UTF8);
    private static final byte[] INSERT_BEFORE = "BEFORE".getBytes(UTF8);
    private static final byte[] INSERT_AFTER = "AFTER".getBytes(UTF8);
    private static final byte[] LIMIT = "LIMIT".getBytes(UTF8);
    private static final byte[] SORT_BY = "BY".getBytes(UTF8);
    private static final byte[] SORT_GET = "GET".getBytes(UTF8);
    private static final byte[] SORT_DESC = "DESC".getBytes(UTF8);
    private static final byte[] SORT_ALPHA = "ALPHA".getBytes(UTF8);
    private static final byte[] SORT_STORE = "STORE".getBytes(UTF8);
    private static final byte[] WEIGHTS = "WEIGHTS".getBytes(UTF8);
    private static final byte[] AGGREGRATE = "AGGREGATE".getBytes(UTF8);
    private static final byte[] WITHSCORES = "WITHSCORES".getBytes(UTF8);
    private final ConnectionPool<InternalConnection> pool;
    private final String password;
    InternalConnection conn;
    private final LinkedList<RedisDeferred<?>> pending = new LinkedList();
    private Handler<Buffer> subscriberHandler;
    private DeferredAction<Void> closeDeferred;
    private boolean connectionRequested;

    RedisConnection(ConnectionPool<InternalConnection> pool, String password) {
        this.pool = pool;
        this.password = password;
    }

    public Future<Void> close() {
        return this.closeDeferred().execute();
    }

    public Deferred<Void> closeDeferred() {
        return new DeferredAction<Void>(){

            @Override
            public void run() {
                if (RedisConnection.this.conn != null) {
                    RedisConnection.this.conn.close(this);
                    RedisConnection.this.conn = null;
                } else if (RedisConnection.this.pending.isEmpty()) {
                    this.setResult(null);
                } else {
                    RedisConnection.this.closeDeferred = this;
                }
            }
        };
    }

    public void subscriberHandler(Handler<Buffer> handler) {
        if (this.conn != null) {
            this.conn.subscriberHandler = handler;
        } else {
            this.subscriberHandler = handler;
        }
    }

    void addToPending(RedisDeferred<?> deferred) {
        this.getConnection();
        this.pending.add(deferred);
    }

    public Deferred<Integer> append(Buffer key, Buffer value) {
        return this.createIntegerDeferred(APPEND_COMMAND, key, value);
    }

    private Deferred<Void> auth(Buffer password) {
        return this.createVoidDeferred(AUTH_COMMAND, password);
    }

    public Deferred<Void> bgRewriteAOF() {
        return this.createVoidDeferred(BGREWRITEAOF_COMMAND, new Buffer[0]);
    }

    public Deferred<Void> bgSave() {
        return this.createVoidDeferred(BGSAVE_COMMAND, new Buffer[0]);
    }

    public Deferred<Buffer[]> bLPop(int timeout, Buffer ... keys) {
        Buffer[] args = new Buffer[keys.length + 1];
        System.arraycopy(keys, 0, args, 0, keys.length);
        args[args.length - 1] = this.intToBuffer(timeout);
        return this.createMultiBulkDeferred(BLPOP_COMMAND, args);
    }

    public Deferred<Buffer[]> bRPop(int timeout, Buffer ... keys) {
        return this.createMultiBulkDeferred(BRPOP_COMMAND, this.toBufferArray(keys, this.intToBuffer(timeout)));
    }

    public Deferred<Buffer> bRPopLPush(Buffer source, Buffer destination, int timeout) {
        return this.createBulkDeferred(BRPOPLPUSH_COMMAND, source, destination, this.intToBuffer(timeout));
    }

    public Deferred<Buffer> configGet(Buffer parameter) {
        return this.createBulkDeferred(CONFIG_GET_COMMAND, parameter);
    }

    public Deferred<Void> configSet(Buffer parameter, Buffer value) {
        return this.createVoidDeferred(CONFIG_SET_COMMAND, parameter, value);
    }

    public Deferred<Integer> dbSize() {
        return this.createIntegerDeferred(DB_SIZE_COMMAND, new Buffer[0]);
    }

    public Deferred<Integer> decr(Buffer key) {
        return this.createIntegerDeferred(DECR_COMMAND, key);
    }

    public Deferred<Integer> decrBy(Buffer key, int decrement) {
        return this.createIntegerDeferred(DECRBY_COMMAND, key, this.intToBuffer(decrement));
    }

    public Deferred<Integer> del(Buffer ... keys) {
        return this.createIntegerDeferred(DEL_COMMAND, keys);
    }

    public Deferred<Void> discard() {
        RedisDeferred<Void> deferred = this.createVoidDeferred(DISCARD_COMMAND, new Buffer[0]);
        deferred.commandType = RedisDeferred.TxCommandType.DISCARD;
        return deferred;
    }

    public Deferred<Buffer> echo(Buffer message) {
        return this.createBulkDeferred(ECHO_COMMAND, message);
    }

    public Deferred<Void> exec() {
        RedisDeferred<Void> deferred = this.createVoidDeferred(EXEC_COMMAND, new Buffer[0]);
        deferred.commandType = RedisDeferred.TxCommandType.EXEC;
        return deferred;
    }

    public Deferred<Boolean> exists(Buffer key) {
        return this.createBooleanDeferred(EXISTS_COMMAND, key);
    }

    public Deferred<Boolean> expire(Buffer key, int seconds) {
        return this.createBooleanDeferred(EXPIRE_COMMAND, key, this.intToBuffer(seconds));
    }

    public Deferred<Boolean> expireAt(Buffer key, int timestamp) {
        return this.createBooleanDeferred(EXPIREAT_COMMAND, key, this.intToBuffer(timestamp));
    }

    public Deferred<Void> flushAll() {
        return this.createVoidDeferred(FLUSHALL_COMMAND, new Buffer[0]);
    }

    public Deferred<Void> flushDB() {
        return this.createVoidDeferred(FLUSHDB_COMMAND, new Buffer[0]);
    }

    public Deferred<Buffer> get(Buffer key) {
        return this.createBulkDeferred(GET_COMMAND, key);
    }

    public Deferred<Integer> getBit(Buffer key, int offset) {
        return this.createIntegerDeferred(GETBIT_COMMAND, key, this.intToBuffer(offset));
    }

    public Deferred<Buffer> getRange(Buffer key, int start, int end) {
        return this.createBulkDeferred(GETRANGE_COMMAND, key, this.intToBuffer(start), this.intToBuffer(end));
    }

    public Deferred<Buffer> getSet(Buffer key, Buffer value) {
        return this.createBulkDeferred(GETSET_COMMAND, key, value);
    }

    public Deferred<Integer> hDel(Buffer key, Buffer ... fields) {
        return this.createIntegerDeferred(HDEL_COMMAND, this.toBufferArray(key, fields));
    }

    public Deferred<Boolean> hExists(Buffer key, Buffer field) {
        return this.createBooleanDeferred(HEXISTS_COMMAND, key, field);
    }

    public Deferred<Buffer> hGet(Buffer key, Buffer field) {
        return this.createBulkDeferred(HGET_COMMAND, key, field);
    }

    public Deferred<Buffer[]> hGetAll(Buffer key) {
        return this.createMultiBulkDeferred(HGETALL_COMMAND, key);
    }

    public Deferred<Integer> hIncrBy(Buffer key, Buffer field, int increment) {
        return this.createIntegerDeferred(HINCRBY_COMMAND, key, field, this.intToBuffer(increment));
    }

    public Deferred<Buffer[]> hKeys(Buffer key) {
        return this.createMultiBulkDeferred(HKEYS_COMMAND, key);
    }

    public Deferred<Integer> hLen(Buffer key) {
        return this.createIntegerDeferred(HLEN_COMMAND, key);
    }

    public Deferred<Buffer[]> hmGet(Buffer key, Buffer ... fields) {
        return this.createMultiBulkDeferred(HMGET_COMMAND, this.toBufferArray(key, fields));
    }

    public Deferred<Void> hmSet(Buffer key, Map<Buffer, Buffer> map) {
        return this.createVoidDeferred(HMSET_COMMAND, this.toBufferArray(key, this.toBufferArray(map)));
    }

    public Deferred<Boolean> hSet(Buffer key, Buffer field, Buffer value) {
        return this.createBooleanDeferred(HSET_COMMAND, key, field, value);
    }

    public Deferred<Boolean> hSetNx(Buffer key, Buffer field, Buffer value) {
        return this.createBooleanDeferred(HSETNX_COMMAND, key, field, value);
    }

    public Deferred<Buffer[]> hVals(Buffer key) {
        return this.createMultiBulkDeferred(HVALS_COMMAND, key);
    }

    public Deferred<Integer> incr(Buffer key) {
        return this.createIntegerDeferred(INCR_COMMAND, key);
    }

    public Deferred<Integer> incrBy(Buffer key, int increment) {
        return this.createIntegerDeferred(INCRBY_COMMAND, key, this.intToBuffer(increment));
    }

    public Deferred<Buffer> info() {
        return this.createBulkDeferred(INFO_COMMAND, new Buffer[0]);
    }

    public Deferred<Buffer[]> keys(Buffer pattern) {
        return this.createMultiBulkDeferred(KEYS_COMMAND, pattern);
    }

    public Deferred<Integer> lastSave() {
        return this.createIntegerDeferred(LASTSAVE_COMMAND, new Buffer[0]);
    }

    public Deferred<Buffer> lIndex(Buffer key, int index) {
        return this.createBulkDeferred(LINDEX_COMMAND, key, this.intToBuffer(index));
    }

    public Deferred<Integer> lInsert(Buffer key, boolean before, Buffer pivot, Buffer value) {
        return this.createIntegerDeferred(LINSERT_COMMAND, key, Buffer.create(before ? INSERT_BEFORE : INSERT_AFTER), pivot, value);
    }

    public Deferred<Integer> lLen(Buffer key) {
        return this.createIntegerDeferred(LLEN_COMMAND, key);
    }

    public Deferred<Buffer> lPop(Buffer key) {
        return this.createBulkDeferred(LPOP_COMMAND, key);
    }

    public Deferred<Integer> lPush(Buffer key, Buffer value) {
        return this.createIntegerDeferred(LPUSH_COMMAND, key, value);
    }

    public Deferred<Integer> lPush(Buffer key, Buffer ... values) {
        return this.createIntegerDeferred(LPUSH_COMMAND, this.toBufferArray(key, values));
    }

    public Deferred<Integer> lPushX(Buffer key, Buffer value) {
        return this.createIntegerDeferred(LPUSHX_COMMAND, key, value);
    }

    public Deferred<Buffer[]> lRange(Buffer key, int start, int stop) {
        return this.createMultiBulkDeferred(LRANGE_COMMAND, key, this.intToBuffer(start), this.intToBuffer(stop));
    }

    public Deferred<Integer> lRem(Buffer key, int count, Buffer value) {
        return this.createIntegerDeferred(LREM_COMMAND, key, this.intToBuffer(count), value);
    }

    public Deferred<Void> lSet(Buffer key, int index, Buffer value) {
        return this.createVoidDeferred(LSET_COMMAND, key, this.intToBuffer(index), value);
    }

    public Deferred<Void> lTrim(Buffer key, int start, int stop) {
        return this.createVoidDeferred(LTRIM_COMMAND, key, this.intToBuffer(start), this.intToBuffer(stop));
    }

    public Deferred<Buffer[]> mget(Buffer ... keys) {
        return this.createMultiBulkDeferred(MGET_COMMAND, keys);
    }

    public Deferred<Boolean> move(Buffer key, Buffer db) {
        return this.createBooleanDeferred(MOVE_COMMAND, key, db);
    }

    public Deferred<Void> mset(Map<Buffer, Buffer> map) {
        return this.createVoidDeferred(MSET_COMMAND, this.toBufferArray(map));
    }

    public Deferred<Boolean> msetNx(Map<Buffer, Buffer> map) {
        return this.createBooleanDeferred(MSETNX_COMMAND, this.toBufferArray(map));
    }

    public Deferred<Void> multi() {
        RedisDeferred<Void> deferred = this.createVoidDeferred(MULTI_COMMAND, new Buffer[0]);
        deferred.commandType = RedisDeferred.TxCommandType.MULTI;
        return deferred;
    }

    public Deferred<Boolean> persist(Buffer key) {
        return this.createBooleanDeferred(PERSIST_COMMAND, key);
    }

    public Deferred<Void> ping() {
        return this.createVoidDeferred(PING_COMMAND, new Buffer[0]);
    }

    public Deferred<Void> pSubscribe(Buffer ... patterns) {
        return this.doSubscribe(PSUBSCRIBE_COMMAND, patterns);
    }

    public Deferred<Integer> publish(Buffer channel, Buffer message) {
        return this.createIntegerDeferred(PUBLISH_COMMAND, channel, message);
    }

    public Deferred<Void> pUnsubscribe(Buffer ... patterns) {
        return this.doUnsubscribe(PUNSUBSCRIBE_COMMAND, patterns);
    }

    public Deferred<Buffer> randomKey() {
        return this.createBulkDeferred(RANDOMKEY_COMMAND, new Buffer[0]);
    }

    public Deferred<Void> rename(Buffer key, Buffer newKey) {
        return this.createVoidDeferred(RENAME_COMMAND, key, newKey);
    }

    public Deferred<Boolean> renameNX(Buffer key, Buffer newKey) {
        return this.createBooleanDeferred(RENAMENX_COMMAND, key, newKey);
    }

    public Deferred<Buffer> rPop(Buffer key) {
        return this.createBulkDeferred(RPOP_COMMAND, key);
    }

    public Deferred<Buffer> rPoplPush(Buffer source, Buffer destination) {
        return this.createBulkDeferred(RPOPLPUSH_COMMAND, source, destination);
    }

    public Deferred<Integer> rPush(Buffer key, Buffer ... values) {
        return this.createIntegerDeferred(RPUSH_COMMAND, this.toBufferArray(key, values));
    }

    public Deferred<Integer> rPushX(Buffer key, Buffer value) {
        return this.createIntegerDeferred(RPUSHX_COMMAND, key, value);
    }

    public Deferred<Integer> sAdd(Buffer key, Buffer ... members) {
        return this.createIntegerDeferred(SADD_COMMAND, this.toBufferArray(key, members));
    }

    public Deferred<Void> save() {
        return this.createVoidDeferred(SAVE_COMMAND, new Buffer[0]);
    }

    public Deferred<Integer> sCard(Buffer key) {
        return this.createIntegerDeferred(SCARD_COMMAND, key);
    }

    public Deferred<Buffer[]> sDiff(Buffer key, Buffer ... others) {
        return this.createMultiBulkDeferred(SDIFF_COMMAND, this.toBufferArray(key, others));
    }

    public Deferred<Integer> sDiffStore(Buffer destination, Buffer key, Buffer ... others) {
        return this.createIntegerDeferred(SDIFFSTORE_COMMAND, this.toBufferArray(destination, this.toBufferArray(key, others)));
    }

    public Deferred<Void> select(int index) {
        return this.createVoidDeferred(SELECT_COMMAND, this.intToBuffer(index));
    }

    public Deferred<Void> set(Buffer key, Buffer value) {
        return this.createVoidDeferred(SET_COMMAND, key, value);
    }

    public Deferred<Integer> setBit(Buffer key, int offset, int value) {
        return this.createIntegerDeferred(SETBIT_COMMAND, key, this.intToBuffer(offset), this.intToBuffer(value));
    }

    public Deferred<Void> setEx(Buffer key, int seconds, Buffer value) {
        return this.createVoidDeferred(SETEX_COMMAND, key, this.intToBuffer(seconds), value);
    }

    public Deferred<Boolean> setNx(Buffer key, Buffer value) {
        return this.createBooleanDeferred(SETNX_COMMAND, key, value);
    }

    public Deferred<Integer> setRange(Buffer key, int offset, Buffer value) {
        return this.createIntegerDeferred(SETRANGE_COMMAND, key, this.intToBuffer(offset), value);
    }

    public Deferred<Void> shutdown() {
        return this.createVoidDeferred(SHUTDOWN_COMMAND, new Buffer[0]);
    }

    public Deferred<Buffer[]> sInter(Buffer ... keys) {
        return this.createMultiBulkDeferred(SINTER_COMMAND, keys);
    }

    public Deferred<Integer> sInterStore(Buffer destination, Buffer ... keys) {
        return this.createIntegerDeferred(SINTERSTORE_COMMAND, this.toBufferArray(destination, keys));
    }

    public Deferred<Boolean> sIsMember(Buffer key, Buffer member) {
        return this.createBooleanDeferred(SISMEMBER_COMMAND, key, member);
    }

    public Deferred<Void> slaveOf(String host, int port) {
        return this.createVoidDeferred(SLAVEOF_COMMAND, Buffer.create(host), this.intToBuffer(port));
    }

    public Deferred<Buffer[]> sMembers(Buffer key) {
        return this.createMultiBulkDeferred(SMEMBERS_COMMAND, key);
    }

    public Deferred<Boolean> sMove(Buffer source, Buffer destination, Buffer member) {
        return this.createBooleanDeferred(SMOVE_COMMAND, source, destination, member);
    }

    public Deferred<Buffer[]> sort(Buffer key) {
        return this.sort(key, null, -1, -1, null, true, false, null);
    }

    public Deferred<Buffer[]> sort(Buffer key, boolean ascending) {
        return this.sort(key, null, -1, -1, null, ascending, false, null);
    }

    public Deferred<Buffer[]> sort(Buffer key, Buffer pattern) {
        return this.sort(key, pattern, -1, -1, null, true, false, null);
    }

    public Deferred<Buffer[]> sort(Buffer key, boolean ascending, boolean alpha) {
        return this.sort(key, null, -1, -1, null, ascending, alpha, null);
    }

    public Deferred<Buffer[]> sort(Buffer key, int offset, int count, boolean ascending, boolean alpha) {
        return this.sort(key, null, offset, count, null, ascending, alpha, null);
    }

    public Deferred<Buffer[]> sort(Buffer key, Buffer pattern, boolean ascending, boolean alpha) {
        return this.sort(key, pattern, -1, -1, null, ascending, alpha, null);
    }

    public Deferred<Buffer[]> sort(Buffer key, Buffer pattern, int offset, int count, Buffer[] getPatterns, boolean ascending, boolean alpha, Buffer storeDestination) {
        int argsLen = 1 + (pattern == null ? 0 : 2) + (offset == -1 ? 0 : 3) + (getPatterns == null ? 0 : 2 * getPatterns.length) + (ascending ? 0 : 1) + (alpha ? 1 : 0) + (storeDestination == null ? 0 : 2);
        Buffer[] args = new Buffer[argsLen];
        args[0] = key;
        int pos = 1;
        if (pattern != null) {
            args[pos++] = Buffer.create(SORT_BY);
            args[pos++] = pattern;
        }
        if (offset != -1) {
            args[pos++] = Buffer.create(LIMIT);
            args[pos++] = this.intToBuffer(offset);
            args[pos++] = this.intToBuffer(count);
        }
        if (getPatterns != null) {
            for (Buffer getPattern : getPatterns) {
                args[pos++] = Buffer.create(SORT_GET);
                args[pos++] = getPattern;
            }
        }
        if (!ascending) {
            args[pos++] = Buffer.create(SORT_DESC);
        }
        if (alpha) {
            args[pos++] = Buffer.create(SORT_ALPHA);
        }
        if (storeDestination != null) {
            args[pos++] = Buffer.create(SORT_STORE);
            args[pos++] = storeDestination;
        }
        return this.createMultiBulkDeferred(SORT_COMMAND, args);
    }

    public Deferred<Buffer> sPop(Buffer key) {
        return this.createBulkDeferred(SPOP_COMMAND, key);
    }

    public Deferred<Buffer> sRandMember(Buffer key) {
        return this.createBulkDeferred(SRANDMEMBER_COMMAND, key);
    }

    public Deferred<Integer> sRem(Buffer key, Buffer ... members) {
        return this.createIntegerDeferred(SREM_COMMAND, this.toBufferArray(key, members));
    }

    public Deferred<Integer> strLen(Buffer key) {
        return this.createIntegerDeferred(STRLEN_COMMAND, key);
    }

    public Deferred<Void> subscribe(Buffer ... channels) {
        return this.doSubscribe(SUBSCRIBE_COMMAND, channels);
    }

    public Deferred<Buffer[]> sUnion(Buffer ... keys) {
        return this.createMultiBulkDeferred(SUNION_COMMAND, keys);
    }

    public Deferred<Integer> sUnionStore(Buffer destination, Buffer ... keys) {
        return this.createIntegerDeferred(SUNIONSTORE_COMMAND, this.toBufferArray(destination, keys));
    }

    public Deferred<Integer> ttl(Buffer key) {
        return this.createIntegerDeferred(TTL_COMMAND, key);
    }

    public Deferred<String> type(Buffer key) {
        return this.createStringDeferred(TYPE_COMMAND, key);
    }

    public Deferred<Void> unsubscribe(Buffer ... channels) {
        return this.doUnsubscribe(UNSUBSCRIBE_COMMAND, channels);
    }

    public Deferred<Void> unwatch() {
        return this.createVoidDeferred(UNWATCH_COMMAND, new Buffer[0]);
    }

    public Deferred<Void> watch(Buffer ... keys) {
        return this.createVoidDeferred(WATCH_COMMAND, keys);
    }

    public Deferred<Integer> zAdd(Buffer key, Map<Double, Buffer> map) {
        return this.createIntegerDeferred(ZADD_COMMAND, this.toBufferArray(key, this.toBufferArrayD(map)));
    }

    public Deferred<Integer> zAdd(Buffer key, double score, Buffer member) {
        return this.createIntegerDeferred(ZADD_COMMAND, key, this.doubleToBuffer(score), member);
    }

    public Deferred<Integer> zCard(Buffer key) {
        return this.createIntegerDeferred(ZCARD_COMMAND, key);
    }

    public Deferred<Integer> zCount(Buffer key, double min, double max) {
        return this.createIntegerDeferred(ZCOUNT_COMMAND, key, this.doubleToBuffer(min), this.doubleToBuffer(max));
    }

    public Deferred<Double> zIncrBy(Buffer key, double increment, Buffer member) {
        return this.createDoubleDeferred(ZINCRBY_COMMAND, key, this.doubleToBuffer(increment), member);
    }

    public Deferred<Integer> zInterStore(Buffer destination, int numKeys, Buffer[] keys, double[] weights, AggregateType aggType) {
        int argsLen = 2 + keys.length + (weights != null ? 1 + weights.length : 0) + 2;
        Buffer[] args = new Buffer[argsLen];
        args[0] = destination;
        args[1] = this.intToBuffer(numKeys);
        int pos = 2;
        for (Buffer key : keys) {
            args[pos++] = key;
        }
        if (weights != null) {
            args[pos++] = Buffer.create(WEIGHTS);
            for (double weight : weights) {
                args[pos++] = this.doubleToBuffer(weight);
            }
        }
        args[pos++] = Buffer.create(AGGREGRATE);
        args[pos] = Buffer.create(aggType.toString());
        return this.createIntegerDeferred(ZINTERSTORE_COMMAND, args);
    }

    public Deferred<Buffer[]> zRange(Buffer key, int start, int stop, boolean withScores) {
        Buffer[] args = new Buffer[3 + (withScores ? 1 : 0)];
        args[0] = key;
        args[1] = this.intToBuffer(start);
        args[2] = this.intToBuffer(stop);
        if (withScores) {
            args[3] = Buffer.create(WITHSCORES);
        }
        return this.createMultiBulkDeferred(ZRANGE_COMMAND, args);
    }

    public Deferred<Buffer[]> zRangeByScore(Buffer key, double min, double max, boolean withScores, int offset, int count) {
        Buffer[] args = new Buffer[3 + (withScores ? 1 : 0) + (offset != -1 ? 3 : 0)];
        args[0] = key;
        args[1] = this.doubleToBuffer(min);
        args[2] = this.doubleToBuffer(max);
        int pos = 3;
        if (withScores) {
            args[pos++] = Buffer.create(WITHSCORES);
        }
        if (offset != -1) {
            args[pos++] = Buffer.create(LIMIT);
            args[pos++] = this.intToBuffer(offset);
            args[pos++] = this.intToBuffer(count);
        }
        return this.createMultiBulkDeferred(ZRANGEBYSCORE_COMMAND, args);
    }

    public Deferred<Integer> zRank(Buffer key, Buffer member) {
        return this.createIntegerDeferred(ZRANK_COMMAND, key, member);
    }

    public Deferred<Integer> zRem(Buffer key, Buffer ... members) {
        return this.createIntegerDeferred(ZREM_COMMAND, this.toBufferArray(key, members));
    }

    public Deferred<Integer> zRemRangeByRank(Buffer key, int start, int stop) {
        return this.createIntegerDeferred(ZREMRANGEBYRANK_COMMAND, key, this.intToBuffer(start), this.intToBuffer(stop));
    }

    public Deferred<Integer> zRemRangeByScore(Buffer key, double min, double max) {
        return this.createIntegerDeferred(ZREMRANGEBYSCORE_COMMAND, key, this.doubleToBuffer(min), this.doubleToBuffer(max));
    }

    public Deferred<Buffer[]> zRevRange(Buffer key, int start, int stop, boolean withScores) {
        Buffer[] args = new Buffer[3 + (withScores ? 1 : 0)];
        args[0] = key;
        args[1] = this.intToBuffer(start);
        args[2] = this.intToBuffer(stop);
        if (withScores) {
            args[3] = Buffer.create(WITHSCORES);
        }
        return this.createMultiBulkDeferred(ZREVRANGE_COMMAND, args);
    }

    public Deferred<Buffer[]> zRevRangeByScore(Buffer key, double min, double max, boolean withScores, int offset, int count) {
        Buffer[] args = new Buffer[3 + (withScores ? 1 : 0) + (offset != -1 ? 3 : 0)];
        args[0] = key;
        args[1] = this.doubleToBuffer(min);
        args[2] = this.doubleToBuffer(max);
        int pos = 3;
        if (withScores) {
            args[pos++] = Buffer.create(WITHSCORES);
        }
        if (offset != -1) {
            args[pos++] = Buffer.create(LIMIT);
            args[pos++] = this.intToBuffer(offset);
            args[pos] = this.intToBuffer(count);
        }
        return this.createMultiBulkDeferred(ZREVRANGEBYSCORE_COMMAND, args);
    }

    public Deferred<Integer> zRevRank(Buffer key, Buffer member) {
        return this.createIntegerDeferred(ZREVRANK_COMMAND, key, member);
    }

    public Deferred<Double> zScore(Buffer key, Buffer member) {
        return this.createDoubleDeferred(ZSCORE_COMMAND, key, member);
    }

    public Deferred<Integer> zUnionStore(Buffer destination, int numKeys, Buffer[] keys, double[] weights, AggregateType aggType) {
        int argsLen = 2 + keys.length + (weights != null ? 1 + weights.length : 0) + 2;
        Buffer[] args = new Buffer[argsLen];
        args[0] = destination;
        args[1] = this.intToBuffer(numKeys);
        int pos = 2;
        for (Buffer key : keys) {
            args[pos++] = key;
        }
        if (weights != null) {
            args[pos++] = Buffer.create(WEIGHTS);
            for (double weight : weights) {
                args[pos++] = this.doubleToBuffer(weight);
            }
        }
        args[pos++] = Buffer.create(AGGREGRATE);
        args[pos] = Buffer.create(aggType.toString());
        return this.createIntegerDeferred(ZUNIONSTORE_COMMAND, args);
    }

    private Deferred<Void> doSubscribe(final byte[] command, final Buffer ... channels) {
        return new RedisDeferred<Void>(RedisDeferred.DeferredType.VOID, this){

            @Override
            public void run() {
                Buffer buff = RedisConnection.this.createCommand(command, channels);
                this.rc.conn.sendRequest(this, buff, true, this.contextID);
            }

            @Override
            public void handleReply(RedisReply reply) {
                this.rc.conn.subscribe(this.contextID);
                this.setResult(null);
            }
        };
    }

    private Deferred<Void> doUnsubscribe(byte[] command, Buffer ... channels) {
        final Buffer buff = this.createCommand(command, channels);
        return new RedisDeferred<Void>(RedisDeferred.DeferredType.VOID, this){

            @Override
            public void run() {
                this.rc.conn.sendRequest(this, buff, true, this.contextID);
            }

            @Override
            public void handleReply(RedisReply reply) {
                int num = reply.intResult;
                if (num == 0) {
                    this.rc.conn.unsubscribe();
                }
                this.setResult(null);
            }
        };
    }

    private Buffer createCommand(byte[] command, Buffer ... args) {
        Buffer buff = Buffer.create(64);
        buff.appendByte((byte)42);
        buff.appendString(String.valueOf(args.length + 1));
        buff.appendBytes(ReplyParser.CRLF);
        buff.appendByte((byte)36);
        buff.appendString(String.valueOf(command.length));
        buff.appendBytes(ReplyParser.CRLF);
        buff.appendBytes(command);
        buff.appendBytes(ReplyParser.CRLF);
        for (int i = 0; i < args.length; ++i) {
            buff.appendByte((byte)36);
            Buffer arg = args[i];
            buff.appendString(String.valueOf(arg.length()));
            buff.appendBytes(ReplyParser.CRLF);
            buff.appendBuffer(arg);
            buff.appendBytes(ReplyParser.CRLF);
        }
        return buff;
    }

    private RedisDeferred<Double> createDoubleDeferred(final byte[] command, final Buffer ... args) {
        return new RedisDeferred<Double>(RedisDeferred.DeferredType.DOUBLE, this){

            @Override
            public void run() {
                Buffer buff = RedisConnection.this.createCommand(command, args);
                this.rc.conn.sendRequest(this, buff, this.contextID);
            }
        };
    }

    private RedisDeferred<Integer> createIntegerDeferred(final byte[] command, final Buffer ... args) {
        return new RedisDeferred<Integer>(RedisDeferred.DeferredType.INTEGER, this){

            @Override
            public void run() {
                Buffer buff = RedisConnection.this.createCommand(command, args);
                this.rc.conn.sendRequest(this, buff, this.contextID);
            }
        };
    }

    private RedisDeferred<Void> createVoidDeferred(final byte[] command, final Buffer ... args) {
        return new RedisDeferred<Void>(RedisDeferred.DeferredType.VOID, this){

            @Override
            public void run() {
                Buffer buff = RedisConnection.this.createCommand(command, args);
                this.rc.conn.sendRequest(this, buff, this.contextID);
            }
        };
    }

    private RedisDeferred<String> createStringDeferred(final byte[] command, final Buffer ... args) {
        return new RedisDeferred<String>(RedisDeferred.DeferredType.STRING, this){

            @Override
            public void run() {
                Buffer buff = RedisConnection.this.createCommand(command, args);
                this.rc.conn.sendRequest(this, buff, this.contextID);
            }
        };
    }

    private RedisDeferred<Boolean> createBooleanDeferred(final byte[] command, final Buffer ... args) {
        return new RedisDeferred<Boolean>(RedisDeferred.DeferredType.BOOLEAN, this){

            @Override
            public void run() {
                Buffer buff = RedisConnection.this.createCommand(command, args);
                this.rc.conn.sendRequest(this, buff, this.contextID);
            }
        };
    }

    private RedisDeferred<Buffer> createBulkDeferred(final byte[] command, final Buffer ... args) {
        return new RedisDeferred<Buffer>(RedisDeferred.DeferredType.BULK, this){

            @Override
            public void run() {
                Buffer buff = RedisConnection.this.createCommand(command, args);
                this.rc.conn.sendRequest(this, buff, this.contextID);
            }
        };
    }

    private RedisDeferred<Buffer[]> createMultiBulkDeferred(final byte[] command, final Buffer ... args) {
        return new RedisDeferred<Buffer[]>(RedisDeferred.DeferredType.MULTI_BULK, this){

            @Override
            public void run() {
                Buffer buff = RedisConnection.this.createCommand(command, args);
                RedisConnection.this.conn.sendRequest(this, buff, this.contextID);
            }
        };
    }

    private Buffer[] toBufferArray(Buffer[] buffers, Buffer ... others) {
        Buffer[] args = new Buffer[buffers.length + others.length];
        System.arraycopy(buffers, 0, args, 0, buffers.length);
        System.arraycopy(others, 0, args, buffers.length, others.length);
        return args;
    }

    private Buffer[] toBufferArray(Buffer firstBuff, Buffer ... others) {
        Buffer[] args = new Buffer[1 + others.length];
        args[0] = firstBuff;
        System.arraycopy(others, 0, args, 1, others.length);
        return args;
    }

    private Buffer[] toBufferArray(Map<Buffer, Buffer> map) {
        Buffer[] buffs = new Buffer[map.size() * 2];
        int pos = 0;
        for (Map.Entry<Buffer, Buffer> entry : map.entrySet()) {
            buffs[pos++] = entry.getKey();
            buffs[pos++] = entry.getValue();
        }
        return buffs;
    }

    private Buffer[] toBufferArrayD(Map<Double, Buffer> map) {
        Buffer[] buffs = new Buffer[map.size() * 2];
        int pos = 0;
        for (Map.Entry<Double, Buffer> entry : map.entrySet()) {
            buffs[pos++] = Buffer.create(entry.getKey().toString());
            buffs[pos++] = entry.getValue();
        }
        return buffs;
    }

    private Buffer[] toBufferArray(String[] strs) {
        Buffer[] buffs = new Buffer[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            buffs[i] = Buffer.create(strs[i]);
        }
        return buffs;
    }

    private Buffer intToBuffer(int i) {
        return Buffer.create(String.valueOf(i));
    }

    private Buffer doubleToBuffer(double d) {
        return Buffer.create(String.valueOf(d));
    }

    private void getConnection() {
        if (!this.connectionRequested) {
            this.pool.getConnection(new Handler<InternalConnection>(){

                @Override
                public void handle(InternalConnection conn) {
                    RedisConnection.this.setConnection(conn);
                }
            }, NodexInternal.instance.getContextID());
            this.connectionRequested = true;
        }
    }

    private void setConnection(InternalConnection conn) {
        this.conn = conn;
        if (this.password != null) {
            this.auth(Buffer.create(this.password)).execute();
        }
        for (RedisDeferred redisDeferred : this.pending) {
            redisDeferred.execute();
        }
        this.pending.clear();
        if (this.subscriberHandler != null) {
            conn.subscriberHandler = this.subscriberHandler;
        }
        if (this.closeDeferred != null) {
            conn.close(this.closeDeferred);
            this.closeDeferred = null;
        }
    }

    public static enum AggregateType {
        SUM,
        MIN,
        MAX;

    }
}

