/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.addons.redis;

import java.util.LinkedList;
import java.util.Queue;
import org.nodex.java.addons.redis.RedisDeferred;
import org.nodex.java.addons.redis.RedisException;
import org.nodex.java.addons.redis.RedisReply;
import org.nodex.java.addons.redis.ReplyHandler;
import org.nodex.java.addons.redis.ReplyParser;
import org.nodex.java.core.ConnectionPool;
import org.nodex.java.core.DeferredAction;
import org.nodex.java.core.Handler;
import org.nodex.java.core.buffer.Buffer;
import org.nodex.java.core.internal.NodexInternal;
import org.nodex.java.core.net.NetSocket;

public class InternalConnection
implements Handler<RedisReply> {
    private final LinkedList<ReplyHandler> deferredQueue = new LinkedList();
    private final NetSocket socket;
    private final ConnectionPool<InternalConnection> pool;
    private TxReplyHandler currentTXSendingHandler;
    private boolean subscriber;
    private ReplyHandler currentReplyHandler;
    Handler<Buffer> subscriberHandler;

    InternalConnection(ConnectionPool<InternalConnection> pool, NetSocket socket) {
        this.pool = pool;
        this.socket = socket;
        socket.dataHandler(new ReplyParser(this));
    }

    void close(DeferredAction<Void> deferred) {
        if (this.subscriber) {
            deferred.setException(new RedisException("Please unsubscribe from all channels before closing connection"));
        } else if (this.currentTXSendingHandler != null) {
            deferred.setException(new RedisException("Please complete the transaction before closing connection"));
        } else {
            this.pool.returnConnection(this);
            deferred.setResult(null);
        }
    }

    void sendRequest(RedisDeferred<?> deferred, Buffer buffer, long contextID) {
        this.sendRequest(deferred, buffer, false, contextID);
    }

    void sendRequest(RedisDeferred<?> deferred, Buffer buffer, boolean subscribe, long contextID) {
        if (this.subscriber && !subscribe) {
            deferred.setException(new RedisException("It is not legal to send commands other than SUBSCRIBE and UNSUBSCRIBE when in subscribe mode"));
        } else {
            switch (deferred.commandType) {
                case MULTI: {
                    if (this.currentTXSendingHandler != null) {
                        throw new IllegalStateException("Already in tx");
                    }
                    this.deferredQueue.add(deferred);
                    this.currentTXSendingHandler = new TxReplyHandler(contextID);
                    this.deferredQueue.add(this.currentTXSendingHandler);
                    break;
                }
                case EXEC: {
                    if (this.currentTXSendingHandler == null) {
                        throw new IllegalStateException("Not in tx");
                    }
                    this.currentTXSendingHandler.endDeferred = deferred;
                    this.currentTXSendingHandler = null;
                    break;
                }
                case DISCARD: {
                    if (this.currentTXSendingHandler == null) {
                        throw new IllegalStateException("Not in tx");
                    }
                    this.currentTXSendingHandler.endDeferred = deferred;
                    this.currentTXSendingHandler.discarded = true;
                    this.currentTXSendingHandler = null;
                    break;
                }
                case OTHER: {
                    if (this.currentTXSendingHandler != null) {
                        this.currentTXSendingHandler.deferreds.add(deferred);
                        break;
                    }
                    this.deferredQueue.add(deferred);
                }
            }
            this.socket.write(buffer);
        }
    }

    @Override
    public void handle(RedisReply reply) {
        if (this.currentReplyHandler != null) {
            this.currentReplyHandler.handleReply(reply);
        } else {
            ReplyHandler handler = this.deferredQueue.poll();
            if (handler == null) {
                System.err.println("Unsolicited response");
            } else {
                handler.handleReply(reply);
            }
        }
    }

    void subscribe(long contextID) {
        if (!this.subscriber) {
            this.subscriber = true;
            this.currentReplyHandler = new SubscriberHandler(contextID);
        }
    }

    void unsubscribe() {
        if (this.subscriber) {
            this.subscriber = false;
            this.currentReplyHandler = null;
        }
    }

    private void deliverMessage(Buffer msg) {
        if (this.subscriberHandler != null) {
            this.subscriberHandler.handle(msg);
        }
    }

    private class TxReplyHandler
    extends BaseReplyHandler {
        final Queue<RedisDeferred<?>> deferreds;
        RedisDeferred<?> endDeferred;
        boolean discarded;

        TxReplyHandler(long contextID) {
            super(contextID);
            this.deferreds = new LinkedList();
        }

        @Override
        public void run() {
            InternalConnection.this.currentReplyHandler = this;
            if (this.reply.type == RedisReply.Type.ONE_LINE && this.reply.line.equals("QUEUED")) {
                return;
            }
            if (this.discarded) {
                for (RedisDeferred redisDeferred : this.deferreds) {
                    redisDeferred.setException(new RedisException("Transaction discarded"));
                }
                this.sendEnd();
            } else {
                RedisDeferred<?> deferred = this.deferreds.poll();
                if (deferred != null) {
                    deferred.handleReplyDirect(this.reply);
                    if (this.deferreds.isEmpty()) {
                        this.sendEnd();
                    }
                } else {
                    this.sendEnd();
                }
            }
        }

        private void sendEnd() {
            if (this.endDeferred == null) {
                throw new IllegalStateException("Invalid tx response");
            }
            this.endDeferred.setResult(null);
            this.endDeferred = null;
            InternalConnection.this.currentReplyHandler = null;
        }
    }

    private class SubscriberHandler
    extends BaseReplyHandler {
        SubscriberHandler(long contextID) {
            super(contextID);
        }

        @Override
        public void run() {
            block0 : switch (this.reply.type) {
                case INTEGER: {
                    ReplyHandler handler = (ReplyHandler)InternalConnection.this.deferredQueue.poll();
                    if (handler == null) {
                        System.err.println("Protocol error");
                        break;
                    }
                    handler.handleReply(this.reply);
                    break;
                }
                case MULTI_BULK: {
                    String type;
                    switch (type = this.reply.multiBulkResult[0].toString()) {
                        case "message": {
                            InternalConnection.this.deliverMessage(this.reply.multiBulkResult[2]);
                            break block0;
                        }
                        case "pmessage": {
                            InternalConnection.this.deliverMessage(this.reply.multiBulkResult[3]);
                        }
                    }
                }
            }
        }
    }

    private abstract class BaseReplyHandler
    implements Runnable,
    ReplyHandler {
        final long contextID;
        RedisReply reply;

        BaseReplyHandler(long contextID) {
            this.contextID = contextID;
        }

        @Override
        public abstract void run();

        @Override
        public void handleReply(RedisReply reply) {
            this.reply = reply;
            NodexInternal.instance.executeOnContext(this.contextID, this);
        }
    }
}

