/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.addons.old.stomp;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.nodex.java.addons.old.stomp.Frame;
import org.nodex.java.addons.old.stomp.FrameHandler;
import org.nodex.java.addons.old.stomp.StompConnection;
import org.nodex.java.addons.old.stomp.StompServerConnection;
import org.nodex.java.core.Handler;
import org.nodex.java.core.net.NetServer;
import org.nodex.java.core.net.NetSocket;

public class StompServer {
    public static NetServer createServer() {
        return new NetServer().connectHandler(new Handler<NetSocket>(){
            private ConcurrentMap<String, List<StompConnection>> subscriptions = new ConcurrentHashMap<String, List<StompConnection>>();

            private synchronized void subscribe(String dest, StompConnection conn) {
                CopyOnWriteArrayList<StompConnection> conns = (CopyOnWriteArrayList<StompConnection>)this.subscriptions.get(dest);
                if (conns == null) {
                    conns = new CopyOnWriteArrayList<StompConnection>();
                    this.subscriptions.put(dest, conns);
                }
                conns.add(conn);
            }

            private synchronized void unsubscribe(String dest, StompConnection conn) {
                List conns = (List)this.subscriptions.get(dest);
                if (conns == null) {
                    conns.remove(conn);
                    if (conns.isEmpty()) {
                        this.subscriptions.remove(dest);
                    }
                }
            }

            private void checkReceipt(Frame frame, StompConnection conn) {
                String receipt = frame.headers.get("receipt");
                if (receipt != null) {
                    conn.write(Frame.receiptFrame(receipt));
                }
            }

            @Override
            public void handle(NetSocket sock) {
                final StompServerConnection conn = new StompServerConnection(sock);
                conn.frameHandler(new FrameHandler(){

                    @Override
                    public void onFrame(Frame frame) {
                        if ("CONNECT".equals(frame.command)) {
                            conn.write(Frame.connectedFrame(UUID.randomUUID().toString()));
                            return;
                        }
                        switch (frame.command) {
                            case "SUBSCRIBE": {
                                String dest = frame.headers.get("destination");
                                this.subscribe(dest, conn);
                                break;
                            }
                            case "UNSUBSCRIBE": {
                                String dest = frame.headers.get("destination");
                                this.unsubscribe(dest, conn);
                                break;
                            }
                            case "SEND": {
                                String dest = frame.headers.get("destination");
                                frame.command = "MESSAGE";
                                List conns = (List)subscriptions.get(dest);
                                if (conns == null) break;
                                for (StompConnection conn2 : conns) {
                                    frame.headers.put("message-id", UUID.randomUUID().toString());
                                    conn2.write(frame);
                                }
                                break;
                            }
                        }
                        this.checkReceipt(frame, conn);
                    }
                });
            }
        });
    }
}

