/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.addons.old.stomp;

import java.util.HashMap;
import java.util.Map;
import org.nodex.java.addons.old.stomp.Frame;
import org.nodex.java.addons.old.stomp.FrameHandler;
import org.nodex.java.core.Handler;
import org.nodex.java.core.buffer.Buffer;
import org.nodex.java.core.parsetools.RecordParser;

public class Parser
implements Handler<Buffer> {
    private final FrameHandler output;
    private Map<String, String> headers = new HashMap<String, String>();
    private static final byte[] EOL_DELIM = new byte[]{10};
    private static final byte[] EOM_DELIM = new byte[]{0};
    private final RecordParser frameParser = RecordParser.newDelimited(EOL_DELIM, new Handler<Buffer>(){

        @Override
        public void handle(Buffer line) {
            Parser.this.handleLine(line);
        }
    });
    private String command;
    private boolean inHeaders = true;

    public Parser(FrameHandler output) {
        this.output = output;
    }

    @Override
    public void handle(Buffer buffer) {
        this.frameParser.handle(buffer);
    }

    private void handleLine(Buffer buffer) {
        String line = buffer.toString().trim();
        if (this.inHeaders) {
            if (this.command == null) {
                this.command = line;
            } else if ("".equals(line)) {
                this.inHeaders = false;
                String sHeader = this.headers.get("content-length");
                if (sHeader != null) {
                    int contentLength = Integer.valueOf(sHeader);
                    this.frameParser.fixedSizeMode(contentLength);
                } else {
                    this.frameParser.delimitedMode(EOM_DELIM);
                }
            } else {
                String[] aline = line.split(":");
                this.headers.put(aline[0], aline[1]);
            }
        } else {
            Frame frame = new Frame(this.command, this.headers, buffer);
            this.command = null;
            this.headers = new HashMap<String, String>();
            this.inHeaders = true;
            this.frameParser.delimitedMode(EOL_DELIM);
            this.output.onFrame(frame);
        }
    }
}

