/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.addons.old.stomp;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.nodex.java.core.buffer.Buffer;

class Frame {
    public String command;
    public final Map<String, String> headers;
    public final Buffer body;

    public Frame(String command, Map<String, String> headers, Buffer body) {
        this.command = command;
        this.headers = headers;
        this.body = body;
    }

    public Frame(String command, Buffer body) {
        this.command = command;
        this.headers = new HashMap<String, String>(4);
        this.body = body;
    }

    protected static Frame connectFrame() {
        return Frame.connectFrame(null, null);
    }

    protected static Frame connectFrame(String username, String password) {
        Frame frame = new Frame("CONNECT", null);
        frame.headers.put("login", username);
        frame.headers.put("passcode", password);
        return frame;
    }

    protected static Frame connectedFrame(String sessionID) {
        Frame frame = new Frame("CONNECTED", null);
        frame.headers.put("session", sessionID);
        return frame;
    }

    protected static Frame subscribeFrame(String destination) {
        Frame frame = new Frame("SUBSCRIBE", null);
        frame.headers.put("destination", destination);
        return frame;
    }

    protected static Frame unsubscribeFrame(String destination) {
        Frame frame = new Frame("UNSUBSCRIBE", null);
        frame.headers.put("destination", destination);
        return frame;
    }

    protected static Frame sendFrame(String destination, String body) {
        Buffer buff = Buffer.create(body, "UTF-8");
        Frame frame = new Frame("SEND", buff);
        frame.headers.put("destination", destination);
        frame.headers.put("content-length", String.valueOf(buff.length()));
        return frame;
    }

    protected static Frame sendFrame(String destination, Buffer body) {
        Frame frame = new Frame("SEND", body);
        frame.headers.put("destination", destination);
        frame.headers.put("content-length", String.valueOf(body.length()));
        return frame;
    }

    protected static Frame receiptFrame(String receipt) {
        Frame frame = new Frame("RECEIPT", null);
        frame.headers.put("receipt-id", receipt);
        return frame;
    }

    public Buffer toBuffer() {
        try {
            byte[] bytes = this.headersString().toString().getBytes("UTF-8");
            Buffer buff = Buffer.create(bytes.length + (this.body == null ? 0 : this.body.length()) + 1);
            buff.appendBytes(bytes);
            if (this.body != null) {
                buff.appendBuffer(this.body);
            }
            buff.appendByte((byte)0);
            return buff;
        }
        catch (UnsupportedEncodingException thisWillNeverHappen) {
            return null;
        }
    }

    private StringBuilder headersString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command).append('\n');
        if (this.headers != null) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                sb.append(entry.getKey()).append(':').append(entry.getValue()).append('\n');
            }
        }
        sb.append('\n');
        return sb;
    }

    public String toString() {
        StringBuilder buff = this.headersString();
        if (this.body != null) {
            buff.append(this.body.toString());
        }
        return buff.toString();
    }
}

