/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.addons.old.amqp;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nodex.java.addons.old.amqp.AmqpMsgCallback;
import org.nodex.java.addons.old.amqp.AmqpProps;
import org.nodex.java.core.internal.NodexInternal;

public class Channel {
    private com.rabbitmq.client.Channel channel;
    private Map<String, AmqpMsgCallback> callbacks = new ConcurrentHashMap<String, AmqpMsgCallback>();
    private volatile String responseQueue;

    Channel(com.rabbitmq.client.Channel channel) {
        this.channel = channel;
    }

    public void publish(String exchange, String routingKey, AmqpProps props, byte[] body) {
        try {
            if (props == null) {
                props = new AmqpProps();
            }
            AMQP.BasicProperties aprops = props.toBasicProperties();
            this.channel.basicPublish(exchange, routingKey, aprops, body);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void publish(String exchange, String routingKey, AmqpProps props, String message) {
        try {
            this.publish(exchange, routingKey, props, message.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void declareQueue(final String queueName, final boolean durable, final boolean exclusive, final boolean autoDelete, final Runnable doneCallback) {
        NodexInternal.instance.executeInBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    Channel.this.channel.queueDeclare(queueName, durable, exclusive, autoDelete, null);
                    doneCallback.run();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void subscribe(final String queueName, final boolean autoAck, final AmqpMsgCallback messageCallback) {
        NodexInternal.instance.executeInBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    Channel.this.channel.basicConsume(queueName, autoAck, "blah", (Consumer)new DefaultConsumer(Channel.this.channel){

                        public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                            AmqpProps props = properties == null ? null : new AmqpProps(properties);
                            messageCallback.onMessage(props, body);
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void close(final Runnable doneCallback) {
        NodexInternal.instance.executeInBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    Channel.this.channel.close();
                    doneCallback.run();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

