/*
 * Decompiled with CFR 0.152.
 */
package storm.kafka;

import backtype.storm.metric.api.IMetric;
import backtype.storm.utils.Utils;
import com.google.common.base.Preconditions;
import java.net.ConnectException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kafka.api.FetchRequest;
import kafka.api.FetchRequestBuilder;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.common.TopicAndPartition;
import kafka.javaapi.FetchResponse;
import kafka.javaapi.OffsetRequest;
import kafka.javaapi.consumer.SimpleConsumer;
import kafka.javaapi.message.ByteBufferMessageSet;
import kafka.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import storm.kafka.DynamicPartitionConnections;
import storm.kafka.FailedFetchException;
import storm.kafka.KafkaConfig;
import storm.kafka.KafkaError;
import storm.kafka.KeyValueSchemeAsMultiScheme;
import storm.kafka.Partition;
import storm.kafka.StaticHosts;
import storm.kafka.ZkHosts;
import storm.kafka.trident.GlobalPartitionInformation;
import storm.kafka.trident.IBrokerReader;
import storm.kafka.trident.StaticBrokerReader;
import storm.kafka.trident.ZkBrokerReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KafkaUtils {
    public static final Logger LOG = LoggerFactory.getLogger(KafkaUtils.class);
    private static final int NO_OFFSET = -5;

    public static IBrokerReader makeBrokerReader(Map stormConf, KafkaConfig conf) {
        if (conf.hosts instanceof StaticHosts) {
            return new StaticBrokerReader(((StaticHosts)conf.hosts).getPartitionInformation());
        }
        return new ZkBrokerReader(stormConf, conf.topic, (ZkHosts)conf.hosts);
    }

    public static long getOffset(SimpleConsumer consumer, String topic, int partition, KafkaConfig config) {
        long startOffsetTime = kafka.api.OffsetRequest.LatestTime();
        if (config.forceFromStart) {
            startOffsetTime = config.startOffsetTime;
        }
        return KafkaUtils.getOffset(consumer, topic, partition, startOffsetTime);
    }

    public static long getOffset(SimpleConsumer consumer, String topic, int partition, long startOffsetTime) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
        HashMap<TopicAndPartition, PartitionOffsetRequestInfo> requestInfo = new HashMap<TopicAndPartition, PartitionOffsetRequestInfo>();
        requestInfo.put(topicAndPartition, new PartitionOffsetRequestInfo(startOffsetTime, 1));
        OffsetRequest request = new OffsetRequest(requestInfo, kafka.api.OffsetRequest.CurrentVersion(), consumer.clientId());
        long[] offsets = consumer.getOffsetsBefore(request).offsets(topic, partition);
        if (offsets.length > 0) {
            return offsets[0];
        }
        return -5L;
    }

    public static ByteBufferMessageSet fetchMessages(KafkaConfig config, SimpleConsumer consumer, Partition partition, long offset) {
        ByteBufferMessageSet msgs = null;
        String topic = config.topic;
        int partitionId = partition.partition;
        for (int errors = 0; errors < 2 && msgs == null; ++errors) {
            FetchResponse fetchResponse;
            FetchRequestBuilder builder = new FetchRequestBuilder();
            FetchRequest fetchRequest = builder.addFetch(topic, partitionId, offset, config.fetchSizeBytes).clientId(config.clientId).build();
            try {
                fetchResponse = consumer.fetch(fetchRequest);
            }
            catch (Exception e) {
                if (e instanceof ConnectException) {
                    throw new FailedFetchException(e);
                }
                throw new RuntimeException(e);
            }
            if (fetchResponse.hasError()) {
                KafkaError error = KafkaError.getError(fetchResponse.errorCode(topic, partitionId));
                if (error.equals((Object)KafkaError.OFFSET_OUT_OF_RANGE) && config.useStartOffsetTimeIfOffsetOutOfRange && errors == 0) {
                    long startOffset = KafkaUtils.getOffset(consumer, topic, partitionId, config.startOffsetTime);
                    LOG.warn("Got fetch request with offset out of range: [" + offset + "]; " + "retrying with default start offset time from configuration. " + "configured start offset time: [" + config.startOffsetTime + "] offset: [" + startOffset + "]");
                    offset = startOffset;
                    continue;
                }
                String message = "Error fetching data from [" + partition + "] for topic [" + topic + "]: [" + (Object)((Object)error) + "]";
                LOG.error(message);
                throw new FailedFetchException(message);
            }
            msgs = fetchResponse.messageSet(topic, partitionId);
        }
        return msgs;
    }

    public static Iterable<List<Object>> generateTuples(KafkaConfig kafkaConfig, Message msg) {
        ByteBuffer payload = msg.payload();
        ByteBuffer key = msg.key();
        Iterable<List<Object>> tups = key != null && kafkaConfig.scheme instanceof KeyValueSchemeAsMultiScheme ? ((KeyValueSchemeAsMultiScheme)kafkaConfig.scheme).deserializeKeyAndValue(Utils.toByteArray((ByteBuffer)key), Utils.toByteArray((ByteBuffer)payload)) : kafkaConfig.scheme.deserialize(Utils.toByteArray((ByteBuffer)payload));
        return tups;
    }

    public static List<Partition> calculatePartitionsForTask(GlobalPartitionInformation partitionInformation, int totalTasks, int taskIndex) {
        Preconditions.checkArgument((taskIndex < totalTasks ? 1 : 0) != 0, (Object)"task index must be less that total tasks");
        List<Partition> partitions = partitionInformation.getOrderedPartitions();
        int numPartitions = partitions.size();
        if (numPartitions < totalTasks) {
            LOG.warn("there are more tasks than partitions (tasks: " + totalTasks + "; partitions: " + numPartitions + "), some tasks will be idle");
        }
        ArrayList<Partition> taskPartitions = new ArrayList<Partition>();
        for (int i = taskIndex; i < numPartitions; i += totalTasks) {
            Partition taskPartition = partitions.get(i);
            taskPartitions.add(taskPartition);
        }
        KafkaUtils.logPartitionMapping(totalTasks, taskIndex, taskPartitions);
        return taskPartitions;
    }

    private static void logPartitionMapping(int totalTasks, int taskIndex, List<Partition> taskPartitions) {
        String taskPrefix = "[" + taskIndex + "/" + totalTasks + "] --> ";
        if (taskPartitions.isEmpty()) {
            LOG.warn(taskPrefix + "no partitions assigned");
        } else {
            LOG.info(taskPrefix + "assigned " + taskPartitions);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KafkaOffsetMetric
    implements IMetric {
        Map<Partition, Long> _partitionToOffset = new HashMap<Partition, Long>();
        Set<Partition> _partitions;
        String _topic;
        DynamicPartitionConnections _connections;

        public KafkaOffsetMetric(String topic, DynamicPartitionConnections connections) {
            this._topic = topic;
            this._connections = connections;
        }

        public void setLatestEmittedOffset(Partition partition, long offset) {
            this._partitionToOffset.put(partition, offset);
        }

        public Object getValueAndReset() {
            try {
                long totalSpoutLag = 0L;
                long totalEarliestTimeOffset = 0L;
                long totalLatestTimeOffset = 0L;
                long totalLatestEmittedOffset = 0L;
                HashMap<String, Long> ret = new HashMap<String, Long>();
                if (this._partitions != null && this._partitions.size() == this._partitionToOffset.size()) {
                    for (Map.Entry<Partition, Long> e : this._partitionToOffset.entrySet()) {
                        Partition partition = e.getKey();
                        SimpleConsumer consumer = this._connections.getConnection(partition);
                        if (consumer == null) {
                            LOG.warn("partitionToOffset contains partition not found in _connections. Stale partition data?");
                            return null;
                        }
                        long earliestTimeOffset = KafkaUtils.getOffset(consumer, this._topic, partition.partition, kafka.api.OffsetRequest.EarliestTime());
                        long latestTimeOffset = KafkaUtils.getOffset(consumer, this._topic, partition.partition, kafka.api.OffsetRequest.LatestTime());
                        if (earliestTimeOffset == 0L || latestTimeOffset == 0L) {
                            LOG.warn("No data found in Kafka Partition " + partition.getId());
                            return null;
                        }
                        long latestEmittedOffset = e.getValue();
                        long spoutLag = latestTimeOffset - latestEmittedOffset;
                        ret.put(partition.getId() + "/" + "spoutLag", spoutLag);
                        ret.put(partition.getId() + "/" + "earliestTimeOffset", earliestTimeOffset);
                        ret.put(partition.getId() + "/" + "latestTimeOffset", latestTimeOffset);
                        ret.put(partition.getId() + "/" + "latestEmittedOffset", latestEmittedOffset);
                        totalSpoutLag += spoutLag;
                        totalEarliestTimeOffset += earliestTimeOffset;
                        totalLatestTimeOffset += latestTimeOffset;
                        totalLatestEmittedOffset += latestEmittedOffset;
                    }
                    ret.put("totalSpoutLag", totalSpoutLag);
                    ret.put("totalEarliestTimeOffset", totalEarliestTimeOffset);
                    ret.put("totalLatestTimeOffset", totalLatestTimeOffset);
                    ret.put("totalLatestEmittedOffset", totalLatestEmittedOffset);
                    return ret;
                }
                LOG.info("Metrics Tick: Not enough data to calculate spout lag.");
            }
            catch (Throwable t) {
                LOG.warn("Metrics Tick: Exception when computing kafkaOffset metric.", t);
            }
            return null;
        }

        public void refreshPartitions(Set<Partition> partitions) {
            this._partitions = partitions;
            Iterator<Partition> it = this._partitionToOffset.keySet().iterator();
            while (it.hasNext()) {
                if (partitions.contains(it.next())) continue;
                it.remove();
            }
        }
    }
}

