# pwdprotect

A Clojure library designed to protect passwords in config files.

## Usage

Add dependency to your project.clj file.

```
[com.middlesphere/pwdprotect "2.0.0"]
```

BouncyCastle crypto library should be in classpath in production environment. 
In development environment you can add it in project.clj:
```
            :profiles {
                       :dev      {:dependencies [[org.bouncycastle/bcprov-jdk15on "1.54"]]}
                       :provided {:dependencies [[org.bouncycastle/bcprov-jdk15on "1.54"]]}}
```

First, edit your config file and mark any password like this (ENCRYPT-THIS "to be encrypted")
Quotes around password are mandatory. Warning: only one password is allowed per line!

Second, call encrypt-passwords-in-file function every time you start program before you read config file.
As encryption password should be used a String autogenerated someway in a program.
Example:
```
(pwdprotect.core/encrypt-passwords-in-file "myconfig.properties" (generate-const-password))
```
This function will encrypt all passwords in config file and 
put them as next struture (PROTECTED-DATA "Ua5T4UPIntu9GFvquVduDe4VV/Yg18dOG1n7sp5U5kw=")

Third, to load config file and decrypt all passwords call pwdprotect.core/decrypt-passwords-in-file using a String 
password autogenerated someway in a program:
```
(pwdprotect.core/decrypt-passwords-in-file "myconfig.properties" (generate-const-password))
```
This function return config file with plain passwords, e.g. "to be encrypted" 

Keep your secrets in safe. 

## License

Copyright © 2016 by Middlepshere.

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
