(ns clj-audio.common
  (:gen-class)
  (:require [clojure.edn :as edn]
            [clojure.tools.logging :as log]))

(defmacro safe [bindings? & forms]
  "This macro is used to execute any function inside try-catch block."
  (let [bindings (if (and (even? (count bindings?)) (vector? bindings?))
                   bindings? nil)
        forms (if bindings forms (cons bindings? forms))
        except `(catch Exception e# e#
                  (log/error (.getMessage e#))
                  (.printStackTrace e#))]
    (if bindings
      `(let ~bindings (try ~@forms ~except))
      `(try ~@forms ~except))))


(defn read-config-file
  "This function reads (safely) config file in edn format and returns its content as clojure object."
  [file-name]
  (safe (edn/read-string (slurp file-name))))

