/*
 * Decompiled with CFR 0.152.
 */
package com.guba.mogilefs;

import com.guba.mogilefs.BadHostFormatException;
import com.guba.mogilefs.BaseMogileFSImpl;
import com.guba.mogilefs.NoTrackersException;
import com.guba.mogilefs.PoolableBackendFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class PooledMogileFSImpl
extends BaseMogileFSImpl {
    private int maxTrackerConnections;
    private int maxIdleConnections;
    private long maxIdleTimeMillis;
    private int trackerConnectTimeout = -1;
    private int trackerReadTimeout = -1;
    private int trackerPoolTimeout = 60000;

    public PooledMogileFSImpl(String domain, String[] trackerStrings, int maxTrackerConnections, int maxIdleConnections, long maxIdleTimeMillis) throws NoTrackersException, BadHostFormatException {
        this(domain, trackerStrings, maxTrackerConnections, maxIdleConnections, maxIdleTimeMillis, false);
    }

    public PooledMogileFSImpl(String domain, String[] trackerStrings, int maxTrackerConnections, int maxIdleConnections, long maxIdleTimeMillis, boolean shouldKeepPathOrder) throws NoTrackersException, BadHostFormatException {
        super(domain, trackerStrings, shouldKeepPathOrder);
        this.maxIdleConnections = maxIdleConnections;
        this.maxTrackerConnections = maxTrackerConnections;
        this.maxIdleTimeMillis = maxIdleTimeMillis;
    }

    public void setTrackerTimeouts(int connectTimeout, int readTimeout) {
        this.trackerConnectTimeout = connectTimeout;
        this.trackerReadTimeout = readTimeout;
    }

    public void setTrackerPoolTimeout(int trackerPoolTimeout) {
        this.trackerPoolTimeout = trackerPoolTimeout;
    }

    @Override
    protected ObjectPool buildBackendPool() {
        return new GenericObjectPool((PoolableObjectFactory)new PoolableBackendFactory(this.trackers, this.trackerConnectTimeout, this.trackerReadTimeout), this.maxTrackerConnections, 1, (long)this.trackerPoolTimeout, this.maxIdleConnections, 1, true, true, 20000L, -1, this.maxIdleTimeMillis, true, 5000L);
    }
}

