/*
 * Decompiled with CFR 0.152.
 */
package com.guba.mogilefs;

import com.guba.mogilefs.BadHostFormatException;
import com.guba.mogilefs.MogileException;
import com.guba.mogilefs.MogileFS;
import com.guba.mogilefs.NoTrackersException;
import com.guba.mogilefs.PooledMogileFSImpl;
import com.guba.mogilefs.StorageCommunicationException;
import com.guba.mogilefs.TrackerCommunicationException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class Mogtool {
    public static void main(String[] argv) {
        MogToolOptions options = new MogToolOptions();
        String[] args = options.parse(argv);
        String command = args[0];
        if ("inject".equalsIgnoreCase(command) || "i".equalsIgnoreCase(command)) {
            if (args.length < 3) {
                System.err.println("mogtool inject <filename> <key>");
                return;
            }
            try {
                Mogtool.inject(args[2], options.getStorageClass(), args[1], options.createMogileFS());
            }
            catch (MogileException e) {
                System.err.println("Error trying to inject file: " + e);
                e.printStackTrace();
            }
        } else if ("extract".equalsIgnoreCase(command) || "x".equalsIgnoreCase(command)) {
            if (args.length < 3) {
                System.err.println("mogtool extract <key> <filename>");
                return;
            }
            try {
                Mogtool.extract(args[1], args[2], options.createMogileFS());
            }
            catch (Exception e) {
                System.err.println("Error trying to inject file: " + e);
                e.printStackTrace();
            }
        } else if ("delete".equalsIgnoreCase(command) || "rm".equalsIgnoreCase(command)) {
            if (args.length < 2) {
                System.err.println("mogtool delete <key>");
                return;
            }
            try {
                MogileFS mogfs = options.createMogileFS();
                mogfs.delete(args[1]);
            }
            catch (Exception e) {
                System.err.println("Error deleting file: " + e);
                e.printStackTrace();
            }
        } else if ("locate".equalsIgnoreCase(command) || "lo".equalsIgnoreCase(command)) {
            if (args.length < 2) {
                System.err.println("mogtool locate <key>");
                return;
            }
            try {
                MogileFS mogfs = options.createMogileFS();
                int count = 0;
                for (String path : mogfs.getPaths(args[1], options.getVerify())) {
                    if (path != null) {
                        System.out.println(path);
                        ++count;
                    }
                    System.out.println(MessageFormat.format("#{0} paths found", count));
                }
            }
            catch (Exception e) {
                System.err.println("Error locating file: " + e);
                e.printStackTrace();
            }
        } else if ("list".equalsIgnoreCase(command) || "ls".equalsIgnoreCase(command)) {
            System.err.println("List not supported - we don't really do bigfiles.");
        } else if ("listkey".equalsIgnoreCase(command) || "lsk".equalsIgnoreCase(command)) {
            System.err.println("TODO: listkey not supported yet.");
        } else {
            System.err.println("Unknown command: '" + command + "'");
            options.showUsage();
        }
    }

    private static void extract(String key, String file, MogileFS mogileFS) throws IOException, StorageCommunicationException, TrackerCommunicationException, NoTrackersException {
        mogileFS.getFile(key, new File(file));
    }

    public static void inject(String key, String storageClass, String filename, MogileFS mogileFS) throws MogileException {
        File file = new File(filename);
        System.out.println("storing " + file + " as " + key + " to " + mogileFS);
        mogileFS.storeFile(key, storageClass, file);
    }

    private static class MogToolOptions {
        String[] trackers;
        String storageClass;
        String domain;
        private Options opts = new Options();
        private static final Pattern CONFIG_LINE = Pattern.compile("(\\w+)\\s*=\\s*(.+)");
        private boolean verify = false;

        MogToolOptions() {
            OptionBuilder.withArgName((String)"trackers");
            OptionBuilder.withLongOpt((String)"trackers");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"list of trackers");
            this.opts.addOption(OptionBuilder.create((String)"t"));
            OptionBuilder.withArgName((String)"class");
            OptionBuilder.withLongOpt((String)"class");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"file class");
            this.opts.addOption(OptionBuilder.create((String)"c"));
            OptionBuilder.withArgName((String)"domain");
            OptionBuilder.withLongOpt((String)"domain");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"domain to create them in");
            this.opts.addOption(OptionBuilder.create((String)"d"));
            OptionBuilder.withArgName((String)"configFile");
            OptionBuilder.withLongOpt((String)"config");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"config file");
            this.opts.addOption(OptionBuilder.create((String)"conf"));
            OptionBuilder.withDescription((String)"should locate check the paths");
            OptionBuilder.withLongOpt((String)"verify");
            this.opts.addOption(OptionBuilder.create());
            this.opts.addOption("h", false, "Show help");
        }

        String[] parse(String[] argv) {
            PosixParser parser = new PosixParser();
            boolean fail = false;
            CommandLine line = null;
            try {
                line = parser.parse(this.opts, argv);
            }
            catch (ParseException e) {
                e.printStackTrace();
                fail = true;
            }
            if (fail || line.hasOption("h") || line.getArgList().isEmpty()) {
                this.showUsage();
                System.exit(1);
            }
            Map<String, String> configMap = this.readConfigfiles(this.getConfigFiles(line));
            this.setDomain(configMap.get("domain"));
            this.setTrackers(configMap.get("trackers"));
            this.setVerify(configMap.get("verify"));
            this.setStorageClass(configMap.get("class"));
            this.setDomain(line.getOptionValue("d"));
            this.setTrackers(line.getOptionValue("t"));
            this.setStorageClass(line.getOptionValue("c"));
            if (this.trackers == null) {
                this.showUsage();
                System.err.println("You need to specify both domain and trackers.");
                System.exit(1);
            }
            return line.getArgs();
        }

        private void setVerify(String ver) {
            if (ver != null) {
                this.verify = true;
            }
        }

        private void setDomain(String val) {
            if (val != null) {
                this.domain = val;
            }
        }

        private void setTrackers(String val) {
            if (val != null) {
                this.trackers = val.split("\\s*,\\s*");
            }
        }

        public void setStorageClass(String val) {
            if (val != null) {
                this.storageClass = val;
            }
        }

        private List<String> getConfigFiles(CommandLine line) {
            LinkedList<String> ret = new LinkedList<String>();
            ret.add(line.getOptionValue("conf"));
            ret.add(System.getenv("HOME") + "/.mogtool");
            ret.add("/etc/mogilefs/mogtool.conf");
            return ret;
        }

        private Map<String, String> readConfigfiles(List<String> files) {
            HashMap<String, String> ret = new HashMap<String, String>();
            for (String file : files) {
                if (file == null) continue;
                this.parseFile(ret, file);
            }
            return ret;
        }

        private void parseFile(Map<String, String> ret, String file) {
            try {
                String line;
                BufferedReader r = new BufferedReader(new FileReader(file));
                while ((line = r.readLine()) != null) {
                    Matcher matcher = CONFIG_LINE.matcher(line.replaceAll("#.*", ""));
                    if (!matcher.matches()) continue;
                    String key = matcher.group(1);
                    String value = matcher.group(2);
                    if (ret.containsKey(key)) continue;
                    ret.put(key, value);
                }
            }
            catch (FileNotFoundException e) {
                System.err.println("Unable to open " + file);
            }
            catch (IOException e) {
                System.err.println("Unable to read " + file);
            }
        }

        public void showUsage() {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("mogTool <command> ...", "", this.opts, "\nCommand is one of:\n- inject thefile.tgz thefilekey\n- extract thefilekey thenewfile.tgz\n- delete thekey\n- locate thekey\n- listkey - TODO\nJust like in the perl mogtool but without bigfiles.");
        }

        protected MogileFS createMogileFS() throws NoTrackersException, BadHostFormatException {
            PooledMogileFSImpl mogFs = new PooledMogileFSImpl(this.domain, this.trackers, 5, 2, 30000L);
            mogFs.setMaxRetries(1);
            return mogFs;
        }

        public String getStorageClass() {
            return this.storageClass;
        }

        public boolean getVerify() {
            return this.verify;
        }
    }
}

