/*
 * Decompiled with CFR 0.152.
 */
package com.guba.mogilefs;

import com.guba.mogilefs.Backend;
import com.guba.mogilefs.NoTrackersException;
import com.guba.mogilefs.StorageCommunicationException;
import com.guba.mogilefs.TrackerCommunicationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.pool.ObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MogileOutputStream
extends OutputStream {
    private static final Logger log = LoggerFactory.getLogger(MogileOutputStream.class);
    private ObjectPool backendPool;
    private String domain;
    private String fid;
    private String path;
    private String devid;
    private String key;
    private long totalBytes;
    private Socket socket;
    private OutputStream out;
    private BufferedReader reader;
    private int count;

    public MogileOutputStream(ObjectPool backendPool, String domain, String fid, String path, String devid, String key, long totalBytes, int timeout) throws MalformedURLException, StorageCommunicationException {
        this.backendPool = backendPool;
        this.domain = domain;
        this.fid = fid;
        this.path = path;
        this.devid = devid;
        this.key = key;
        this.totalBytes = totalBytes;
        this.count = 0;
        try {
            this.socket = new Socket();
            this.socket.setSoTimeout(timeout);
            URL parsedPath = new URL(path);
            this.socket.connect(new InetSocketAddress(parsedPath.getHost(), parsedPath.getPort()), timeout);
            this.out = this.socket.getOutputStream();
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            OutputStreamWriter writer = new OutputStreamWriter(this.out);
            writer.write("PUT ");
            writer.write(parsedPath.getPath());
            writer.write(" HTTP/1.0\r\nContent-length: ");
            writer.write(Long.toString(totalBytes));
            writer.write("\r\n\r\n");
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            this.close1();
            throw new StorageCommunicationException("problem initiating communication with storage server before storing " + path + ": " + e.getMessage(), e);
        }
    }

    public SocketChannel getChannel() {
        return this.socket.getChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.out == null || this.socket == null) {
            throw new IOException("socket has been closed already");
        }
        try {
            this.out.flush();
            String response = this.reader.readLine();
            if (response == null) {
                throw new IOException("no response after putting file to " + this.path.toString());
            }
            Pattern validResponse = Pattern.compile("^HTTP/\\d+\\.\\d+\\s+(\\d+)");
            Matcher matcher = validResponse.matcher(response);
            if (!matcher.find()) {
                throw new IOException("response from put to " + this.path.toString() + " not understood: " + response);
            }
            int responseCode = Integer.parseInt(matcher.group(1));
            if (responseCode < 200 || responseCode > 299) {
                StringBuilder fullResponse = new StringBuilder();
                fullResponse.append("Problem storing to ");
                fullResponse.append(this.path.toString());
                fullResponse.append("\n\n");
                fullResponse.append(response);
                fullResponse.append("\n");
                while ((response = this.reader.readLine()) != null) {
                    fullResponse.append(response);
                    fullResponse.append("\n");
                }
                throw new IOException(fullResponse.toString());
            }
        }
        finally {
            this.close1();
        }
        Backend backend = null;
        try {
            backend = this.borrowBackend();
            Map<String, String> closeResponse = backend.doRequest("create_close", new String[]{"fid", this.fid, "devid", this.devid, "domain", this.domain, "size", Long.toString(this.totalBytes), "key", this.key, "path", this.path});
            if (closeResponse == null) {
                throw new IOException(backend.getLastErrStr());
            }
        }
        catch (IOException e) {
            if (backend != null) {
                this.invalidateBackend(backend);
                backend = null;
            }
            throw e;
        }
        catch (NoTrackersException e) {
            if (backend != null) {
                this.invalidateBackend(backend);
                backend = null;
            }
            throw new IOException(e.getMessage());
        }
        catch (TrackerCommunicationException e) {
            if (backend != null) {
                this.invalidateBackend(backend);
                backend = null;
            }
            throw new IOException(e.getMessage());
        }
        finally {
            if (backend != null) {
                this.returnBackend(backend);
            }
        }
    }

    private void close1() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
            this.out = null;
        }
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
            this.reader = null;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
            this.socket = null;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.out == null || this.socket == null) {
            throw new IOException("socket has been closed already");
        }
        this.out.flush();
    }

    @Override
    public void write(int b) throws IOException {
        if (this.out == null || this.socket == null) {
            throw new IOException("socket has been closed already");
        }
        try {
            ++this.count;
            this.out.write(b);
        }
        catch (IOException e) {
            log.error("wrote at most " + this.count + "/" + this.totalBytes + " of stream to storage node " + this.socket.getInetAddress().getHostName());
            throw e;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.out == null || this.socket == null) {
            throw new IOException("socket has been closed already");
        }
        try {
            this.count += len;
            this.out.write(b, off, len);
        }
        catch (IOException e) {
            log.error("wrote at most " + this.count + "/" + this.totalBytes + " of stream to storage node " + this.socket.getInetAddress().getHostName());
            throw e;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    private Backend borrowBackend() throws NoTrackersException {
        try {
            return (Backend)this.backendPool.borrowObject();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new NoTrackersException();
        }
    }

    private void returnBackend(Backend backend) {
        try {
            this.backendPool.returnObject((Object)backend);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    private void invalidateBackend(Backend backend) {
        try {
            this.backendPool.invalidateObject((Object)backend);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }
}

