/*
 * Decompiled with CFR 0.152.
 */
package com.guba.mogilefs;

import com.guba.mogilefs.BadHostFormatException;
import com.guba.mogilefs.MogileException;
import com.guba.mogilefs.MogileFS;
import com.guba.mogilefs.NoTrackersException;
import com.guba.mogilefs.StorageCommunicationException;
import com.guba.mogilefs.TrackerCommunicationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileMogileFSImpl
implements MogileFS {
    private static final Logger log = LoggerFactory.getLogger(LocalFileMogileFSImpl.class);
    private File topDir;
    private String domain;
    private File domainDir;

    public LocalFileMogileFSImpl(File topDir, String domain) throws IOException {
        this.topDir = topDir;
        this.domain = domain;
        if (!topDir.exists()) {
            throw new FileNotFoundException(topDir.getAbsolutePath());
        }
        this.domainDir = new File(topDir, domain);
        if (!this.domainDir.exists() && !this.domainDir.mkdir()) {
            throw new FileNotFoundException(this.domainDir.getAbsolutePath());
        }
    }

    @Override
    public void reload(String domain, String[] trackerStrings) throws NoTrackersException, BadHostFormatException {
        this.domain = domain;
        this.domainDir = new File(this.topDir, domain);
        if (!this.domainDir.exists() && !this.domainDir.mkdir()) {
            log.error("couldn't make dir " + this.domainDir.getAbsolutePath());
            throw new NoTrackersException();
        }
    }

    @Override
    public OutputStream newFile(String key, String storageClass, long byteCount) throws NoTrackersException, TrackerCommunicationException, StorageCommunicationException {
        File file = new File(this.domainDir, key);
        file.getParentFile().mkdirs();
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    throw new RuntimeException("Problem storing: can't create " + file);
                }
            }
            catch (IOException e) {
                throw new StorageCommunicationException("Problem getting access to " + file);
            }
        }
        try {
            return new FileOutputStream(file);
        }
        catch (IOException e) {
            throw new StorageCommunicationException("couldn't open file " + file.getAbsolutePath());
        }
    }

    @Override
    public void storeFile(String key, String storageClass, File file) throws MogileException {
        if (!file.exists()) {
            throw new IllegalArgumentException("File " + file + " does not exist");
        }
        File storedFile = new File(this.domainDir, key);
        storedFile.getParentFile().mkdirs();
        try {
            if (!storedFile.exists() && !storedFile.createNewFile()) {
                throw new MogileException("Can't create " + storedFile);
            }
            FileOutputStream out = new FileOutputStream(storedFile);
            FileInputStream in = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            int count = 0;
            while ((count = in.read(buffer)) >= 0) {
                out.write(buffer, 0, count);
            }
            out.close();
            in.close();
        }
        catch (IOException e) {
            throw new StorageCommunicationException(e.getMessage(), e);
        }
    }

    @Override
    public File getFile(String key, File destination) throws NoTrackersException, TrackerCommunicationException, IOException, StorageCommunicationException {
        File storedFile = new File(this.domainDir, key);
        try {
            FileOutputStream out = new FileOutputStream(destination);
            FileInputStream in = new FileInputStream(storedFile);
            byte[] buffer = new byte[1024];
            int count = 0;
            while ((count = in.read(buffer)) >= 0) {
                out.write(buffer, 0, count);
            }
            out.close();
            in.close();
            return destination;
        }
        catch (IOException e) {
            throw new StorageCommunicationException(e.getMessage());
        }
    }

    @Override
    public byte[] getFileBytes(String key) throws NoTrackersException, TrackerCommunicationException, IOException, StorageCommunicationException {
        File storedFile = new File(this.domainDir, key);
        byte[] buffer = new byte[(int)storedFile.length()];
        int offset = 0;
        int count = 0;
        FileInputStream in = new FileInputStream(storedFile);
        while ((count = in.read(buffer, offset, buffer.length - offset)) >= 0) {
            offset += count;
        }
        return buffer;
    }

    @Override
    public InputStream getFileStream(String key) throws NoTrackersException, TrackerCommunicationException, StorageCommunicationException {
        File storedFile = new File(this.domainDir, key);
        if (!storedFile.exists()) {
            return null;
        }
        try {
            return new FileInputStream(storedFile);
        }
        catch (IOException e) {
            throw new StorageCommunicationException(e);
        }
    }

    @Override
    public URLConnection getURLConnection(String key) throws NoTrackersException, TrackerCommunicationException, StorageCommunicationException {
        try {
            return new URL("file://" + new File(this.domainDir, key).getAbsolutePath()).openConnection();
        }
        catch (IOException e) {
            throw new StorageCommunicationException(e.getMessage());
        }
    }

    @Override
    public void delete(String key) throws NoTrackersException, NoTrackersException {
        File storedFile = new File(this.domainDir, key);
        storedFile.delete();
    }

    @Override
    public void sleep(int seconds) throws NoTrackersException, TrackerCommunicationException {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void rename(String fromKey, String toKey) throws NoTrackersException {
        File fromFile = new File(this.domainDir, fromKey);
        File toFile = new File(this.domainDir, toKey);
        fromFile.renameTo(toFile);
    }

    @Override
    public String[] getPaths(String key, boolean noverify) throws NoTrackersException {
        File storedFile = new File(this.domainDir, key);
        return new String[]{"file://" + storedFile.getAbsolutePath()};
    }

    @Override
    public Object[] listKeys(String key, String after, int limit) throws NoTrackersException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] listKeys(String key) throws NoTrackersException {
        return this.listKeys(key, null, 1000);
    }

    @Override
    public Object[] listKeys(String key, int limit) throws NoTrackersException {
        return this.listKeys(key, null, limit);
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public void setMaxRetries(int maxRetries) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRetryTimeout(int retrySleepTime) {
        throw new UnsupportedOperationException();
    }
}

