/*
 * Decompiled with CFR 0.152.
 */
package com.guba.mogilefs;

import com.guba.mogilefs.Backend;
import com.guba.mogilefs.BadHostFormatException;
import com.guba.mogilefs.MogileException;
import com.guba.mogilefs.MogileFS;
import com.guba.mogilefs.MogileOutputStream;
import com.guba.mogilefs.NoTrackersException;
import com.guba.mogilefs.StorageCommunicationException;
import com.guba.mogilefs.TrackerCommunicationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;
import org.apache.commons.pool.ObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMogileFSImpl
implements MogileFS {
    private static final Logger log = LoggerFactory.getLogger(BaseMogileFSImpl.class);
    private String domain;
    protected List<InetSocketAddress> trackers;
    private ObjectPool cachedBackendPool;
    private int maxRetries = -1;
    private int retrySleepTime = 2000;
    private int httpTimeout = 60000;
    private boolean keepPathOrder;

    public BaseMogileFSImpl(String domain, String[] trackerStrings) throws BadHostFormatException, NoTrackersException {
        this(domain, trackerStrings, false);
    }

    public BaseMogileFSImpl(String domain, String[] trackerStrings, boolean shouldKeepPathOrder) throws BadHostFormatException, NoTrackersException {
        this.keepPathOrder = shouldKeepPathOrder;
        this.trackers = this.parseHosts(trackerStrings);
        this.reload(domain);
    }

    protected List<InetSocketAddress> parseHosts(String[] hostStrings) throws BadHostFormatException {
        if (hostStrings == null) {
            return Collections.emptyList();
        }
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>(hostStrings.length);
        Pattern hostAndPortPattern = Pattern.compile("^(\\S+):(\\d+)$");
        for (int i = 0; i < hostStrings.length; ++i) {
            String hostString = hostStrings[i];
            Matcher m = hostAndPortPattern.matcher(hostString);
            if (!m.matches()) {
                throw new BadHostFormatException(hostString);
            }
            if (log.isDebugEnabled()) {
                log.debug("parsed tracker " + hostString);
            }
            InetSocketAddress addr = new InetSocketAddress(m.group(1), Integer.parseInt(m.group(2)));
            list.add(addr);
        }
        return list;
    }

    @Override
    public void reload(String domain, String[] trackerStrings) throws NoTrackersException, BadHostFormatException {
        this.trackers = this.parseHosts(trackerStrings);
        this.reload(domain);
    }

    protected void reload(String domain) throws NoTrackersException {
        this.domain = domain;
        this.cachedBackendPool = null;
    }

    protected abstract ObjectPool buildBackendPool();

    protected ObjectPool getBackendPool() {
        if (this.cachedBackendPool != null) {
            return this.cachedBackendPool;
        }
        this.cachedBackendPool = this.buildBackendPool();
        return this.cachedBackendPool;
    }

    @Override
    public OutputStream newFile(String key, String storageClass, long byteCount) throws NoTrackersException, TrackerCommunicationException, StorageCommunicationException {
        Backend backend = null;
        try {
            backend = this.borrowBackend();
            Map<String, String> response = backend.doRequest("create_open", new String[]{"domain", this.domain, "class", storageClass, "key", key});
            if (response == null) {
                throw new TrackerCommunicationException(backend.getLastErr() + ", " + backend.getLastErrStr());
            }
            if (response.get("path") == null || response.get("fid") == null) {
                throw new TrackerCommunicationException("create_open response from tracker " + backend.getTracker() + " missing fid or path (err:" + backend.getLastErr() + ", " + backend.getLastErrStr() + ")");
            }
            try {
                MogileOutputStream mogileOutputStream = new MogileOutputStream(this.getBackendPool(), this.domain, response.get("fid"), response.get("path"), response.get("devid"), key, byteCount, this.httpTimeout);
                return mogileOutputStream;
            }
            catch (MalformedURLException e) {
                try {
                    log.warn("error trying to store file with malformed url: " + response.get("path"));
                    throw new TrackerCommunicationException("error trying to store file with malformed url: " + response.get("path"));
                }
                catch (TrackerCommunicationException e2) {
                    if (backend != null) {
                        this.invalidateBackend(backend);
                        backend = null;
                    }
                    throw e2;
                }
            }
        }
        finally {
            if (backend != null) {
                this.returnBackend(backend);
            }
        }
    }

    @Override
    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setHttpTimeout(int httpTimeout) {
        this.httpTimeout = httpTimeout;
    }

    @Override
    public void setRetryTimeout(int retrySleepTime) {
        this.retrySleepTime = retrySleepTime;
    }

    /*
     * Loose catch block
     */
    @Override
    public void storeFile(String key, String storageClass, File file) throws MogileException {
        int attempt = 1;
        Backend backend = null;
        log.debug("About to make " + this.maxRetries + " attempts to store...");
        while (this.maxRetries == -1 || attempt++ <= this.maxRetries) {
            block15: {
                log.debug("Attempt: " + attempt);
                try {
                    backend = this.borrowBackend();
                    Validate.notNull((Object)key, (String)"Key is null");
                    Validate.notNull((Object)this.domain, (String)"domain is null");
                    Validate.notNull((Object)storageClass, (String)"Storage class is null");
                    Map<String, String> response = backend.doRequest("create_open", new String[]{"domain", this.domain, "class", storageClass, "key", key});
                    if (response == null) {
                        log.warn("problem talking to backend: " + backend.getLastErrStr() + " (err: " + backend.getLastErr() + ")");
                        break block15;
                    }
                    try {
                        MogileOutputStream out = new MogileOutputStream(this.getBackendPool(), this.domain, response.get("fid"), response.get("path"), response.get("devid"), key, file.length(), this.httpTimeout);
                        FileInputStream in = new FileInputStream(file);
                        byte[] buffer = new byte[4096];
                        int count = 0;
                        while ((count = in.read(buffer)) >= 0) {
                            out.write(buffer, 0, count);
                        }
                        out.close();
                        in.close();
                        return;
                    }
                    catch (MalformedURLException e) {
                        try {
                            log.warn("error trying to retrieve file with malformed url: " + response.get("path"));
                        }
                        catch (MogileException e2) {
                            log.warn("problem trying to store file on mogile", (Throwable)e2);
                            if (backend != null) {
                                this.invalidateBackend(backend);
                                backend = null;
                            }
                        }
                        catch (IOException e3) {
                            throw new MogileException(e3);
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                        }
                    }
                }
                finally {
                    if (backend != null) {
                        this.returnBackend(backend);
                    }
                }
            }
            log.debug("Didn't work on the " + attempt + " time");
            this.retrySleep();
            log.info("Error storing file to mogile - attempting to reconnect and try again (attempt #" + attempt + ")");
        }
        throw new MogileException("Unable to store file on mogile after multiple attempts");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getFile(String key, File destination) throws NoTrackersException, TrackerCommunicationException, IOException, StorageCommunicationException {
        InputStream in = this.getFileStream(key);
        if (in == null) {
            return null;
        }
        try {
            FileOutputStream out = new FileOutputStream(destination);
            try {
                byte[] buffer = new byte[4096];
                int count = 0;
                while ((count = in.read(buffer)) >= 0) {
                    ((OutputStream)out).write(buffer, 0, count);
                }
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        finally {
            in.close();
        }
        return destination;
    }

    @Override
    public byte[] getFileBytes(String key) throws NoTrackersException, TrackerCommunicationException, IOException, StorageCommunicationException {
        String[] paths = this.getPaths(key, false);
        if (paths == null) {
            if (log.isDebugEnabled()) {
                log.debug("couldn't find paths for " + key);
            }
            return null;
        }
        int startIndex = this.keepPathOrder ? 0 : (int)Math.floor(Math.random() * (double)paths.length);
        int tries = paths.length;
        while (tries-- > 0) {
            String path = paths[startIndex++ % paths.length];
            try {
                URL pathURL = new URL(path);
                if (log.isDebugEnabled()) {
                    log.debug("retrieving file from " + path + " (attempt #" + (paths.length - tries) + ")");
                }
                HttpURLConnection conn = (HttpURLConnection)pathURL.openConnection();
                InputStream in = conn.getInputStream();
                byte[] bytes = new byte[conn.getContentLength()];
                int count = 0;
                for (int offset = 0; offset < bytes.length && (count = in.read(bytes, offset, bytes.length - offset)) > 0; offset += count) {
                }
                return bytes;
            }
            catch (IOException e) {
                log.warn("problem reading file from " + path);
            }
        }
        StringBuilder pathString = new StringBuilder();
        for (int i = 0; i < paths.length; ++i) {
            if (i > 0) {
                pathString.append(", ");
            }
            pathString.append(paths[i]);
        }
        throw new StorageCommunicationException("unable to retrieve file from any storage node: " + pathString);
    }

    @Override
    public InputStream getFileStream(String key) throws NoTrackersException, TrackerCommunicationException, StorageCommunicationException {
        String[] paths = this.getPaths(key, false);
        if (paths == null) {
            return null;
        }
        int startIndex = this.keepPathOrder ? 0 : (int)Math.floor(Math.random() * (double)paths.length);
        int tries = paths.length;
        while (tries-- > 0) {
            String path = paths[startIndex++ % paths.length];
            try {
                URL pathURL = new URL(path);
                if (log.isDebugEnabled()) {
                    log.debug("retrieving file from " + path + " (attempt #" + (paths.length - tries) + ")");
                }
                return pathURL.openStream();
            }
            catch (IOException e) {
                log.warn("problem reading file from " + path);
            }
        }
        StringBuilder pathString = new StringBuilder();
        for (int i = 0; i < paths.length; ++i) {
            if (i > 0) {
                pathString.append(", ");
            }
            pathString.append(paths[i]);
        }
        throw new StorageCommunicationException("unable to retrieve file with key '" + key + "' from any storage node: " + pathString);
    }

    @Override
    public URLConnection getURLConnection(String key) throws NoTrackersException, TrackerCommunicationException, StorageCommunicationException {
        String[] paths = this.getPaths(key, false);
        if (paths == null) {
            return null;
        }
        int startIndex = (int)Math.floor(Math.random() * (double)paths.length);
        int tries = paths.length;
        while (tries-- > 0) {
            String path = paths[startIndex++ % paths.length];
            try {
                URL pathURL = new URL(path);
                if (log.isDebugEnabled()) {
                    log.debug("retrieving file from " + path + " (attempt #" + (paths.hashCode() - tries) + ")");
                }
                URLConnection urlConnection = pathURL.openConnection();
                urlConnection.setConnectTimeout(this.httpTimeout);
                urlConnection.setReadTimeout(this.httpTimeout);
                return urlConnection;
            }
            catch (IOException e) {
                log.warn("problem reading file from " + path);
            }
        }
        StringBuffer pathString = new StringBuffer();
        for (int i = 0; i < paths.length; ++i) {
            if (i > 0) {
                pathString.append(", ");
            }
            pathString.append(paths[i]);
        }
        throw new StorageCommunicationException("unable to retrieve file with key '" + key + "' from any storage node: " + pathString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String key) throws NoTrackersException {
        int attempt = 1;
        Backend backend = null;
        while (this.maxRetries == -1 || attempt++ <= this.maxRetries) {
            try {
                backend = this.borrowBackend();
                backend.doRequest("delete", new String[]{"domain", this.domain, "key", key});
                return;
            }
            catch (TrackerCommunicationException e) {
                log.warn(e.getMessage(), (Throwable)e);
                if (backend != null) {
                    this.invalidateBackend(backend);
                    backend = null;
                }
            }
            finally {
                if (backend != null) {
                    this.returnBackend(backend);
                }
            }
            this.retrySleep();
        }
        throw new NoTrackersException();
    }

    private void retrySleep() {
        if (this.retrySleepTime > 0) {
            try {
                Thread.sleep(this.retrySleepTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sleep(int seconds) throws NoTrackersException, TrackerCommunicationException {
        Backend backend = null;
        try {
            backend = this.borrowBackend();
            backend.doRequest("sleep", new String[]{"duration", Integer.toString(seconds)});
        }
        finally {
            if (backend != null) {
                this.returnBackend(backend);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(String fromKey, String toKey) throws NoTrackersException {
        int attempt = 1;
        Backend backend = null;
        while (this.maxRetries == -1 || attempt++ <= this.maxRetries) {
            try {
                backend = this.borrowBackend();
                backend.doRequest("rename", new String[]{"domain", this.domain, "from_key", fromKey, "to_key", toKey});
                return;
            }
            catch (TrackerCommunicationException e) {
                log.warn(e.getMessage(), (Throwable)e);
                if (backend != null) {
                    this.invalidateBackend(backend);
                    backend = null;
                }
            }
            finally {
                if (backend != null) {
                    this.returnBackend(backend);
                }
            }
            this.retrySleep();
        }
        throw new NoTrackersException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getPaths(String key, boolean noverify) throws NoTrackersException {
        int attempt = 1;
        Backend backend = null;
        while (this.maxRetries == -1 || attempt++ <= this.maxRetries) {
            try {
                backend = this.borrowBackend();
                Map<String, String> response = backend.doRequest("get_paths", new String[]{"domain", this.domain, "key", key, "noverify", noverify ? "1" : "0"});
                if (response == null) {
                    String[] stringArray = null;
                    return stringArray;
                }
                int pathCount = Integer.parseInt(response.get("paths"));
                String[] paths = new String[pathCount];
                for (int i = 1; i <= pathCount; ++i) {
                    String path;
                    paths[i - 1] = path = response.get("path" + i);
                }
                String[] stringArray = paths;
                return stringArray;
            }
            catch (TrackerCommunicationException e) {
                log.warn(e.getMessage(), (Throwable)e);
                if (backend != null) {
                    this.invalidateBackend(backend);
                    backend = null;
                }
            }
            finally {
                if (backend != null) {
                    this.returnBackend(backend);
                }
            }
            this.retrySleep();
        }
        throw new NoTrackersException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] listKeys(String key, String after, int limit) throws NoTrackersException {
        int attempt = 1;
        Backend backend = null;
        while (this.maxRetries == -1 || attempt++ <= this.maxRetries) {
            try {
                backend = this.borrowBackend();
                Map<String, String> response = backend.doRequest("list_keys", new String[]{"domain", this.domain, "prefix", key, "after", after == null ? "" : after});
                if (response == null) {
                    Object[] objectArray = null;
                    return objectArray;
                }
                int keyCount = Integer.parseInt(response.get("key_count"));
                String[] retKeys = new String[keyCount];
                for (int i = 1; i <= keyCount; ++i) {
                    String retKey;
                    retKeys[i - 1] = retKey = response.get("key_" + i);
                }
                Object[] objectArray = new Object[]{retKeys, response.get("after_key")};
                return objectArray;
            }
            catch (TrackerCommunicationException e) {
                log.warn(e.getMessage(), (Throwable)e);
                if (backend != null) {
                    this.invalidateBackend(backend);
                    backend = null;
                }
            }
            finally {
                if (backend != null) {
                    this.returnBackend(backend);
                }
            }
            if (this.retrySleepTime <= 0) continue;
            try {
                Thread.sleep(this.retrySleepTime);
            }
            catch (Exception e) {}
        }
        throw new NoTrackersException();
    }

    @Override
    public Object[] listKeys(String key) throws NoTrackersException {
        return this.listKeys(key, null, 1000);
    }

    @Override
    public Object[] listKeys(String key, int limit) throws NoTrackersException {
        return this.listKeys(key, null, limit);
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    Backend borrowBackend() throws NoTrackersException {
        try {
            ObjectPool backendPool = this.getBackendPool();
            if (log.isDebugEnabled()) {
                log.debug("getting backend (active: " + backendPool.getNumActive() + ", idle: " + backendPool.getNumIdle() + ")");
            }
            Backend backend = (Backend)backendPool.borrowObject();
            if (log.isDebugEnabled()) {
                log.debug("got backend (active: " + backendPool.getNumActive() + ", idle: " + backendPool.getNumIdle() + ")");
            }
            return backend;
        }
        catch (Exception e) {
            log.error("unable to get backend", (Throwable)e);
            throw new NoTrackersException();
        }
    }

    void returnBackend(Backend backend) {
        try {
            ObjectPool backendPool = this.getBackendPool();
            if (log.isDebugEnabled()) {
                log.debug("returning backend (active: " + backendPool.getNumActive() + ", idle: " + backendPool.getNumIdle() + ")");
            }
            backendPool.returnObject((Object)backend);
            if (log.isDebugEnabled()) {
                log.debug("returned backend (active: " + backendPool.getNumActive() + ", idle: " + backendPool.getNumIdle() + ")");
            }
        }
        catch (Exception e) {
            log.warn("unable to return backend", (Throwable)e);
        }
    }

    void invalidateBackend(Backend backend) {
        try {
            ObjectPool backendPool = this.getBackendPool();
            if (log.isDebugEnabled()) {
                log.debug("invalidating backend (active: " + backendPool.getNumActive() + ", idle: " + backendPool.getNumIdle() + ")");
            }
            backendPool.invalidateObject((Object)backend);
            if (log.isDebugEnabled()) {
                log.debug("invalidated backend (active: " + backendPool.getNumActive() + ", idle: " + backendPool.getNumIdle() + ")");
            }
        }
        catch (Exception e) {
            log.warn("unable to invalidate backend", (Throwable)e);
        }
    }
}

