/*
 * Decompiled with CFR 0.152.
 */
package com.guba.mogilefs;

import com.guba.mogilefs.NoTrackersException;
import com.guba.mogilefs.SocketWithReaderAndWriter;
import com.guba.mogilefs.TrackerCommunicationException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.channels.IllegalBlockingModeException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Backend {
    private static final Logger log = LoggerFactory.getLogger(Backend.class);
    private List<InetSocketAddress> hosts;
    private Map<InetSocketAddress, Long> deadHosts;
    private String lastErr;
    private String lastErrStr;
    private SocketWithReaderAndWriter cachedSocket;
    private static final Pattern ERROR_PATTERN = Pattern.compile("^ERR\\s+(\\w+)\\s*(\\S*)");
    private static final int ERR_PART = 1;
    private static final int ERRSTR_PART = 2;
    private Pattern OK_PATTERN = Pattern.compile("^OK\\s+\\d*\\s*(\\S*)");
    private static final int ARGS_PART = 1;
    private int socketConnectTimeout = 3000;
    private int socketReadTimeout = 30000;

    public Backend(List<InetSocketAddress> trackers, boolean connectNow) throws NoTrackersException {
        this.reload(trackers, connectNow);
    }

    public Backend(List<InetSocketAddress> trackers, boolean connectNow, int socketConnectTimeout, int socketReadTimeout) throws NoTrackersException {
        this.setSocketTimeouts(socketConnectTimeout, socketReadTimeout);
        this.reload(trackers, connectNow);
    }

    public void reload(List<InetSocketAddress> trackers, boolean connectNow) throws NoTrackersException {
        this.hosts = trackers;
        if (this.hosts.size() == 0) {
            throw new NoTrackersException();
        }
        this.deadHosts = new HashMap<InetSocketAddress, Long>();
        this.lastErr = null;
        this.lastErrStr = null;
        this.cachedSocket = null;
        if (connectNow) {
            this.cachedSocket = this.getSocket();
        }
    }

    public void setSocketTimeouts(int connectTimeout, int readTimeout) {
        if (connectTimeout >= 0) {
            this.socketConnectTimeout = connectTimeout;
        }
        if (readTimeout >= 0) {
            this.socketReadTimeout = readTimeout;
        }
    }

    private SocketWithReaderAndWriter getSocket() throws NoTrackersException {
        int hostSize = this.hosts.size();
        int tries = hostSize > 15 ? 15 : hostSize;
        int index = (int)Math.floor((double)this.hosts.size() * Math.random());
        long now = System.currentTimeMillis();
        while (tries-- > 0) {
            InetSocketAddress host;
            Long deadTime;
            if ((deadTime = this.deadHosts.get(host = this.hosts.get(index++ % hostSize))) != null && deadTime > now - 5000L) {
                if (!log.isDebugEnabled()) continue;
                log.debug(" skipping connect attempt to dead host " + host);
                continue;
            }
            try {
                Socket socket = new Socket();
                socket.setSoTimeout(this.socketReadTimeout);
                socket.connect(host, this.socketConnectTimeout);
                if (log.isDebugEnabled()) {
                    log.debug("connected to tracker " + socket.getInetAddress().getHostName());
                }
                return new SocketWithReaderAndWriter(socket);
            }
            catch (IOException e) {
                log.warn("Unable to connect to tracker at " + host.toString(), (Throwable)e);
            }
            catch (IllegalBlockingModeException e) {
                log.warn("Unable to connect to tracker at " + host.toString(), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                log.warn("Unable to connect to tracker " + host.toString(), (Throwable)e);
            }
            log.warn("marking host " + host + " as dead");
            this.deadHosts.put(host, new Long(now));
        }
        throw new NoTrackersException();
    }

    public Map<String, String> doRequest(String command, String[] args) throws NoTrackersException, TrackerCommunicationException {
        if (command == null || args == null) {
            log.error("null command or args sent to doRequest");
            return null;
        }
        String argString = this.encodeURLString(args);
        String request = command + " " + argString + "\r\n";
        if (log.isDebugEnabled()) {
            log.debug("command: " + request);
        }
        if (this.cachedSocket != null) {
            try {
                this.cachedSocket.getWriter().write(request);
                this.cachedSocket.getWriter().flush();
            }
            catch (IOException e) {
                log.debug("cached socket went bad while sending request");
                this.cachedSocket = null;
            }
        }
        if (this.cachedSocket == null) {
            SocketWithReaderAndWriter socket = this.getSocket();
            try {
                socket.getWriter().write(request);
                socket.getWriter().flush();
            }
            catch (IOException e) {
                throw new TrackerCommunicationException("problem finding a working tracker in this list: " + this.listKnownTrackers());
            }
            this.cachedSocket = socket;
        }
        try {
            Matcher ok;
            String response = this.cachedSocket.getReader().readLine();
            if (response == null) {
                throw new TrackerCommunicationException("received null response from tracker at " + this.cachedSocket.getSocket().getInetAddress());
            }
            if (log.isDebugEnabled()) {
                log.debug("response: " + response);
            }
            if ((ok = this.OK_PATTERN.matcher(response)).matches()) {
                return this.decodeURLString(ok.group(1));
            }
            Matcher err = ERROR_PATTERN.matcher(response);
            if (err.matches()) {
                this.lastErr = err.group(1);
                this.lastErrStr = err.group(2);
                if (log.isDebugEnabled()) {
                    log.debug("error message from tracker: " + this.lastErr + ", " + this.lastErrStr);
                }
                return null;
            }
            throw new TrackerCommunicationException("invalid server response from " + this.cachedSocket.getSocket().getInetAddress() + ": " + response);
        }
        catch (IOException e) {
            log.warn("problem reading response from server (" + this.cachedSocket.getSocket().getInetAddress() + ")", (Throwable)e);
            throw new TrackerCommunicationException("problem talking to server at " + this.cachedSocket.getSocket().getInetAddress(), e);
        }
    }

    public String getLastErr() {
        return this.lastErr;
    }

    public String getLastErrStr() {
        return this.lastErrStr;
    }

    private String listKnownTrackers() {
        StringBuilder trackers = new StringBuilder();
        for (InetSocketAddress host : this.hosts) {
            if (trackers.length() > 0) {
                trackers.append(", ");
            }
            trackers.append(host.toString());
        }
        return trackers.toString();
    }

    private String encodeURLString(String[] args) {
        try {
            StringBuilder encoded = new StringBuilder();
            for (int i = 0; i < args.length; i += 2) {
                String key = args[i];
                String value = args[i + 1];
                if (encoded.length() > 0) {
                    encoded.append("&");
                }
                encoded.append(key);
                encoded.append("=");
                encoded.append(URLEncoder.encode(value, "UTF-8"));
            }
            return encoded.toString();
        }
        catch (UnsupportedEncodingException e) {
            log.error("problem encoding URL for tracker", (Throwable)e);
            return null;
        }
    }

    private Map<String, String> decodeURLString(String encoded) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            if (encoded == null || encoded.length() == 0) {
                return map;
            }
            String[] parts = encoded.split("&");
            for (int i = 0; i < parts.length; ++i) {
                String[] pair = parts[i].split("=");
                if (pair == null || pair.length != 2) {
                    log.error("poorly encoded string: " + encoded);
                    continue;
                }
                map.put(pair[0], URLDecoder.decode(pair[1], "UTF-8"));
            }
            return map;
        }
        catch (UnsupportedEncodingException e) {
            log.error("problem decoding URL from tracker", (Throwable)e);
            return null;
        }
    }

    public String getTracker() {
        if (this.cachedSocket == null) {
            return null;
        }
        return this.cachedSocket.getTracker();
    }

    public void destroy() {
        if (this.cachedSocket != null) {
            try {
                this.cachedSocket.getSocket().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isConnected() {
        return this.cachedSocket != null && this.cachedSocket.getSocket().isConnected();
    }
}

