/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.textfield;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalTextFieldUI;
import mdlaf.utils.MaterialDrawingUtils;

public class MaterialTextFieldUI
extends MetalTextFieldUI {
    protected static final String PROPERTY_LINE_COLOR = "lineColor";
    protected static final String PROPERTY_SELECTION_COLOR = "selectionColor";
    protected static final String PROPERTY_SELECTION_TEXT_COLOR = "selectedTextColor";
    protected boolean drawLine;
    protected Color background;
    protected Color activeBackground;
    protected Color activeForeground;
    protected Color inactiveBackground;
    protected Color inactiveForeground;
    protected Color colorLineInactive;
    protected Color colorLineActive;
    protected Color colorLine;
    protected FocusListener focusListenerColorLine;
    protected PropertyChangeListener propertyChangeListener;
    protected PropertyChangeSupport propertyChangeSupport;

    public MaterialTextFieldUI() {
        this(true);
    }

    public MaterialTextFieldUI(boolean drawLine) {
        this.drawLine = drawLine;
        this.focusListenerColorLine = new FocusListenerColorLine();
        this.propertyChangeListener = new MaterialPropertyChangeListener();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public static ComponentUI createUI(JComponent c) {
        return new MaterialTextFieldUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.installMyDefaults();
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.setFont(null);
        c.setBackground(null);
        c.setForeground(null);
        c.setBorder(null);
        c.setCursor(null);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.getComponent().setBorder(null);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.getComponent().addFocusListener(this.focusListenerColorLine);
        this.getComponent().addPropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeSupport.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.getComponent().removeFocusListener(this.focusListenerColorLine);
        this.getComponent().removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeSupport.removePropertyChangeListener(this.propertyChangeListener);
        super.uninstallListeners();
    }

    @Override
    protected void paintBackground(Graphics g) {
        super.paintBackground(MaterialDrawingUtils.getAliasedGraphics(g));
    }

    @Override
    public void paintSafely(Graphics g) {
        super.paintSafely(g);
        this.paintLine(g);
    }

    protected void logicForChangeColorOnFocus(JComponent component, Color background, Color foreground) {
        if (background == null || foreground == null) {
            throw new IllegalArgumentException("Argument function null");
        }
        JTextField textField = (JTextField)component;
        textField.setForeground(foreground);
        textField.setSelectionColor(background);
        textField.setSelectedTextColor(foreground);
    }

    protected void installMyDefaults() {
        this.background = UIManager.getColor("TextField.background");
        this.activeBackground = UIManager.getColor("TextField.selectionBackground");
        this.activeForeground = UIManager.getColor("TextField.selectionForeground");
        this.inactiveBackground = UIManager.getColor("TextField.inactiveBackground");
        this.inactiveForeground = UIManager.getColor("TextField.inactiveForeground");
        this.colorLineInactive = UIManager.getColor("TextField[Line].inactiveColor");
        this.colorLineActive = UIManager.getColor("TextField[Line].activeColor");
        this.getComponent().setFont(UIManager.getFont("TextField.font"));
        this.colorLine = this.getComponent().hasFocus() && this.getComponent().isEditable() ? this.colorLineActive : this.colorLineInactive;
        this.getComponent().setSelectionColor(this.getComponent().hasFocus() && this.getComponent().isEnabled() ? this.activeBackground : this.inactiveBackground);
        this.getComponent().setSelectedTextColor(this.getComponent().hasFocus() && this.getComponent().isEnabled() ? this.activeForeground : this.inactiveForeground);
        this.getComponent().setForeground(this.getComponent().hasFocus() && this.getComponent().isEnabled() ? this.activeForeground : this.inactiveForeground);
        this.getComponent().setBorder(UIManager.getBorder("TextField.border"));
    }

    protected void logicForPropertyChange(Color newColor, boolean isForeground) {
        if (newColor == null) {
            return;
        }
        if (isForeground && !newColor.equals(this.activeForeground) && !newColor.equals(this.inactiveForeground)) {
            this.activeForeground = newColor;
            this.getComponent().repaint();
        }
        if (!(isForeground || newColor.equals(this.activeBackground) || newColor.equals(this.inactiveBackground))) {
            this.activeBackground = newColor;
            this.getComponent().repaint();
        }
    }

    protected void changeColorOnFocus(boolean hasFocus) {
        JTextField c = (JTextField)this.getComponent();
        if (c == null) {
            return;
        }
        if (hasFocus && this.activeBackground != null && this.activeForeground != null) {
            this.logicForChangeColorOnFocus(c, this.activeBackground, this.activeForeground);
            this.paintLine(c.getGraphics());
        }
        if (!hasFocus && this.inactiveBackground != null && this.inactiveForeground != null) {
            this.logicForChangeColorOnFocus(c, this.inactiveBackground, this.inactiveForeground);
            this.paintLine(c.getGraphics());
        }
        if (c.getGraphics() != null) {
            c.paint(c.getGraphics());
        }
    }

    protected synchronized void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == null || propertyName.isEmpty() || oldValue == null || newValue == null) {
            throw new IllegalArgumentException("Some property null");
        }
        if (this.propertyChangeSupport == null || oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        if (this.propertyChangeSupport == null || oldValue == newValue) {
            return;
        }
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void paintLine(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        JTextField c = (JTextField)this.getComponent();
        if (this.drawLine) {
            int x = c.getInsets().left;
            int y = c.getInsets().top;
            int w = c.getWidth() - c.getInsets().left - c.getInsets().right;
            graphics.setColor(this.colorLine);
            graphics.fillRect(x, c.getHeight() - y, w, 1);
        }
    }

    protected class MaterialPropertyChangeListener
    implements PropertyChangeListener {
        protected MaterialPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            Color newColor;
            if (MaterialTextFieldUI.this.getComponent() == null) {
                return;
            }
            if (pce.getPropertyName().equals(MaterialTextFieldUI.PROPERTY_SELECTION_COLOR)) {
                newColor = (Color)pce.getNewValue();
                MaterialTextFieldUI.this.logicForPropertyChange(newColor, false);
            }
            if (pce.getPropertyName().equals(MaterialTextFieldUI.PROPERTY_SELECTION_TEXT_COLOR)) {
                newColor = (Color)pce.getNewValue();
                MaterialTextFieldUI.this.logicForPropertyChange(newColor, true);
            }
            if (pce.getPropertyName().equals(MaterialTextFieldUI.PROPERTY_LINE_COLOR)) {
                MaterialTextFieldUI.this.colorLine = newColor = (Color)pce.getNewValue();
                MaterialTextFieldUI.this.getComponent().repaint();
            }
            if (pce.getPropertyName().equals("background")) {
                MaterialTextFieldUI.this.getComponent().repaint();
            }
        }
    }

    protected class FocusListenerColorLine
    implements FocusListener {
        protected FocusListenerColorLine() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            MaterialTextFieldUI.this.firePropertyChange(MaterialTextFieldUI.PROPERTY_LINE_COLOR, MaterialTextFieldUI.this.colorLineInactive, MaterialTextFieldUI.this.colorLineActive);
            MaterialTextFieldUI.this.changeColorOnFocus(true);
        }

        @Override
        public void focusLost(FocusEvent e) {
            MaterialTextFieldUI.this.firePropertyChange(MaterialTextFieldUI.PROPERTY_LINE_COLOR, MaterialTextFieldUI.this.colorLineActive, MaterialTextFieldUI.this.colorLineInactive);
            MaterialTextFieldUI.this.changeColorOnFocus(false);
        }
    }
}

