/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.taskpane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import mdlaf.utils.MaterialDrawingUtils;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.plaf.basic.BasicTaskPaneUI;

public class MaterialTaskPaneUI
extends BasicTaskPaneUI {
    private MouseListener changeIcon = new ChangeIconOnClick();
    private JXTaskPane taskPane;

    public static ComponentUI createUI(JComponent c) {
        return new MaterialTaskPaneUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        JXTaskPane jxTaskPane = (JXTaskPane)c;
        jxTaskPane.addMouseListener(this.changeIcon);
        jxTaskPane.setIcon(jxTaskPane.isCollapsed() ? UIManager.getIcon("TaskPane.yesCollapsed") : UIManager.getIcon("TaskPane.noCollapsed"));
        jxTaskPane.getContentPane().setBackground(UIManager.getColor("TaskPane.contentBackground"));
        this.taskPane = jxTaskPane;
    }

    public void uninstallUI(JComponent c) {
        c.setFont(null);
        c.setBackground(null);
        c.setForeground(null);
        c.setBorder(null);
        c.setCursor(null);
        super.uninstallUI(c);
    }

    public void update(Graphics g, JComponent c) {
        super.update(g, c);
        JXTaskPane jxTaskPane = (JXTaskPane)c;
        jxTaskPane.setIcon(jxTaskPane.isCollapsed() ? UIManager.getIcon("TaskPane.yesCollapsed") : UIManager.getIcon("TaskPane.noCollapsed"));
        jxTaskPane.getContentPane().setBackground(UIManager.getColor("TaskPane.contentBackground"));
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont((JComponent)this.group, "TaskPane.background", "TaskPane.foreground", "TaskPane.font");
        LookAndFeel.installProperty((JComponent)this.group, "opaque", false);
        if (SwingXUtilities.isUIInstallable((Object)this.group.getBorder())) {
            this.group.setBorder(this.createPaneBorder());
        }
        if (this.group.getContentPane() instanceof JComponent) {
            JComponent content = (JComponent)this.group.getContentPane();
            LookAndFeel.installColorsAndFont(content, "TaskPane.background", "TaskPane.foreground", "TaskPane.font");
            if (SwingXUtilities.isUIInstallable((Object)content.getBorder())) {
                content.setBorder(this.createContentPaneBorder());
            }
        }
    }

    protected void uninstallListeners() {
        this.taskPane.removeMouseListener(this.changeIcon);
        super.uninstallListeners();
    }

    protected Border createContentPaneBorder() {
        Color borderColor = UIManager.getColor("TaskPane.borderColor");
        return new CompoundBorder((Border)new BasicTaskPaneUI.ContentPaneBorder(borderColor), UIManager.getBorder("TaskPane.border"));
    }

    protected Border createPaneBorder() {
        return new MaterialPaneBorder();
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(MaterialDrawingUtils.getAliasedGraphics(g), c);
    }

    protected class ChangeIconOnClick
    implements MouseListener {
        protected ChangeIconOnClick() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (MaterialTaskPaneUI.this.taskPane.isCollapsed()) {
                MaterialTaskPaneUI.this.taskPane.setIcon(UIManager.getIcon("TaskPane.yesCollapsed"));
                return;
            }
            MaterialTaskPaneUI.this.taskPane.setIcon(UIManager.getIcon("TaskPane.noCollapsed"));
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    protected class MaterialPaneBorder
    extends BasicTaskPaneUI.PaneBorder {
        protected MaterialPaneBorder() {
            super((BasicTaskPaneUI)MaterialTaskPaneUI.this);
        }

        protected void paintTitleBackground(JXTaskPane group, Graphics g) {
            MaterialDrawingUtils.getAliasedGraphics(g);
            this.label.setBackground(UIManager.getColor("TaskPane.background"));
            if (group.isSpecial()) {
                g.setColor(this.specialTitleBackground);
            } else {
                g.setColor(this.titleBackgroundGradientStart);
            }
            Graphics2D graphics2D = (Graphics2D)g;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g = graphics2D;
            g.fillRoundRect(-2, 0, group.getWidth(), group.getHeight(), 15, 15);
        }

        protected boolean isMouseOverBorder() {
            return true;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public Dimension getPreferredSize(JXTaskPane group) {
            this.configureLabel(group);
            Dimension dim = this.label.getPreferredSize();
            dim.width += MaterialTaskPaneUI.this.getTitleHeight((Component)group);
            dim.height = MaterialTaskPaneUI.this.getTitleHeight((Component)group);
            return dim;
        }
    }
}

