/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.tabbedpane;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import mdlaf.utils.MaterialDrawingUtils;

public class MaterialTabbedPaneUI
extends BasicTabbedPaneUI {
    protected JTabbedPane component;
    protected ColorUIResource selectedForeground;
    protected ColorUIResource areaContentBackground;
    protected ColorUIResource selectedAreaContentBackground;
    protected ColorUIResource disableAreaContentBackground;
    protected ColorUIResource foreground;
    protected int positionYLine;
    protected int positionXLine;
    protected int widthLine;
    protected int heightLine;
    protected int arcLine;

    public static ComponentUI createUI(JComponent c) {
        return new MaterialTabbedPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        JTabbedPane tabbedPane = (JTabbedPane)c;
        tabbedPane.setOpaque(false);
        tabbedPane.setFont(UIManager.getFont("TabbedPane.font"));
        tabbedPane.setBackground(UIManager.getColor("TabbedPane.background"));
        this.foreground = new ColorUIResource(UIManager.getColor("TabbedPane.foreground"));
        tabbedPane.setForeground(this.foreground);
        this.selectedForeground = new ColorUIResource(UIManager.getColor("TabbedPane.selectionForeground"));
        this.areaContentBackground = new ColorUIResource(UIManager.getColor("TabbedPane.contentAreaColor"));
        this.disableAreaContentBackground = new ColorUIResource(UIManager.getColor("TabbedPane.disableContentAreaColor"));
        this.selectedAreaContentBackground = new ColorUIResource(UIManager.getColor("TabbedPane[focus].colorLine"));
        tabbedPane.setBorder(UIManager.getBorder("TabbedPane.border"));
        this.darkShadow = UIManager.getColor("TabbedPane.darkShadow");
        this.shadow = UIManager.getColor("TabbedPane.shadow");
        this.lightHighlight = UIManager.getColor("TabbedPane.highlight");
        this.positionYLine = UIManager.getInt("TabbedPane.linePositionY");
        this.positionXLine = UIManager.getInt("TabbedPane.linePositionX");
        this.widthLine = UIManager.getInt("TabbedPane.lineWidth");
        this.heightLine = UIManager.getInt("TabbedPane.lineHeight");
        this.arcLine = UIManager.getInt("TabbedPane.lineArch");
        this.component = tabbedPane;
    }

    @Override
    public void uninstallUI(JComponent c) {
        JTabbedPane tabbedPane = (JTabbedPane)c;
        tabbedPane.setFont(null);
        tabbedPane.setBackground(null);
        tabbedPane.setForeground(null);
        tabbedPane.setBorder(null);
        this.darkShadow = null;
        this.shadow = null;
        this.lightHighlight = null;
        this.component = null;
        super.uninstallDefaults();
        super.uninstallUI(c);
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Graphics2D g2D = (Graphics2D)g;
        Polygon shape = null;
        Rectangle shapeRect = null;
        if (tabPlacement == 1) {
            int[] xp = new int[]{x, x, x, x + w, x + w, x + w, x + w, x};
            int[] yp = new int[]{y + this.positionYLine + this.heightLine, y + this.positionYLine, y + this.positionYLine, y + this.positionYLine, y + this.positionYLine, y + this.positionYLine, y + this.positionYLine + this.heightLine, y + this.positionYLine + this.heightLine};
            shape = new Polygon(xp, yp, xp.length);
        } else if (tabPlacement == 3) {
            int[] xp = new int[]{x, x, x, x + w, x + w, x + w, x + w, x};
            int[] yp = new int[]{(y += 20) + this.heightLine, y, y, y, y, y, y + this.heightLine, y + this.heightLine};
            shape = new Polygon(xp, yp, xp.length);
        } else {
            shapeRect = tabPlacement == 2 ? new Rectangle(x + this.heightLine - 2, y + this.heightLine, this.heightLine, w / this.tabPane.getTabCount()) : new Rectangle(x + w - this.heightLine, y + this.heightLine, this.heightLine, w / this.tabPane.getTabCount());
        }
        if (isSelected) {
            g2D.setColor(this.selectedAreaContentBackground);
            g2D.setPaint(this.selectedAreaContentBackground);
            this.tabPane.setForegroundAt(tabIndex, this.selectedForeground);
        } else {
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                g2D.setColor(this.areaContentBackground);
                g2D.setPaint(this.areaContentBackground);
            } else {
                g2D.setColor(this.disableAreaContentBackground);
                g2D.setPaint(this.disableAreaContentBackground);
            }
            this.tabPane.setForegroundAt(tabIndex, this.foreground);
        }
        if (shape != null) {
            g2D.fill(shape);
        } else if (shapeRect != null) {
            g2D.fill(shapeRect);
        }
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        if (tabPlacement == 2 || tabPlacement == 4) {
            return super.calculateTabHeight(tabPlacement, tabIndex, fontHeight);
        }
        return 18 + super.calculateTabHeight(tabPlacement, tabIndex, fontHeight);
    }

    @Override
    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        super.paintTab(MaterialDrawingUtils.getAliasedGraphics(g), tabPlacement, rects, tabIndex, iconRect, textRect);
        if (UIManager.getBoolean("TabbedPane[MouseHover].enable")) {
            this.component.addMouseMotionListener(new MouseHoverTab(rects));
        }
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected void paintContentBorder(Graphics graphics, int i, int i1) {
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new MaterialTabbedPaneLayout();
    }

    protected class MouseHoverTab
    implements MouseMotionListener {
        private Rectangle[] rectangles;

        public MouseHoverTab(Rectangle[] rectangles) {
            this.rectangles = rectangles;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JComponent mouseGenerate = (JComponent)e.getSource();
            if (!mouseGenerate.isEnabled()) {
                return;
            }
            if (mouseGenerate.getCursor().equals(Cursor.getPredefinedCursor(3))) {
                return;
            }
            Point point = e.getPoint();
            for (Rectangle r : this.rectangles) {
                if (!r.contains(point)) continue;
                mouseGenerate.setCursor(Cursor.getPredefinedCursor(12));
                return;
            }
            mouseGenerate.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected class MaterialTabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        protected int spacer;
        protected int indent;

        public MaterialTabbedPaneLayout() {
            super(MaterialTabbedPaneUI.this);
            this.spacer = UIManager.getInt("TabbedPane.spacer");
            this.indent = UIManager.getInt("TabbedPane.indent");
        }

        @Override
        protected void calculateTabRects(int tabPlacement, int tabCount) {
            if (this.spacer < 0) {
                throw new IllegalArgumentException("The spacer inside the " + this.getClass().getSimpleName() + " must be a not negative value");
            }
            super.calculateTabRects(tabPlacement, tabCount);
            if (tabPlacement == 1 || tabPlacement == 3) {
                for (int i = 0; i < MaterialTabbedPaneUI.this.rects.length; ++i) {
                    ((MaterialTabbedPaneUI)MaterialTabbedPaneUI.this).rects[i].x += i * this.spacer + this.indent;
                }
            }
        }
    }
}

