/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.tree;

import java.awt.Cursor;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import mdlaf.components.tree.MaterialTreeCellEditor;
import mdlaf.components.tree.MaterialTreeCellRenderer;
import mdlaf.utils.MaterialDrawingUtils;

public class MaterialTreeUI
extends BasicTreeUI {
    public static ComponentUI createUI(JComponent c) {
        return new MaterialTreeUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        JTree tree = (JTree)c;
        MaterialTreeCellRenderer renderer = new MaterialTreeCellRenderer();
        MaterialTreeCellEditor editor = new MaterialTreeCellEditor(tree, renderer);
        tree.setCellRenderer(renderer);
        tree.setCellEditor(editor);
        tree.setFont(UIManager.getFont("Tree.font"));
        tree.setForeground(UIManager.getColor("Tree.foreground"));
        tree.setBackground(UIManager.getColor("Tree.background"));
        tree.setRowHeight(0);
        tree.setInvokesStopCellEditing(true);
        MaterialTreeUI ui = (MaterialTreeUI)tree.getUI();
        ui.setLeftChildIndent(10);
        ui.setRightChildIndent(10);
        tree.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.tree.setCellRenderer(null);
        this.tree.setCellEditor(null);
        this.tree.setFont(null);
        this.tree.setForeground(null);
        this.tree.setBackground(null);
        this.tree.setCursor(null);
        super.uninstallUI(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        g = MaterialDrawingUtils.getAliasedGraphics(g);
        super.paint(g, c);
    }

    @Override
    protected void paintDropLine(Graphics g) {
        super.paintDropLine(MaterialDrawingUtils.getAliasedGraphics(g));
    }

    @Override
    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
    }

    @Override
    protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
    }
}

