/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.combobox;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxUI;
import mdlaf.animation.MaterialUIMovement;
import mdlaf.components.combobox.MaterialComboBoxEditor;
import mdlaf.components.combobox.MaterialComboBoxRenderer;
import mdlaf.utils.MaterialBorders;
import mdlaf.utils.MaterialDrawingUtils;
import mdlaf.utils.MaterialManagerListener;

public class MaterialComboBoxUI
extends BasicComboBoxUI {
    protected Color background;
    protected FocusListener focusListener = new FocusListenerColor();
    protected int arc = 12;

    public static ComponentUI createUI(JComponent c) {
        return new MaterialComboBoxUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.comboBox.setFont(UIManager.getFont("ComboBox.font"));
        this.background = UIManager.getColor("ComboBox.background");
        this.comboBox.setBackground(this.background);
        this.comboBox.setForeground(UIManager.getColor("ComboBox.foreground"));
        this.comboBox.setBorder(UIManager.getBorder("ComboBox.border"));
        this.comboBox.setLightWeightPopupEnabled(true);
        this.comboBox.setCursor(Cursor.getPredefinedCursor(12));
        this.comboBox.setFocusable(true);
        this.arc = UIManager.getInt("ComboBox.arc");
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.comboBox.setBackground(null);
        this.comboBox.setForeground(null);
        this.comboBox.setBorder(null);
        this.comboBox.setLightWeightPopupEnabled(true);
        this.comboBox.setCursor(null);
        this.comboBox.setRenderer(null);
        this.comboBox.setEditor(null);
        this.comboBox.removeFocusListener(this.focusListener);
        MaterialManagerListener.removeAllMaterialMouseListener(this.comboBox);
        super.uninstallUI(this.comboBox);
    }

    @Override
    protected JButton createArrowButton() {
        Icon icon = UIManager.getIcon("ComboBox.buttonIcon");
        JButton button = icon != null ? new JButton(icon) : new BasicArrowButton(5);
        return button;
    }

    @Override
    public void configureArrowButton() {
        super.configureArrowButton();
        MaterialManagerListener.removeAllMaterialMouseListener(this.arrowButton);
        this.arrowButton.setOpaque(true);
        this.arrowButton.setBackground(UIManager.getColor("ComboBox.buttonBackground"));
        if (UIManager.getBoolean("ComboBox.mouseHoverEnabled")) {
            this.arrowButton.addMouseListener(MaterialUIMovement.getMovement(this.arrowButton, UIManager.getColor("ComboBox.mouseHoverColor")));
        }
        this.arrowButton.setBorder(UIManager.getBorder("ComboBox[button].border"));
    }

    @Override
    public void unconfigureArrowButton() {
        MaterialManagerListener.removeAllMaterialMouseListener(this.arrowButton);
        super.unconfigureArrowButton();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        g = MaterialDrawingUtils.getAliasedGraphics(g);
        g.setColor(c.getBackground());
        g.fillRoundRect(0, 0, this.comboBox.getWidth(), this.comboBox.getHeight(), this.arc, this.arc);
        this.paint(g, c);
    }

    protected ListCellRenderer createRenderer() {
        return new MaterialComboBoxRenderer();
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new MaterialComboBoxEditor();
    }

    @Override
    protected FocusListener createFocusListener() {
        this.comboBox.addFocusListener(this.focusListener);
        return super.createFocusListener();
    }

    protected class FocusListenerColor
    implements FocusListener {
        private Border focus;
        private Border unfocus;

        public FocusListenerColor() {
            this.focus = MaterialBorders.roundedLineColorBorder(UIManager.getColor("ComboBox.focusColor"), MaterialComboBoxUI.this.arc);
            this.unfocus = MaterialBorders.roundedLineColorBorder(UIManager.getColor("ComboBox.unfocusColor"), MaterialComboBoxUI.this.arc);
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getComponent() == null) {
                return;
            }
            JComboBox cb = (JComboBox)e.getComponent();
            if (this.focus != null) {
                cb.setBorder(this.focus);
                cb.repaint();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (e.getComponent() == null) {
                return;
            }
            JComboBox cb = (JComboBox)e.getComponent();
            if (this.unfocus != null) {
                cb.setBorder(this.unfocus);
                cb.repaint();
            }
        }
    }
}

