/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.button;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import mdlaf.animation.MaterialUIMovement;
import mdlaf.components.button.StateButton;
import mdlaf.utils.MaterialDrawingUtils;
import mdlaf.utils.MaterialManagerListener;

public class MaterialButtonUI
extends BasicButtonUI {
    private AbstractButton button;
    private Color foreground;
    private Color background;
    private Color disabledBackground;
    private Color disabledForeground;
    private Color defaultBackground;
    private Color defaultForeground;
    private Boolean isDefaultButton = null;
    private int arch = 7;
    private PropertyChangeListener enableButton = new EventEnableButton();

    public static ComponentUI createUI(JComponent c) {
        return new MaterialButtonUI();
    }

    @Override
    public void installUI(JComponent c) {
        JButton b;
        super.installUI(c);
        AbstractButton button = (AbstractButton)c;
        button.setOpaque(UIManager.getBoolean("Button.opaque"));
        button.setBorder(UIManager.getBorder("Button.border"));
        this.foreground = UIManager.getColor("Button.foreground");
        this.background = UIManager.getColor("Button.background");
        this.disabledBackground = UIManager.getColor("Button.disabledBackground");
        this.disabledForeground = UIManager.getColor("Button.disabledForeground");
        this.defaultBackground = UIManager.getColor("Button[Default].background");
        this.defaultForeground = UIManager.getColor("Button[Default].foreground");
        button.setBackground(this.background);
        button.setForeground(this.foreground);
        this.arch = UIManager.getInt("Button.arc");
        if (UIManager.getBoolean("Button.mouseHoverEnable") && !(b = (JButton)button).isDefaultButton()) {
            button.addMouseListener(MaterialUIMovement.getMovement(button, UIManager.getColor("Button.mouseHoverColor")));
        }
        button.setFocusable(UIManager.getBoolean("Button.focusable"));
        this.button = button;
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        AbstractButton button = (AbstractButton)c;
        button.setBorder(null);
        this.foreground = null;
        this.background = null;
        this.disabledBackground = null;
        this.disabledForeground = null;
        this.defaultBackground = null;
        this.defaultForeground = null;
        button.setBackground(null);
        button.setForeground(null);
        button.setCursor(null);
        MaterialManagerListener.removeAllMaterialMouseListener(button);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        JButton b = (JButton)c;
        if (b.isContentAreaFilled()) {
            this.paintBackground(g, b);
        }
        if (this.isDefaultButton == null && b.isEnabled()) {
            this.isDefaultButton = ((JButton)this.button).isDefaultButton();
            if (this.isDefaultButton.booleanValue()) {
                if (UIManager.getBoolean("Button.mouseHoverEnable")) {
                    MaterialManagerListener.removeAllMaterialMouseListener(b);
                    b.addMouseListener(MaterialUIMovement.getMovement(b, UIManager.getColor("Button[Default].mouseHoverColor")));
                }
                this.paintStateButton(c, g);
            }
        }
        super.paint(g, c);
    }

    @Override
    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        super.paintText(g, b, textRect, text);
        this.paintStateButton(b, g, StateButton.DISABLE);
    }

    private void paintBackground(Graphics g, JComponent c) {
        g = MaterialDrawingUtils.getAliasedGraphics(g);
        Graphics2D graphics = (Graphics2D)g.create();
        g.setColor(c.getBackground());
        JButton b = (JButton)c;
        if (!UIManager.getBoolean("Button[border].toAll") && this.button.getIcon() != null) {
            g.fillRoundRect(0, 0, c.getWidth(), c.getHeight(), this.arch, this.arch);
        } else {
            g.fillRoundRect(0, 0, c.getWidth(), c.getHeight(), this.arch, this.arch);
            if (this.isDefaultButton != null && this.isDefaultButton.booleanValue()) {
                g.setColor(UIManager.getColor("Button[Default].background"));
                if (UIManager.getBoolean("Button[Default].shadowEnable")) {
                    this.paintShadow(MaterialDrawingUtils.getAliasedGraphics(g), this.button);
                }
                return;
            }
            if (UIManager.getBoolean("Button[border].enable")) {
                this.paintBorderButton(graphics, b);
            }
        }
        this.paintStateButton(c, g, StateButton.DISABLE);
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        this.paintFocusRing(g, (JButton)b);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        g.fillRoundRect(0, 0, b.getWidth(), b.getHeight(), this.arch, this.arch);
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        b.addPropertyChangeListener(this.enableButton);
        return super.createButtonListener(b);
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        b.removePropertyChangeListener(this.enableButton);
        super.uninstallListeners(b);
    }

    protected void paintFocusRing(Graphics g, JButton b) {
        BasicStroke dashed = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{0.0f, 3.0f}, 10.0f);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setStroke(dashed);
        if (this.isDefaultButton.booleanValue()) {
            g2.setColor(UIManager.getColor("Button[Default][focus].color"));
        } else {
            g2.setColor(UIManager.getColor("Button[focus].color"));
        }
        g2.drawRoundRect(5, 5, b.getWidth() - 10, b.getHeight() - 10, this.arch, this.arch);
        g2.dispose();
    }

    protected void paintShadow(Graphics g, JComponent c) {
        int topOpacity = 80;
        int pixels = UIManager.getInt("Button[Default].shadowPixel");
        JButton b = (JButton)c;
        int valueRed = 255;
        int valueGreen = 255;
        int valueBlue = 255;
        for (int i = pixels; i >= 0; --i) {
            if (valueBlue > 70) {
                valueRed -= 70;
                valueGreen -= 70;
                valueBlue -= 70;
            } else {
                valueBlue -= valueBlue;
                valueGreen -= valueGreen;
                valueRed -= valueRed;
            }
            Color result = new Color(valueRed, valueGreen, valueBlue, topOpacity);
            g.setColor(result);
            g.drawRoundRect(i, i, b.getWidth() - (i * 2 + 1), b.getHeight() - (i * 2 + 1), this.arch, this.arch);
        }
    }

    protected void paintBorderButton(Graphics2D graphics, JButton b) {
        if (!b.isEnabled()) {
            return;
        }
        graphics.setStroke(new BasicStroke(2.0f));
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int w = b.getWidth() - 1;
        int h = b.getHeight() - 1;
        graphics.setColor(UIManager.getColor("Button[border].color"));
        graphics.drawRoundRect(0, 0, w, h, this.arch + 2, this.arch + 2);
    }

    protected void paintStateButton(JComponent component, Graphics graphics) {
        if (component == null || graphics == null) {
            throw new IllegalArgumentException("Input null");
        }
        JButton b = (JButton)component;
        if (b.isEnabled() && this.isDefaultButton != null && this.isDefaultButton.booleanValue() && !b.isSelected()) {
            b.setBackground(this.defaultBackground);
            b.setForeground(this.defaultForeground);
            return;
        }
        if (!b.isEnabled()) {
            b.setBackground(this.disabledBackground);
            b.setForeground(this.disabledForeground);
            return;
        }
    }

    protected void paintStateButton(JComponent c, Graphics g, StateButton disable) {
        if (StateButton.DISABLE.equals((Object)disable) && !c.isEnabled()) {
            this.paintStateButton(c, g);
        }
    }

    protected class EventEnableButton
    implements PropertyChangeListener {
        private String proprietyNameEnableEvent = "enabled";
        private String proprietyNameDefaultEvent = "defaultButton";

        protected EventEnableButton() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt == null) {
                throw new IllegalArgumentException("The event null");
            }
            if (evt.getPropertyName().equals(this.proprietyNameEnableEvent) && ((Boolean)evt.getNewValue()).booleanValue()) {
                MaterialButtonUI.this.button.setBackground(MaterialButtonUI.this.background);
                MaterialButtonUI.this.button.setForeground(MaterialButtonUI.this.foreground);
            } else if (evt.getPropertyName().equals(this.proprietyNameEnableEvent) && !((Boolean)evt.getNewValue()).booleanValue()) {
                MaterialButtonUI.this.background = MaterialButtonUI.this.button.getBackground();
                MaterialButtonUI.this.foreground = MaterialButtonUI.this.button.getForeground();
            } else if (evt.getPropertyName().equals(this.proprietyNameDefaultEvent) && ((Boolean)evt.getNewValue()).booleanValue()) {
                MaterialButtonUI.this.background = MaterialButtonUI.this.button.getBackground();
                MaterialButtonUI.this.foreground = MaterialButtonUI.this.button.getForeground();
            }
        }
    }
}

