/*
 * Decompiled with CFR 0.152.
 */
package com.maystrovyy.aspect;

import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ProfilingAspect {
    private static final Logger log = LoggerFactory.getLogger(ProfilingAspect.class);
    private final String SECONDS = "seconds";
    private final String MILLISECONDS = "milliseconds";

    @Around(value="@annotation(com.maystrovyy.annotation.Profiling)")
    private Object around(ProceedingJoinPoint point) {
        String className = point.getTarget().getClass().toString();
        String methodName = ((MethodSignature)MethodSignature.class.cast(point.getSignature())).getMethod().getName();
        log.info("Profiling in " + className + " method: " + methodName + " started...");
        long before = System.nanoTime();
        Object result = point.proceed();
        long after = System.nanoTime();
        long time = TimeUnit.SECONDS.convert(after - before, TimeUnit.NANOSECONDS);
        String timeWithFormat = time + " " + "seconds";
        if (time <= 10L) {
            time = TimeUnit.MILLISECONDS.convert(after - before, TimeUnit.NANOSECONDS);
            timeWithFormat = time + " " + "milliseconds";
        }
        log.info("Execution time in " + className + " method: " + methodName + " = " + timeWithFormat + ".");
        return result;
    }
}

