# clj-imap-observer

'clj-imap-observer' is a Clojure library which lets you create a
```com.sun.mail.imap.IdleManager``` in a more functional way. Also consider
reading [doc/intro.md](doc/intro.md).


## Usage

### 1. Add project dependency

``` clojure
[com.markusaschl/clj-imap-observer "0.3.0"]
```


### 2. Import the namespace

``` clojure
(ns com.example.your-application
  (:require [com.markusaschl.imap-observer :as imap-observer]
            [com.markusaschl.imap-observer.extras :as imap-extras]))
```


### 3. Place your configuration into a file

Write something like this into
```<your-project>/ressources/mail-properties.edn```:

``` clojure
{:host "example.com",
 :username "user@example.com",
 :password "password",
 :imap-protocol "imaps",
 :session-properties
 {"mail.event.scope" "application"}}
```


### 4. Make an observer

``` clojure
(def +observer+ (observer/make-observer
                 (->> (clojure.java.io/resource "mail-properties.edn")
                      slurp
                      clojure.edn/read-string)
                 [{:name "INBOX"
                   :mode (:read-write extras/folder-modes)
                   :on-folder-opened
                   (fn [folder-obj] (def +folder+ folder-obj))
                   :on-message-added
                   #(def +message+ (first %))}]))
```



## Tips

### Timeout

After a certain period of inactivity, the server closes the connection to the
client. To fix a possible ```jakarta.mail.FolderClosedException``` when reading
a folder or email, I offer this solution:

``` clojure
(let
    [ten-minutes (->> 1000 (* 60) (* 10))
     idle-agent (agent (->> (imap-observer/make-observer
                             (->> (clojure.java.io/resource "mail-properties.edn")
                                  slurp
                                  clojure.edn/read-string)
                             [{:name "INBOX"
                               :mode (:read-write imap-extras/folder-modes)
                               :on-message-added (fn [messages])}])))]

    (prn "starting execution")
    (while true
      (send idle-agent component/start)
      (Thread/sleep ten-minutes)
      (send idle-agent component/stop)
      (prn "restarting execution")))
```


## Bugs


## TODOs


- [ ] test connection success with ```GreenMail```
- [ ] test function calls (```:on-folder-opened```, ```:on-message-added``` and
      ```:on-message-removed```) with ```GreenMail```
- [ ] test functions in the ```extras``` namespace
