(ns com.markusaschl.imap-observer.extras
  (:import (jakarta.mail Folder Flags$Flag)))


(def folder-modes {:read-only Folder/READ_ONLY
                   :read-write Folder/READ_WRITE})

(def message-flags {:answered Flags$Flag/ANSWERED
                    :deleted Flags$Flag/DELETED
                    :draft Flags$Flag/DRAFT
                    :flagged Flags$Flag/FLAGGED
                    :recent Flags$Flag/RECENT
                    :seen Flags$Flag/SEEN
                    :user Flags$Flag/USER})


(defn filter-by [flag message]
  (.isSet (message flag)))

(defn modify-flag [flag message set]
  (.setFlag message flag set?))
