# clj-imap-observer

'IMAP-Observer' is a library which lets you create an ```IdleManager``` in a functional way.


## Installation



## Usage

### 1. Import the namespace

``` clojure
(ns com.example.your-application
  (:require [com.markusaschl.imap-observer :as observer]))
```

### 2. Place your configuration into a file

Write something like this: ```<your-project>/ressources/imap-properties.edn```.

``` clojure
{:host "example.com",
 :username "user@example.com",
 :password "password",
 :imap-protocol "imaps",
 :session-properties
 {"mail.event.scope" "application"}}
```

### 3. Make an observer

``` clojure
(def observer (->> (imap-observer/make-observer
                  (->> (clojure.java.io/resource "imap-properties.edn")
                       slurp
                       clojure.edn/read-string)
                  [{:name "INBOX"
                    :mode Folder/READ_WRITE
                    :on-message-added (fn [messages])}])))
```


## Options

The function ```imap-observer/make-observer``` takes two arguments, ```config-options``` and ```folder-options.```

'config-options' is a map, which uses these keys:

- ```:imap-protocol```
- ```:host```
- ```:username```
- ```:password```
- and ```:session-properties```

':session-properties' is also a map, which is then converted into a ```Property``` object, which in turn is passed to ```Session/getDefaultInstance```. That happens in ```imap-observer/session```.

For a list of all the properties you can use, see the [com.sun.mail.imap](https://javaee.github.io/javamail/docs/api/com/sun/mail/imap/package-summary.html) documentation.

':folder-options' is an array consisting of a map made of:

- ```:name```
- ```:mode```
- ```:on-message-added```
- ```:on-message-removed```

For example:

``` clojure
[{:name "INBOX"
  :mode Folder/READ_WRITE
  :on-message-added (fn [e])}]
```

### Notes

1. Both event functions ```:on-message-added``` and ```:on-message-removed``` are optional.
2. On an event, the appropriate function receives a map of ```IMAPMessage```.


### Bugs

- [ ] As of version 0.2, the test fails, as I can't manage to establish a connection with ```GreenMail```.


## TODOs


- [ ] test connection success with ```GreenMail```
- [ ] handle connection timeout

## License

The MIT License (MIT)

Copyright © 2015 Markus Aschl

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
