(ns com.manigfeald.machinate.queue
  (:refer-clojure :exclude [peek seq]))

#?(:clj (set! *warn-on-reflection* true))

#?(:clj (set! *unchecked-math* :warn-on-boxed))

;; because I want a doublely linked list queue with exposed nodes to
;; facilitate fast removing from the middle of the queue when you have
;; the node in hand.

;; [head tail user-field-count]
(defn new-q [entry-field-count]
  (doto (object-array 3)
    (aset 2 entry-field-count)))

(defn add-entry ^objects [^objects q]
  (let [obj (object-array (+ (long (aget q 2)) 2))
        ^objects old-last (aget q 1)]
    (aset q 1 obj)
    (aset obj (aget q 2) old-last)
    (when (nil? (aget q 0))
      (aset q 0 obj))
    (when old-last
      (aset old-last (inc (long (aget q 2))) obj))
    obj))

(defn peek ^objects [^objects q]
  (aget q 0))

(defn unlink [^objects q ^objects entry]
  (let [^objects prv (aget entry (aget q 2))
        ^objects nxt (aget entry (inc (long (aget q 2))))]
    (when (and prv (identical? entry (aget prv (inc (long (aget q 2))))))
      (aset prv (inc (long (aget q 2))) nxt))
    (when (and nxt (identical? entry (aget nxt (aget q 2))))
      (aset nxt (aget q 2) prv))
    (when (identical? (aget q 0) entry)
      (aset q 0 nxt))
    (when (identical? (aget q 1) entry)
      (aset q 1 prv))
    (aset entry (long (aget q 2)) nil)
    (aset entry (inc (long (aget q 2))) nil)))

(defn seq [^objects q]
  ((fn f [^objects entry]
     (lazy-seq
      (when entry
        (cons entry (f (aget entry (inc (long (aget q 2))))))))) (aget q 0)))
