(ns com.manigfeald.machinate.protocols)

(defprotocol Event
  (try-event [event resume resume-with-error control nack-group]
    "internal function for syncing"))

(defprotocol Syncable
  (-sync [event] "register interest in the occurence of this event"))

(defprotocol QuasiEvent
  (push-down [event ctor lst]
    "Given an event, which is possible a tree built using repeated
applications of combinators, turn the tree into a \"disjunctive normal
form\" list of possible events to synchronize on"))

(defprotocol Nackable
  (check-nack-group [event nack-group]))

(defprotocol AsymmetricExchange
  "An exchange is a place where two threads of control can meet and
  exchange values. There is a left side and right side. sends on the
  left are matched with sends on the right."
  (send-left [_ value]
    "return an event that on sync waits for a corresponding send-right and
returns the value it sent.")
  (send-right [_ value]
    "return an event that on sync waits for a corresponding send-left and
returns the value it sent."))

(defprotocol SendChannel
  (send-it [_ it]))

(defprotocol ReceiveChannel
  (receive-it [_]))

(defprotocol Buffer
  (full? [buf] "returns true if the given buffer is full")
  (add-item [buf item] "adds the give item to the given buffer")
  (peek-item [buf] "returns the item at the top of the buffer or nil if empty")
  (pop-item [buf] "pops the item off the top of the buffer"))

(defprotocol Channel
  (close! [_]))

(defprotocol ILock
  (lock [_])
  (unlock [_]))

(defprotocol ConditionVariable
  "A vaguely sort of condition variable kind of thing. Has some state
that can be atomically swapped. Can have listeners to be called when
the state changes."
  (get-condition-state [_])
  (check-condition-state [_ value])
  (change-condition-state [_ old-value new-value])
  (add-condition-listener [_ id listener]
    "Add a listener to be called when state changes, maybe be called
spuriously. Listener is passed a single arg: id. Listener will be
called at least once right after it is added.")
  (remove-condition-listener [_ id]))

