(ns com.manigfeald.machinate.core-async
  (:require [com.manigfeald.machinate :as m]
            [clojure.core.async :as a]
            [clojure.core.async.impl.protocols :as ap]
            [clojure.core.async.impl.dispatch :as dispatch]))

;; TODO clojurescript

;; TODO use LockSupport to turn condition into a proper lock, maybe unfair?

(defn !
  "Just enough to allow you to do (<! (! evt)) and have a go block park
  correctly. DO NOT USE THE RESULT WITH core.async's alts. Prefer the
  sync! macro to avoid misuse."
  [evt]
  (reify
    ap/ReadPort
    (take! [_ fn1-handler]
      (m/sync!
       (m/wrap evt (fn [value]
                     (.lock fn1-handler)
                     (try
                       (when (ap/active? fn1-handler)
                         (when-let [cb (ap/commit fn1-handler)]
                           (dispatch/run (fn [] (cb value)))))
                       (finally
                         (.unlock fn1-handler))))))
      nil)))

(defmacro sync!
  "Convience macro that expands into (<! (! evt))"
  [evt]
  `(a/<! (! ~evt)))

;; TODO interop the other way, create an event for consuming from a
;; core.async channel?

