(ns com.manigfeald.machinate.protocols)

(defprotocol Event
  (try-event [event resume resume-with-error control nack-group cleanup]
    "internal function for syncing"))

(defprotocol Syncable
  (-sync [event] "wait for an event to occur"))

(defprotocol QuasiEvent
  (push-down [event ctor lst]
    "Given an event, which is possible a tree of built using repeated
applications of combinators, turn the tree into a \"disjunctive normal
form\" list of possible events to synchronize on"))

(defprotocol Nackable
  (check-nack-group [event nack-group]))

(defprotocol Control
  "A control is internal how synchronizing on events atomically is
managed"
  (change-state [_ current new])
  (check-state [_ check])
  (listen-to-state-change [_ key callback])
  (remove-state-change-listener [_ key]))

(defprotocol Exchange
  "An exchange is a place where two threads of control can meet and
  exchange values. There is a left side and right side. sends on the
  left are matched with sends on the right."
  (send-left [_ value]
    "return an event that on sync waits for a corresponding send-right and
returns the value it sent.")
  (send-right [_ value]
    "return an event that on sync waits for a corresponding send-left and
returns the value it sent."))

(defprotocol SendChannel
  (send-it [_ it]))

(defprotocol ReceiveChannel
  (receive-it [_]))

(defprotocol Buffer
  (full? [buf] "returns true if the given buffer is full")
  (add-item [buf item] "adds the give item to the given buffer")
  (peek-item [buf] "returns the item at the top of the buffer or nil if empty")
  (pop-item [buf] "pops the item off the top of the buffer"))

(defprotocol Channel
  (close! [_]))

(defprotocol ILock
  (lock [_])
  (unlock [_]))
