(ns com.manigfeald.machinate.platform
  (:require [com.manigfeald.machinate.protocols :as p]))

(defn mutable-list ^objects []
  (object-array 0))

(defn peek-first [^objects lst]
  (aget lst 0))

(defn pop-list [^objects lst]
  (.shift lst))

(defn add-last [^objects lst item]
  (.push lst item))

(defn print-to-error [message]
  (.log js/console message))

(defn unique-key []
  (js/Object.))

;; TODO can thens and catchs be canceld/removed?

(extend-type js/Promise
  p/Event
  (try-event [^js/Promise event resume resume-with-error control nack-group cleanup]
    (.then event
           (fn [result]
             (let [k (js/Object.)
                   f (fn [& _]
                       (when (p/check-state control :synced)
                         (p/remove-state-change-listener control k))
                       (when (p/change-state control :waiting :synced)
                         (resume event result nack-group)))]
               (p/listen-to-state-change control k f)
               (f))))
    (.catch event
            (fn [result]
             (let [k (js/Object.)
                   f (fn [& _]
                       (when (p/check-state control :synced)
                         (p/remove-state-change-listener control k))
                       (when (p/change-state control :waiting :synced)
                         (resume-with-error event result nack-group)))]
               (p/listen-to-state-change control k f)
               (f))))))

(defn promise-like-type []
  (let [res (atom nil)
        rej (atom nil)
        p (js/Promise.
           (fn [resolve reject]
             (reset! res resolve)
             (reset! rej reject)))]
    (aset p "resolve" @res)
    (aset p "reject" @rej)
    p))

(defn complete-plt [^js/Promise plt value]
  ((aget plt "resolve") value))

(defn barrier
  [f]
  (let [cf (promise-like-type)]
    (f cf #(complete-plt cf true))))

(defn now []
  (.now js/Date))

(defn run-after [^long start ^long delay f]
  (js/setTimeout f (- delay (- (now) start))))

(defn cancel-run-after [handle]
  (js/clearTimeout handle))

(def the-lock
  (reify
    p/ILock
    (lock [_this])
    (unlock [_this])))

(def lock (constantly the-lock))



(defn complete-plt-error [^js/Promise plt error]
  ((aget plt "reject") error))

(defn mutable-hash-map []
  (atom {}))

(defn hash-map-values [m]
  (vals @m))

(defn hash-map-get [m k]
  (get @m k))

(defn hash-map-put [m k v]
  (swap! m assoc k v))

(defn hash-map-remove [m k]
  (swap! m dissoc k))
