(ns com.manigfeald.machinate.queue
  (:refer-clojure :exclude [peek seq next]))

#?(:clj (set! *warn-on-reflection* true))

#?(:clj (set! *unchecked-math* :warn-on-boxed))

;; because I want a doublely linked list queue with exposed nodes to
;; facilitate fast removing from the middle of the queue when you have
;; the node in hand.

;; as a allocation optimization these queues use the queue object as a
;; re-usable queue node.

(def ^:const queue-entry-user-fields6 6)

(def ^:const queue-index6 6)

(def ^:const prev-index6 7)

(def ^:const next-index6 8)

(def ^:const head-index6 9)

(def ^:const tail-index6 10)

(def ^:const queue-size6 11)

(def ^:const queue-node-size6 9)

(defn new-queue-of-size-6 []
  (object-array queue-size6))

(defn add-entry-to-of-size-6 ^objects [^objects q]
  (let [^objects n (if (aget q queue-index6)
                     (object-array queue-node-size6)
                     q)
        ^objects t (aget q tail-index6)]
    (if t
      (do
        (aset t next-index6 n)
        (aset n prev-index6 t)
        (aset q tail-index6 n))
      (do
        (aset q tail-index6 n)
        (aset q head-index6 n)))
    (aset n queue-index6 q)
    n))

(defn peek-at-head-of-queue-of-size-6 ^objects [^objects q]
  (aget q head-index6))

(defn next-node-of-queue-of-size-6 ^objects [^objects n]
  (aget n next-index6))

(defn unlink-node-from-queue-of-size-6 [^objects node]
  (when-let [^objects q (aget node queue-index6)]
    (let [^objects p (aget node prev-index6)
          ^objects n (aget node next-index6)          
          t (aget q tail-index6)
          h (aget q head-index6)]
      (when p
        (aset p next-index6 n))
      (when n
        (aset n prev-index6 p))
      (when (identical? node t)
        (aset q tail-index6 p))
      (when (identical? node h)
        (aset q head-index6 n))
      (dotimes [i queue-index6]
        (aset node i nil))
      (aset node prev-index6 nil)
      (aset node next-index6 nil)
      (aset node queue-index6 nil))))

;; TODO tests
;; (let [q (new-queue-of-size-6)]
;;   (aset (add-entry-to-of-size-6 q) 0 :foo)
;;   (assert (= :foo (aget (peek-at-head-of-queue-of-size-6 q) 0)))
;;   (assert (= nil (next-node-of-queue-of-size-6 (peek-at-head-of-queue-of-size-6 q))))
;;   (aset (add-entry-to-of-size-6 q) 0 :bar)
;;   (assert (some? (next-node-of-queue-of-size-6 (peek-at-head-of-queue-of-size-6 q))))
;;   (assert (= :bar (aget (next-node-of-queue-of-size-6 (peek-at-head-of-queue-of-size-6 q)) 0)))
;;   (unlink-node-from-queue-of-size-6 (peek-at-head-of-queue-of-size-6 q))
;;   (assert (= :bar (aget (peek-at-head-of-queue-of-size-6 q) 0)))
;;   (unlink-node-from-queue-of-size-6 (peek-at-head-of-queue-of-size-6 q))
;;   (assert (nil? (peek-at-head-of-queue-of-size-6 q)))
;;   (aset (add-entry-to-of-size-6 q) 0 :foo1)
;;   (assert (= :foo1 (aget (peek-at-head-of-queue-of-size-6 q) 0)))
;;   (assert (= nil (next-node-of-queue-of-size-6 (peek-at-head-of-queue-of-size-6 q))))
;;   (assert (identical? (peek-at-head-of-queue-of-size-6 q) q))
;;   (aset (add-entry-to-of-size-6 q) 0 :bar)
;;   (assert (some? (next-node-of-queue-of-size-6 (peek-at-head-of-queue-of-size-6 q))))
;;   (assert (= :bar (aget (next-node-of-queue-of-size-6 (peek-at-head-of-queue-of-size-6 q)) 0))))


(defn new-q6 []
  (new-queue-of-size-6))

(defn unlink6 [q n]
  (unlink-node-from-queue-of-size-6 n))

(defn peek6 ^objects [q]
  (peek-at-head-of-queue-of-size-6 q))

(defn add-entry6 ^objects [q]
  (add-entry-to-of-size-6 q))

(def ^:const queue-entry-user-fields1 1)

(def ^:const queue-index1 1)

(def ^:const prev-index1 2)

(def ^:const next-index1 3)

(def ^:const head-index1 4)

(def ^:const tail-index1 5)

(def ^:const queue-size1 6)

(def ^:const queue-node-size1 4)

(defn new-queue-of-size-1 []
  (object-array queue-size1))

(defn add-entry-to-of-size-1 ^objects [^objects q]
  (let [^objects n (if (aget q queue-index1)
                     (object-array queue-node-size1)
                     q)
        ^objects t (aget q tail-index1)]
    (if t
      (do
        (aset t next-index1 n)
        (aset n prev-index1 t)
        (aset q tail-index1 n))
      (do
        (aset q tail-index1 n)
        (aset q head-index1 n)))
    (aset n queue-index1 q)
    n))

(defn peek-at-head-of-queue-of-size-1 ^objects [^objects q]
  (aget q head-index1))

(defn next-node-of-queue-of-size-1 ^objects [^objects n]
  (aget n next-index1))

(defn unlink-node-from-queue-of-size-1 [^objects node]
  (when-let [^objects q (aget node queue-index1)]
    (let [^objects p (aget node prev-index1)
          ^objects n (aget node next-index1)          
          t (aget q tail-index1)
          h (aget q head-index1)]
      (when p
        (aset p next-index1 n))
      (when n
        (aset n prev-index1 p))
      (when (identical? node t)
        (aset q tail-index1 p))
      (when (identical? node h)
        (aset q head-index1 n))
      (dotimes [i queue-index1]
        (aset node i nil))
      (aset node prev-index1 nil)
      (aset node next-index1 nil)
      (aset node queue-index1 nil))))


(defn new-q1 []
  (new-queue-of-size-1))

(defn unlink1 [q n]
  (unlink-node-from-queue-of-size-1 n))

(defn peek1 ^objects [q]
  (peek-at-head-of-queue-of-size-1 q))

(defn add-entry1 ^objects [q]
  (add-entry-to-of-size-1 q))

(defn next1 [q e]
  (next-node-of-queue-of-size-1 e))


(def ^:const queue-entry-user-fields4 4)

(def ^:const queue-index4 4)

(def ^:const prev-index4 5)

(def ^:const next-index4 6)

(def ^:const head-index4 7)

(def ^:const tail-index4 8)

(def ^:const queue-size4 9)

(def ^:const queue-node-size4 7)

(defn new-queue-of-size-4 []
  (object-array queue-size4))

(defn add-entry-to-of-size-4 ^objects [^objects q]
  (let [^objects n (if (aget q queue-index4)
                     (object-array queue-node-size4)
                     q)
        ^objects t (aget q tail-index4)]
    (if t
      (do
        (aset t next-index4 n)
        (aset n prev-index4 t)
        (aset q tail-index4 n))
      (do
        (aset q tail-index4 n)
        (aset q head-index4 n)))
    (aset n queue-index4 q)
    n))

(defn peek-at-head-of-queue-of-size-4 ^objects [^objects q]
  (aget q head-index4))

(defn next-node-of-queue-of-size-4 ^objects [^objects n]
  (aget n next-index4))

(defn unlink-node-from-queue-of-size-4 [^objects node]
  (when-let [^objects q (aget node queue-index4)]
    (let [^objects p (aget node prev-index4)
          ^objects n (aget node next-index4)          
          t (aget q tail-index4)
          h (aget q head-index4)]
      (when p
        (aset p next-index4 n))
      (when n
        (aset n prev-index4 p))
      (when (identical? node t)
        (aset q tail-index4 p))
      (when (identical? node h)
        (aset q head-index4 n))
      (dotimes [i queue-index4]
        (aset node i nil))
      (aset node prev-index4 nil)
      (aset node next-index4 nil)
      (aset node queue-index4 nil))))


(defn new-q4 []
  (new-queue-of-size-4))

(defn unlink4 [q n]
  (unlink-node-from-queue-of-size-4 n))

(defn peek4 ^objects [q]
  (peek-at-head-of-queue-of-size-4 q))

(defn add-entry4 ^objects [q]
  (add-entry-to-of-size-4 q))

(defn next4 [q e]
  (next-node-of-queue-of-size-4 e))
