(ns com.manigfeald.machinate.platform
  (:require [com.manigfeald.machinate.protocols :as p]))

(defn unique-key []
  (js/Object.))

;; TODO can thens and catchs be canceld/removed?


(declare check-condition-state)
(declare remove-condition-listener)
(declare change-condition-state)
(declare signal)
(declare add-condition-listener)


(extend-type js/Promise
  p/Event
  (try-event [^js/Promise event resume resume-with-error control nack-group]
    (let [action (volatile! (fn [k result exception]
                              (when (check-condition-state control :synced)
                                (remove-condition-listener control k))
                              (when (change-condition-state control :waiting :synced)
                                (signal control)
                                (if exception
                                  (resume-with-error event exception nack-group)
                                  (resume event result nack-group)))))]
      (.then event
             (fn [result]
               (let [k (js/Object.)
                     f (fn [& _]
                         (when-let [f @action]
                           (vreset! action nil)
                           (f k result nil)))]
                 (add-condition-listener control k f)
                 (f))))
      (.catch event
              (fn [result]
                (let [k (js/Object.)
                      f (fn [& _]
                          (when-let [f @action]
                            (vreset! action nil)
                            (f k nil result)))]
                  (add-condition-listener control k f)
                  (f)))))))

(defn promise-like-type []
  (let [res (atom nil)
        rej (atom nil)
        p (js/Promise.
           (fn [resolve reject]
             (reset! res resolve)
             (reset! rej reject)))]
    (aset p "resolve" @res)
    (aset p "reject" @rej)
    p))

(defn complete-plt [^js/Promise plt value]
  ((aget plt "resolve") value))

(defn barrier
  [f]
  (let [cf (promise-like-type)]
    (f cf #(complete-plt cf true))))

(defn now []
  (.now js/Date))

(defn run-after [^long start ^long delay f]
  (js/setTimeout f (- delay (- (now) start))))

(defn cancel-run-after [handle]
  (js/clearTimeout handle))


(def lock (constantly nil))

(defn do-lock [_])

(defn unlock [_])

(defn complete-plt-error [^js/Promise plt error]
  ((aget plt "reject") error))

(defn get-condition-state [a] @a)

(defn check-condition-state [this value]
  (identical? @this value))

(defn change-condition-state [this old new]
  (compare-and-set! this old new))

(defn add-condition-listener [this id listener]
  (add-watch this id (fn [& _] (listener id)))
  (listener id))

(defn remove-condition-listener [this id]
    (remove-watch this id))

(defn condition-variable [init-condition-state]
  (atom init-condition-state))

;; TODO atom watchers all run on changes, is that ok?
(defn signal [_])

(defn fixed-size-buffer [^long n]
  (let [lst (object-array 0)]
    (reify
      p/Buffer
      (full? [_]
        (<= n (count lst)))
      (add-item [_ item]
        (.push lst item))
      (peek-item [_]
        (aget lst 0))
      (pop-item [_]
        (.shift lst)))))

(defn dropping-buffer [^long n]
  (let [lst (object-array 0)]
    (reify
      p/Buffer
      (full? [_]
        (<= n (count lst)))
      (add-item [_ item]
        (when (> n (count lst))
          (.push lst item))
        item)
      (peek-item [_]
        (aget lst 0))
      (pop-item [_]
        (.shift lst)))))

(defn sliding-buffer [^long n]
  (let [lst (object-array 0)]
    (reify
      p/Buffer
      (full? [_]
        (<= n (count lst)))
      (add-item [_ item]
        (when (> n (count lst))
          (.shift lst))
        (.push lst item)
        item)
      (peek-item [_]
        (aget lst 0))
      (pop-item [_]
        (.shift lst)))))

(defn unhandled-exception [exception]
  (.log js/console
        (str
         (print-str "unhandled error returned\n")
         (prn-str exception))))

(def null-sentinel (js/Object.))

(defn result-box []
  (atom {:value nil :listeners #{}}))

(defn is-full [rb]
  (some? (:value @rb)))

(defn set-value [rb value]
  (if (some? value)
    (swap! rb assoc :value value)
    (swap! rb assoc :value null-sentinel)))

(defn get-value [rb]
  (let [v @rb]
    (if (identical? (:value v) null-sentinel)
      nil
      (:value v))))

(defn add-listener [rb listener]
  (swap! rb update-in [:listeners] conj listener))

(defn remove-listener [rb listener]
  (swap! rb update-in [:listeners] disj listener))

(defn run-listeners [rb]
  (doseq [f (seq (:listeners @rb))]
    (f)))
