(ns kotr.pipeline.gen.util)

(defn is-process-string? [v]
  (clojure.string/includes? v ")")
  )

(defn is-namespace? [v]
  (if (and (string? v)
           (not (clojure.string/starts-with? v "'"))
           )
    (let [out (->> (re-seq #"(\w+)/(\w+)" v)
                   (apply concat))]

      (if (empty? out)
        false
        true

        )
      )
    false
    )


  )


(defn get-source-name2 [fields]
  ;(clojure.pprint/pprint fields)
  (->> fields
       (mapv :transfer_fn)
       (mapv rest)
       (flatten)
       (filter is-namespace?)
       (mapv (fn [v] (first (clojure.string/split v #"/"))))
       (flatten)
       (remove nil?)
       (distinct)
       (map clojure.string/lower-case)
       (into [])))


(defn get-source-name-from-fields [fields]
  (->> fields
       (mapv :transfer_fn)
       (mapv rest)
       (flatten)
       (filter is-namespace?)
       #_(filter (fn [v]
                 (clojure.string/includes? v "/")
                 ))
       (mapv (fn [v] (first (clojure.string/split v #"/"))))
       (remove (fn [v]
                 (= "'" v)

                 ))

       (flatten)
       (into #{})))

(defn get-source-name-from-join [join]
  (when join
    (-> (nth join 1)
        (clojure.string/split #"/")
        (first)
        )
    #_(->> join
           (filter (fn [v]
                     (clojure.string/includes? v "/")
                     ))
           (mapv (fn [v] (first (clojure.string/split v #"/"))))
           (flatten)
           (into #{})
           )

    )

  )


(defn get-source-entity-name-from-sink-schema [source-list sink-schema]

  ; (clojure.pprint/pprint source-list)

  (let [remote-source-name (get sink-schema :source-name)]
    (if-not (empty? remote-source-name)
      remote-source-name
      (into [] (comp (map :queryString)
                     (map (fn [v]
                            ;(println "--- v" v)
                            (let [v (-> (clojure.string/trim v)
                                        (clojure.string/split #"FROM")
                                        (last))


                                  ;v (if r r f)

                                  ]
                              (if (< 1 (count source-list))
                                (-> (first (clojure.string/split v #"ON"))
                                    ;  (p/log-v)
                                    (clojure.string/replace "LEFT OUTER JOIN" "")
                                    (clojure.string/replace "\n" "")
                                    (clojure.string/split #" ")
                                    (distinct)
                                    )

                                (-> v
                                    (clojure.string/trim)
                                    (clojure.string/split #" ")
                                    (first)
                                    (vector)
                                    )

                                )

                              )

                            ))
                     cat
                     (remove clojure.string/blank?)
                     (map clojure.string/lower-case)
                     ) (:writeQueries sink-schema))
      )

    )

  )

