(ns kotr.pipeline.gen.schema-gen
  (:require [kotr.pipeline.gen.file-util :as u]
            [kotr.pipeline.gen.util :as cu]
            [kotr.pipeline.gen.protocol :as p]))


(def arvo-p-type #{"string" "bytes" "double" "float" "long" "int" "boolean" "null"})

(defn arvo-type-map [n]
  (if (contains? arvo-p-type (clojure.string/lower-case (or n "string")))
    n
    "string"))



(defn as-vector [trans-fn]
  (clojure.walk/postwalk (fn [v]
                           (if (list? v)
                             (into [] v)
                             v
                             )) trans-fn))




(defn process-fields [fields]
  (let [source-name (cu/get-source-name2 fields)
        sink-name (get-in fields [0 :name])]
    {:sink-name   sink-name
     :source-name source-name
     :fields      fields}))

(defn add-logical-type [m]
  ;(println "--" m)
  (if (get m :type)
    (let [type (get m :type "string")]
      (assoc m :type (arvo-type-map type)
               :logicalType type))
    m
    )
  )


(defn as-mapping-schema [mapping]
  ;(clojure.pprint/pprint mapping)
  ;(println "-------------")
  (let [mapping (mapv add-logical-type mapping)
        schema-m (process-fields mapping)

        fields (into [] (map (fn [v]
                               ;(println "--" v)
                               (let [tf (as-vector (get v :transfer_fn))
                                     type (get v :type)]
                                 {:name        (get v :field_name)
                                  :source-type (get v :source-type)
                                  :schema      {:type        (arvo-type-map type)
                                                :logicalType type}
                                  :transfer_fn tf})
                               )) (get schema-m :fields))
        m (->> (filter (fn [v] (clojure.string/blank? (:name v))) fields)
               (mapv :transfer_fn)
               (group-by first)
            ;   (p/log-v)
               (reduce-kv (fn [acc k v]
                         ;   (println "-- k v" k "-- " v)
                            (condp = (clojure.string/lower-case k)
                              "where"
                              (let [l (mapv second v)
                                    out (if (< 1 (count l))
                                          ["where" (into ["and"] l)]
                                          ["where" (first l)])]
                                (assoc acc (keyword k) out))
  ;                            "generator-type" (assoc acc (keyword k) (last v))
                              (assoc acc (keyword k) (first v))
                              )
                            ) {}))
        schema-m (merge m schema-m)


        xf (remove (fn [v] (clojure.string/blank? (:name v))))
        schema-keys (apply disj (into #{} (keys schema-m)) [:fields :sink-name :source-name :type :where :join :left_join] )
        schema-m (reduce (fn [acc k]
                           (update acc k (fnil second [k nil] ))
                           ) schema-m schema-keys)

        ]

    ;(println "--" schema-keys)
    (-> schema-m
        (assoc :fields (into [] xf fields))
        (update :type (fnil second ["type" "stream"] ))

        )
    ))




#_(defn convert-mapping-schema-to-stream-schema [mapping-schema]
    ;(clojure.pprint/pprint mapping-schema)
    (->> mapping-schema
         (reduce (fn [acc v]
                   ;(clojure.pprint/pprint v)
                   (let [
                         ;key-name (get-in)
                         m (-> v
                               (select-keys [:sink-name :fields :key])
                               (update :fields (fn [coll]
                                                 (mapv #(select-keys % [:name :schema]) coll))))
                         v (if (:name m)
                             m
                             (assoc m :name (get m :sink-name)))
                         n (get v :sink-name)]
                     (if (get acc n)
                       acc
                       (assoc acc n v)))
                   ) {})
         (vals)
         (into [] (comp (map (fn [m]
                               (assoc m :type p/gen-ksql-stream :key (get-in m [:fields 0 :name]))
                               ))))
         )
    )



#_(defn process-entity-one [data-dir w]
    (let [f-path (when (and (:connector_source w)
                            (not (clojure.string/blank? (:connector_source w))))
                   (str data-dir "/" (get w :connector_ref_name) ".csv"))
          fields (when f-path
                   (let [delimiter (get w :delimiter)
                         separator (if (= delimiter ";") \; \,)]
                     (->> f-path
                          (u/get-csv-header separator)
                          (into #{})
                          (mapv (fn [v]
                                  {:name v, :schema {:type "STRING"}})))))
          w (if fields (assoc w :fields fields) w)]
      (-> w
          (assoc :connector_source_path f-path)
          (update-in [:connector_source] (fn [v]
                                           (if (clojure.string/blank? v)
                                             nil
                                             (->> (clojure.string/split v #" ")
                                                  #_(into [] (map keyword)))
                                             #_(keyword v))))
          (update-in [:name] clojure.string/lower-case)
          (update-in [:key] (fn [v]
                              (let [v (clojure.string/lower-case v)]
                                (if (clojure.string/blank? v)
                                  nil
                                  (let [w (-> (clojure.string/trim v)
                                              (clojure.string/split #" "))]
                                    (if (= 1 (count w))
                                      (first w)
                                      w))))))
          (update-in [:connector_sink] (fn [v]
                                         (if (clojure.string/blank? v)
                                           nil
                                           (->> (clojure.string/split v #" ")

                                                #_(into [] (map keyword)) #_(keyword v))
                                           ))))))

;(clojure.string/split "asdf" #" ")

#_(defn process-entity-batch [data-dir coll]
    (let [xf (comp
               (remove (fn [v] (clojure.string/blank? (get v :name))))
               (map (fn [v] (process-entity-one data-dir v)))
               (map (fn [w] {(get w :name) w})))]
      (into {} xf coll)))

#_(defn process-entity-file [entity-file-name data-dir]
    (process-entity-batch data-dir (u/read-csv-file entity-file-name))
    #_(let [xf (comp
                 (map (fn [v] (process-entity-one data-dir v)))
                 (map (fn [w] {(get w :name) w})))]
        (into {} xf (u/read-csv-file entity-file-name))))


#_(defn gen-data-schema [meta-data-dir data-dir entity-prefix]
    (into {} (map (fn [v]
                    (process-entity-batch data-dir (u/read-csv-file v))
                    )) (u/get-file-list-by-prefix entity-prefix meta-data-dir)))

(comment


  ;(clojure.string/split "test tst " #" ")

  (u/read-csv-file "app/allianz_life/meta-data/entity-mapping.csv")

  (gen-data-schema "app/allianz_life/src" "app/allianz_life/data" "entity-")


  (process-entity-file "app/allianz_life/meta-data/entity-mapping.csv" "app/allianz_life/source")


  (u/read-csv-file "data/meta-data/field-gen.csv")

  (u/read-csv-file "data/meta-data/entity-gen.csv")

  (read-key-map-file "data/config/source.csv")

  (get-file-list ".csv" "data/meta-data")


  (->> (u/read-csv-file "data/meta-data/entity-gen.csv")
       (into [] (gen-schema-from-data-dir "data/source")))

  (-> (model-from-entity-mapping "data/meta-data/entity-gen.csv" "data/source")
      ;(arvo-schema-from-csv)
      )

  )