(ns kotr.pipeline.gen.reader.csv-mapping-reader
  (:require [kotr.pipeline.gen.file-util :as u]
            [kotr.pipeline.gen.protocol :as p]
            [clojure.tools.reader.edn :as edn]))



(defn read-mapping-file [file-name]
  (->> (u/read-csv-file file-name)
       (partition-by (fn [v]
                       (clojure.string/blank? (:name v))))
       ;(remove (fn ) )
       (remove (fn [v]
                 (every? clojure.string/blank? (mapv :name v) )
                 #_(= 1 (count v))))))


(comment


  (u/read-csv-file "app/azben/mapping/2test.csv")


  (read-mapping-file "app/azben/mapping/2test.csv")

  )

(defn is-digit? [v]
  (try
    (number? (edn/read-string (pr-str v)))
    (catch Exception e
      (do
        ; (println "--exectp" v)
        false)))



  #_(if (re-find (re-pattern "\\d+") v)
      true false))


(defn format-transormation-fn [w]
  ;(clojure.pprint/pprint w)
  (if (nil? w)
    (list "null" "")
    (try
      (let [v (clojure.string/trim w)
            ;          _ (println "--" v)
            ]
        (cond
          (clojure.string/blank? v)
          (list "null" v)

          (clojure.string/starts-with? v "(")
          (->> (edn/read-string v)
               (clojure.walk/postwalk (fn [v1]
                                        ;                                      (println v1)
                                        (cond (sequential? v1)
                                              (into [] v1)
                                              :else
                                              (do
                                                ;(println "--" v1)
                                                (if (is-digit? v1)
                                                  (do
                                                    ;(println "--digit " v1)
                                                    v1
                                                    )

                                                  (str v1)
                                                  )

                                                )
                                              ))))


          (not (clojure.string/includes? v "/"))
          (list "constant" v)
          :else
          (list "as" v))
        ;     (println "--344" w)
        )
      (catch Exception e
        (do
          (p/log-v w)
          ; (println "---" w)
          (throw (ex-info (str "Invalid mapping for " w " please check right ) ") {:mapping w}))
          )
        ))
    )
  )


(comment

  (format-transormation-fn "(where (= ref_mapping/oe_name 2))")

  )

(defn convert-quoute-to-string [v]

  (when v
    (let [v1 (clojure.string/split v #"'")]
      (loop [[f1 & r] v1
             toggle true
             out ""]
        (if (nil? f1)
          out
          (let [o (if (empty? r)
                    (str out f1)
                    (if toggle
                      (str out f1 "\"'")
                      (str out f1 "'\"")))]
            (recur r (not toggle) o)))))
    )
  )


(comment

  ;(not (not true))

  ;(convert-quoute-to-string "'asdf' 'asdf")

  )


(defn format-mapping [coll]
  (into [] (comp
             (map (fn [v]
                    ;(convert-quoute-to-string v)
                    (update v :transfer_fn convert-quoute-to-string)
                    ))
             (map (fn [v] (update v :transfer_fn format-transormation-fn)))
             (map (fn [v]

                    ;(println "--" v)
                    (-> v
                        (update :name clojure.string/lower-case)
                        (update :field_name (fn [v]
                                              (when v
                                                (clojure.string/lower-case v))))
                        (update :transfer_fn (fn [v]
                                               ;          (clojure.pprint/pprint v)
                                               (clojure.walk/postwalk (fn [w1]
                                                                        ; (println "--" w1)
                                                                        (if (and
                                                                              (string? w1)
                                                                              (not (clojure.string/starts-with? w1 "'"))
                                                                              (clojure.string/includes? w1 "/"))
                                                                          (clojure.string/lower-case w1)
                                                                          w1)) v))))))
             (map (fn [m]
                    ;             (println "--" m)
                    (let [
                          ; m
                          #_(if (get m :type)
                              m
                              (assoc m :type nil))
                          m (if (get m :doc)
                              m
                              (assoc m :doc ""))]
                      m)))
             ) coll))


(defn read-req [v]

  (if (string? v)
    (->> (read-mapping-file v)
         ;(p/log-v)
         (mapv format-mapping ))

    (->> (mapv (fn [v1]
                 (mapv #(zipmap [:name :field_name :transfer_fn :type] %) v1)
                 ) v)
         (mapv format-mapping)
         ;(p/log-v)
         )))




(comment


  #_(->> [[["raw_bnl_claim2"
            "LOCAL_CLAIM_ID"
            "(replace raw_bnl_claim/LOCAL_CLAIM_ID ',' '')"]
           ["raw_bnl_claim2"
            "EFFECTIVE_LOSS_DATE"
            "(replace raw_bnl_claim/EFFECTIVE_LOSS_DATE '/' '-')"]]]
         (read-req)

         )

  (->> [[["tnf_policy" "policy_number" "id3_zvspolp_policy/FBFPCU_State_Id" "string" "doc..."]
         ["tnf_policy" "policy_number" "(+ 1 2)"]]]
       (read-req)
       ;(compile-mapping-one)
       )

  (is-digit 1)

  )


