(ns kotr.pipeline.gen.reader.csv-data-reader
  (:require [kotr.pipeline.gen.file-util :as u]
            [cheshire.core :as json]))


(defn load-template [template-path]
  (-> template-path
      (slurp)
      (json/parse-string true)))


(defn read-csv-header
  ([csv-file-path ] (read-csv-header csv-file-path \;))
  ([csv-file-path separator]
   (let [
         ;csv-file-path (str data-dir "/" entity-name ".csv")
         ; separator (get-in config [:config :csv.separator.char])
         ;separator (or separator \;) #_(if (= separator 59) \; \,)
         ]
     (->> csv-file-path
          (u/get-csv-header separator)
          (into [])))))


(defn read-header [config csv-file-path]
  (let [
        ;csv-file-path (str data-dir "/" entity-name ".csv")
        separator (get-in config [:config :csv.separator.char])
        separator (if (= separator 59) \; \,)]
    (->> csv-file-path
         (u/get-csv-header separator)
         (into #{}))))

(defn get-file-name [file-name]
  (-> (clojure.java.io/as-file file-name)
      (.getName)
      (clojure.string/split #"\.")
      (first)))


(defn gen-schema-from-entity-one [e ]
 ; (clojure.pprint/pprint e)
  (let [template-path (get e :ds_file)
        file-path (get e :data_file)
        pk-name (get e :key)
        e-name (get e :entity_name)
        e-name (if (clojure.string/blank? e-name)
                 nil
                 e-name
                 )
        tn (get-file-name template-path)
        t (load-template template-path)
        connector_ref_name (get-file-name file-path) #_(or e-name)
        fields (->> (read-header t file-path)
                    (mapv (fn [v]
                            {:name v, :schema {:type "string"}})))]
    {:name               (or e-name connector_ref_name)
     :key                pk-name
     :fields             fields
     :connector_ref_name connector_ref_name
     :connector_source   tn
     :connector          t}))

#_(defn gen-schema-from-entity [entity-list]
  (let [xf (comp (map gen-schema-from-entity-one))]
    (into [] xf entity-list)))



(comment

  (clojure.string/split "")

  (->> [["app/allianz_life/config/csv_source.json" "app/allianz_life/data/Product.csv" "product_code" "product"]]
       (gen-schema-from-entity)
       )



  #_(gen-schema-from-entity "app/allianz_life/config/csv_source.json"
                            [["product" "product_code" "Product"]]
                            "app/allianz_life/data")



  ;"app/allianz_life/config/csv_source.json"

  )