(ns kotr.pipeline.gen.protocol)


(defmulti gen-ksql :ksql-gen-type)

(def gen-ksql-stream "STREAM")
(def gen-ksql-rekey-stream-from-mapping "REKEY")
;(def gen-ksql-rekey-stream-from-mapping "REKEY")
(def gen-ksql-stream-insert-from-mapping "MAPPING")
(def gen-ksql-stream-from-mapping "MAPPING2")
(def gen-ksql-stream-from-topic "TOPIC-TO-STREAM")
(def gen-ksql-stream-from-stream "STREAM-TO-STREAM")
(def gen-ksql-table-from-stream-after-rekey "table-from-stream-after-rekey")
(def gen-ksql-table-from-stream "table-from-stream")

(defmulti expand-macro (fn [_ _ mapping-fields] (first (get mapping-fields :transfer_fn))))
(def ^:dynamic expand-macro-order {"join"   202
                                   "lookup" 203
                                   "where"  101
                                   "table"  301
                                   "select" 10})

(defmethod expand-macro :default
  [_ _ m]
  (vector m))


(defmulti transfer-fn (fn [f]
                        (-> (first f)
                            (clojure.string/trim)
                            (clojure.string/lower-case))))


(defmulti emit-connector (fn [m]
                           ;(get m t)
                           (get-in m [:template :config :connector.class])

                           ))


(defn log-v [v]
  (println "--start--")
  (clojure.pprint/pprint v)
  (println "--end--")
  v
  )


(defprotocol GetValue
  (-getValue [_]))

(defrecord ConstantValue [v]
  GetValue
  (-getValue [_] v))


(defrecord RefValue [v]
  GetValue
  (-getValue [_] v))


(defrecord QuoteStringValue [v]
  GetValue
  (-getValue [_] v))

(defn as-constant [v]
  (->ConstantValue v))


(defn as-referance [v]
  (->RefValue v))

(defn as-quote-string [v]
  (->QuoteStringValue v))


(defn get-value [v-type]
  (-getValue v-type))


(comment

  ;(get-value (as-constant 23))


  )


(def msg {:100 "Could not find this reference on current context "
          :500 "Key is missing in mapping or source stream/table "



          })