(ns kotr.pipeline.gen.macro-expand-join
  (:require [clojure.tools.reader.edn :as edn]))


(def join-name-set #{"left_join" "join" "inner_join"})

(defn join-transoformation? [field]
  (if (contains? join-name-set (get-in field [:transfer_fn 0]))
    true false))

(defn get-entity-name-list [transformation-fn]
  (->> (pr-str transformation-fn)
       (re-seq #"(\w+)/(\w+)")
       (apply concat)
       (filter #(clojure.string/includes? % "/"))
       (map (fn [v]
              (first (clojure.string/split v #"/"))))
       (into [])
       ;(distinct)
       #_(first)))





(comment

  (get-entity-name-list ["join"
                         "id3_zvspolp_policy/fbfncu_policy_id"
                         "id3_poltblp_policy/b4docd_policy_number"])

  )

;;;;;;;;;;;;;;;;
(defn create-join-fields [fields]
  (let [f (last fields)
        join-f (get-in f [:transfer_fn 1])
        f-name (last (clojure.string/split join-f #"/"))]
    {:field_name  f-name
     :type        (get f :type)
     :transfer_fn ["as " join-f]}))


(defn map-join-fields [field-coll-coll]

  (loop [[field-coll & field-coll-coll] field-coll-coll
         out []]

    (if (nil? field-coll)
      out
      (let [w (mapv create-join-fields field-coll-coll)
            previous-fields (->> (or (last out) [])
                                 (remove (fn [m]
                                           (or
                                             (clojure.string/blank? (get m :field_name))
                                             (nil? (get m :name)))))
                                 (into []))
            fields (into previous-fields (butlast field-coll))
            fields-name-set (into #{} (map :field_name) fields)
            ;_ (println "--" fields-name-set "--" (get w :field_name))
            w (into [] (remove (fn [m]
                                 (contains? fields-name-set (get m :field_name))
                                 ) ) w )

            fields (into fields w)

            join-fields (last field-coll)
            fields (conj fields join-fields)]
        (recur field-coll-coll (conj out fields))))))


(defn partition-join [mapping]
  (->> mapping
       (partition-by join-transoformation? )
       (partition-all 2)
       (mapv (fn [w] (into [] (apply concat w))))
       (map-join-fields)))

(defn get-join-entity-name [n-mapping]
  (->> n-mapping
       (filter join-transoformation?)
       (map (fn [m]
              (first (clojure.string/split (get-in m [:transfer_fn 1]) #"/"))))
       (first)))


(defn replace-name-space
  ([next-mapping previous-field-set f-step]
    ;(clojure.pprint/pprint previous-field-set)
   (let [source-name (get-join-entity-name next-mapping)
         old-name (str source-name "/")
         f-step-str (str f-step "/")
         n-mapping (-> (pr-str next-mapping)
                       (clojure.string/replace (clojure.string/lower-case old-name)
                                               (clojure.string/lower-case f-step-str))
                       (edn/read-string))
         n-mapping (into [] (comp (map (fn [m]
                                         (if (contains? previous-field-set (get m :field_name))
                                           (assoc m :transfer_fn ["as" (str f-step "/" (get m :field_name))])
                                           m)))
                                  (remove nil?)
                                  ) n-mapping)]
     n-mapping))
  ([current-mapping next-mapping previous-field-set f-step]
   (let [f-mapping (into [] (map (fn [m]
                                   (assoc m :name f-step)
                                   )) current-mapping)
         n-mapping (replace-name-space next-mapping previous-field-set f-step)]
     [f-mapping n-mapping])))


(defn create-intermediate-stream-names [mapping-coll]
  (let [mapping (first mapping-coll)
        source-name (get-join-entity-name mapping)
        sink-name (get-in mapping [0 :name])
        total-step (count mapping-coll)
        step-names (mapv (fn [step]
                           (str sink-name "_step" (+ step 1) "of" (- total-step 1) "_" source-name)
                           ) (range (- total-step 1)))]
    (loop [[current-mapping & r-mapping] mapping-coll
           [current-step-name & r-steps] step-names
           previous-step-name nil
           result []]
      (if (nil? current-step-name)
        (let [previous-field-set (into #{} (comp (map :field_name)
                                                 (remove (fn [v] (clojure.string/blank? v)))
                                                 ) (last result))
              f-mapping (replace-name-space current-mapping previous-field-set previous-step-name)]
          (conj result f-mapping))
        (let [next-mapping (first r-mapping)
              current-field-set (into #{} (comp (map :field_name)
                                                (remove (fn [v] (clojure.string/blank? v)))
                                                ) current-mapping)
              [current-mapping next-mapping] (replace-name-space current-mapping next-mapping current-field-set current-step-name)
              r-mapping (into [next-mapping] (rest r-mapping))]
          (recur r-mapping r-steps current-step-name (conj result current-mapping)))))))

(defn debug [m]

  (clojure.pprint/pprint m)
  m
  )

(defn join-expand [mapping]
  ;(clojure.pprint/pprint mapping)
  (let [join-fields (into [] (comp (filter join-transoformation?)
                                   (map :transfer_fn)
                                   (map get-entity-name-list)
                                   ) mapping)]
    ;(println "--" join-fields)
    (if (and join-fields
             (< 1 (count join-fields)))
      (let [k (into [] (comp (filter (fn [f]
                                       (contains? #{"key"} (-> f :transfer_fn first ))
                                       ) )) mapping )
            mapping (into [] (comp (remove (fn [f]
                                             (contains? #{"key"} (-> f :transfer_fn first ))
                                             ) )) mapping )
            ]
        ;(clojure.pprint/pprint k)
        (->> (partition-join mapping)
             ;(debug)
             (create-intermediate-stream-names)
             (into [] (map (fn [mapping]
                             (into mapping k)
                             ))  )
             )
        )

      [mapping])))




(comment






  (partition-join data)


  (def data [{:name "raw_bnl_claim3",
              :field_name "local_claim_id",
              :transfer_fn ["as" "raw_bnl_claim2/local_claim_id"],
              :type "string",
              :doc "",
              :logicalType "string"}
             {:name "raw_bnl_claim3",
              :field_name "local_loss_cause_id",
              :transfer_fn ["as" "raw_bnl_claim2/local_loss_cause_id"],
              :type "string",
              :doc "",
              :logicalType "string"}
             {:name "bnl_raw_claim3",
              :field_name "global_claim_status",
              :transfer_fn ["as" "ref_mapping2/global_value"],
              :type "string",
              :doc "",
              :logicalType "string"}
             {:name "bnl_raw_claim3",
              :field_name "",
              :transfer_fn
              ["left_join"
               "raw_bnl_claim2/local_claim_status_id"
               "ref_mapping2/id"],
              :type "string",
              :doc "",
              :logicalType "string"}
             {:name "bnl_raw_claim3",
              :field_name "global_loss_cause",
              :transfer_fn ["as" "ref_mapping2/global_value"],
              :type "string",
              :doc "",
              :logicalType "string"}
             {:name "bnl_raw_claim3",
              :field_name "",
              :transfer_fn
              ["left_join" "raw_bnl_claim2/local_loss_cause_id" "ref_mapping2/id"],
              :type "string",
              :doc "",
              :logicalType "string"}])


  (do



    (let [w [{:name        "bnl_raw_claim3",
              :field_name  "local_claim_id",
              :transfer_fn ["as" "raw_bnl_claim2/local_claim_id"],
              :type        "string",
              :doc         "",
              :logicalType "string"}
             {:name        "bnl_raw_claim3",
              :field_name  "global_claim_status",
              :transfer_fn ["as" "ref_mapping2/global_value"],
              :type        "string",
              :doc         "",
              :logicalType "string"}
             {:name        "bnl_raw_claim3",
              :field_name  "",
              :transfer_fn
                           ["left_join"
                            "raw_bnl_claim2/local_claim_status_id"
                            "ref_mapping2/id"],
              :type        "string",
              :doc         "",
              :logicalType "string"}
             {:name        "bnl_raw_claim3",
              :field_name  "global_loss_cause",
              :transfer_fn ["as" "ref_mapping2/global_value"],
              :type        "string",
              :doc         "",
              :logicalType "string"}
             {:name        "bnl_raw_claim3",
              :field_name  "",
              :transfer_fn
                           ["left_join" "raw_bnl_claim2/local_loss_cause_id" "ref_mapping2/id"],
              :type        "string",
              :doc         "",
              :logicalType "string"}]

          ]
      (join-expand w)

      )


    nil
    )




  (re-seq #"(\w+)/(\w+)" "clojure asdfs/asfdsf 1.1.0")

  ;(clojure.string/)
  ;(last [])
  ;(last [1 2 3])

  ;(split-at 3 [1 2 3])

  (join-expand test-data2)

  (def test-data2 [{:name        "party_female",
                    :field_name  "party_id",
                    :transfer_fn ["as" "tnf_party/party_id"],
                    :type        "string",
                    :doc         "",
                    :logicalType "string"}
                   {:name        "party_female",
                    :field_name  "ramdom_key",
                    :transfer_fn
                                 ["gen_id_md5" ["concat" "tnf_party/party_id" "'123'"] "'-123'"],
                    :type        "string",
                    :doc         "",
                    :logicalType "string"}
                   {:name        "party_female",
                    :field_name  "policy_number2",
                    :transfer_fn ["constant" "123"],
                    :type        "string",
                    :doc         "",
                    :logicalType "string"}
                   {:name        "party_female",
                    :field_name  nil,
                    :transfer_fn ["where" ["=" "tnf_party/gender" "'F'"]],
                    :type        "string",
                    :doc         "",
                    :logicalType "string"}
                   {:name        "party_female",
                    :field_name  "t",
                    :transfer_fn ["as" "pet/type"],
                    :type        "string",
                    :doc         "",
                    :logicalType "string"}
                   {:name        "party_female",
                    :field_name  "",
                    :transfer_fn ["left_join" "pet/id" "tnf/party_t"],
                    :type        "string",
                    :doc         "",
                    :logicalType "string"}
                   {:name        "party_female",
                    :field_name  "t1",
                    :transfer_fn ["as" "pet1/type"],
                    :type        "string",
                    :doc         "",
                    :logicalType "string"}
                   {:name        "party_female",
                    :field_name  "",
                    :transfer_fn ["left_join" "pet1/id" "tnf2/party_t"],
                    :type        "string",
                    :doc         "",
                    :logicalType "string"}
                   {:name        "party_female",
                    :field_name  nil,
                    :transfer_fn ["join" "tnf_party/party_id" "tnf_party_address/city"],
                    :type        "string",
                    :doc         "",
                    :logicalType "string"}])


  (join-expand data2)

  (def data2 [{:name        "tnf_policy",
               :field_name  "policy_number",
               :transfer_fn ["as" "id3_zvspolp_policy/FBFNCU_Policy_Id"],
               :doc         "",
               :type        "String",
               :logicalType "String"}
              {:name        "tnf_policy",
               :field_name  "issue_state",
               :transfer_fn ["as" "id3_poltblp_policy/FBFPCU_State_Id"],
               :doc         "",
               :type        "String",
               :logicalType "String"}
              {:name        "tnf_policy",
               :field_name  "fixed",
               :transfer_fn ["constant" "10"],
               :doc         "",
               :type        "string"}
              {:name        "tnf_policy",
               :field_name  "",
               :transfer_fn ["join" "id3_zvspolp_policy/FBFNCU_Policy_Id" "id3_poltblp_policy/B4DOCD_Policy_Number"],
               :doc         "",
               :type        "string",
               :logicalType ""}
              {:name        "tnf_policy",
               :field_name  "product_id",
               :transfer_fn ["as" "tnf_product/Product_Code"],
               :doc         "",
               :type        "String",
               :logicalType "String"}
              {:name        "tnf_policy",
               :field_name  "plan_code",
               :transfer_fn ["as" "id3_zvspolp_policy/FBFVCU_Plan_Code"],
               :doc         "",
               :type        "String",
               :logicalType "String"}
              {:name        "tnf_policy",
               :field_name  "",
               :transfer_fn ["join" "id3_zvspolp_policy/FBFVCU_Plan_Code" "tnf_product/Product_Code"],
               :doc         "",
               :type        "String",
               :logicalType "String"}])




  (def data
    [{:name        "claim_re",
      :field_name  "claim_payment_date",
      :transfer_fn ["as" "claim_in/claim_payment_date"],
      :doc         "",
      :type        "Date"}
     {:name "claim_re", :field_name "claim_id", :transfer_fn ["as" "claim_in/claim_id"], :doc "", :type "string"}
     {:name        "claim_re",
      :field_name  "total_loss_payment_amount",
      :transfer_fn ["as" "claim_in/total_loss_payment_amount"],
      :doc         "",
      :type        "string"}
     {:name        "claim_re",
      :field_name  "fixed",
      :transfer_fn ["constant" "10"],
      :doc         "",
      :type        "string"}
     {:name "claim_re", :field_name "claim_code", :transfer_fn ["as" "claim_status_code/code"], :doc "", :type "string"}
     {:name        "claim_re",
      :field_name  "",
      :transfer_fn ["join" "claim_in/status" "claim_status_code/claim_status"],
      :doc         "",
      :type        "string"}
     {:name "claim_re", :field_name "repair_code", :transfer_fn ["as" "repair_type/code"], :doc "", :type "string"}
     {:name        "claim_re",
      :field_name  "",
      :transfer_fn ["join" "claim_in/repair_type" "repair_type/type"],
      :doc         "",
      :type        "string"}
     {:name "claim_re", :field_name "", :transfer_fn ["join" "claim_in/repair_type" "ctype/type"], :doc "", :type "string"}

     {:name        "claim_re", :field_name "",
      :transfer_fn ["where" ["=" "ctype/id" "122"]],
      :doc         "", :type "string", :logicalType "string"}
     {:name "claim_re", :field_name "repair_type", :transfer_fn ["as" "ctype/code"], :doc "", :type "string"}])


  (join-expand data)

  (group-by-source data)

  )