(ns kotr.pipeline.gen.macro-expand
  (:require [kotr.pipeline.gen.protocol :as p]
            [kotr.pipeline.gen.reader.csv-data-reader :as r]
            [kotr.pipeline.gen.schema-gen :as sg]
            [clojure.tools.reader.edn :as edn]))



(defmethod p/expand-macro "from_csv"
  [_ _ mapping-field]

  (let [n (get mapping-field :name)
        [_ file_name] (get mapping-field :transfer_fn)
        header (r/read-csv-header (clojure.string/replace file_name "'" ""))
        fields (into [] (map (fn [f]
                               {:name n :field_name f :type "string"}
                               )) header)]
    fields))


(defmethod p/expand-macro "lookup"
  [_ _ mapping-field]
  (let [[t lookup-key w] (into [] (get mapping-field :transfer_fn))
        [_ source-key rel-key] (into [] w)]
    (vector
      (assoc mapping-field :transfer_fn (vector "as" lookup-key))
      (assoc mapping-field :transfer_fn (vector "left_join" source-key rel-key) :field_name "")))
  )

(defmethod p/expand-macro "select"
  [schema-m selectd-fields mapping-field]
  ;(clojure.pprint/pprint selectd-fields)
  (let [field-names (rest (get mapping-field :transfer_fn))
        w (mapv (fn [v]
                  (clojure.string/split v #"/")
                  ) field-names)
        ;_ (println "--" w)
        entity-name (distinct (into [] (comp (map first)
                                             ) w))
        field-names (into #{} (distinct (into [] (comp
                                                   (map second)
                                                   (remove nil?)
                                                   (map clojure.string/upper-case)
                                                   ) w)))
        _ (when (< 1 (count entity-name))
            (throw (ex-info "select should be only one entity, found more than one " {:value entity-name})))
        ;_ (println "--fields names" field-names)
        source-name (clojure.string/lower-case (first entity-name))
        schema (get schema-m source-name)
        _ (when (nil? schema)
            (let [available-schema (clojure.string/join ",\n " (keys schema-m))]
              (throw (ex-info (format "source schema is null for %s, available schema %s " source-name, available-schema) {:source mapping-field}))
              )
            )
        ;k (get schema :key)


        ;field-names (conj field-names k)

        fields (if (or
                     (empty? field-names)
                     (contains? field-names "*"))
                 (get schema :fields)
                 (into [] (filter (fn [v]
                                    (contains? field-names (clojure.string/upper-case (get v :name)))
                                    )) (get schema :fields))
                 )



        previous_field (into #{} (comp (map :field_name)
                                       (remove nil?)
                                       (map clojure.string/lower-case)) selectd-fields)


        fields (into []
                     (comp
                       (remove (fn [field]
                                 (contains? previous_field (clojure.string/lower-case (get field :name)))
                                 ))
                       (map (fn [field]

                              (-> field
                                  (assoc :name (get mapping-field :name))
                                  (assoc :field_name (get field :name))
                                  (dissoc :schema)
                                  (assoc :transfer_fn ["as" (str source-name "/" (get field :name))])
                                  )
                              )))
                     fields)
        ; _ (clojure.pprint/pprint fields)

        ]
    ;(println source-name "---------------" fields)
    ;[[]]
    fields
    )

  )

(defmethod p/expand-macro "where"
  [schema-m mapping mapping-field]
  ;(clojure.pprint/pprint mapping-field)
  (let [field (into [] (comp (map :field_name)
                             (remove nil?)
                             (remove clojure.string/blank?)
                             ) mapping)]
    ; (println "--total count " (count field))

    (if (< 0 (count field))
      [mapping-field]
      (let [entity-name-list (->> mapping-field
                                  :transfer_fn
                                  (flatten)
                                  (filter (fn [v] (clojure.string/includes? v "/")))
                                  (map (fn [v]
                                         (first (clojure.string/split v #"/"))
                                         ))
                                  (distinct)
                                  )
            _ (when (< 1 (count entity-name-list))
                (throw (ex-info "select should be only one entity, found more than one " {:value entity-name-list}))
                )
            ;entity-name (first entity-name-list)
            source-name (clojure.string/lower-case (first entity-name-list))
            schema (get schema-m source-name)
            ; _ (clojure.pprint/pprint schema)
            fields (mapv (fn [field]
                           (-> field
                               (assoc :name (get mapping-field :name))
                               (assoc :field_name (get field :name))
                               (dissoc :schema)
                               (assoc :transfer_fn ["as" (str source-name "/" (get field :name))]))
                           ) (get schema :fields))

            fields (conj fields mapping-field)
            ;fields
            #_(conj fields {:name  (get mapping-field :name)
                            ; :transfer_fn ["generator-type" p/gen-ksql-stream-from-stream]
                            :topic (:topic schema)
                            })
            ]
        ;(println "--" source-name)
        fields
        )
      )

    )
  )

(comment



  (flatten ["where" ["=" "tnf_party/gender" "'F'" ["and "]]])

  )

