(ns kotr.pipeline.gen.emitter.ksql.core
  (:require [kotr.pipeline.gen.emitter.ksql.ksql-gen-trans :as ti]
            [kotr.pipeline.gen.util :as kutil]
            [kotr.pipeline.gen.protocol :as p]
            [clojure.tools.logging :as log]))


(def ^:dynamic current-context {})

(defn as-create-fields [fields]
  (let [w (->> (reduce (fn [acc v]
                         (->> (str (get v :name) " " (get-in v [:schema :type]))
                              (conj acc))) [] fields)
               (clojure.string/join " , "))]
    (-> (str "( " w " )")
        (clojure.string/upper-case))))


(defn do-fields-transformation [f]
  ;(clojure.pprint/pprint f)
  (let [n (get f :name)
        sink-type (get-in f [:schema :type])
        ;_ (println (get f :source-type ""))
        ;   _ (println "--sink type" sink-type "--source type " (get f :source-type ) "--" n)
        source-type (when-let [w (get f :source-type)]
                      (clojure.string/lower-case w)
                      )

        ;_ (println "--name " n "---type " t)
        transformation? (sequential? (get f :transfer_fn))
        uf (if transformation?
             (ti/field-transformation (get f :transfer_fn))
             (get f :transfer_fn))
        v (if (and sink-type
                   (not (nil? source-type))
                   (not= source-type (clojure.string/lower-case sink-type))

                   )
            (str " CAST ( " uf " AS " sink-type " )  ")
            (str " " uf " ")

            )]
    (str v " AS " n " ")))


(defn do-fields-transformation-batch [fields]
  ;(clojure.pprint/pprint fields)
  (let [t-fields (filter :transfer_fn fields)]
    (if (empty? t-fields)
      "*"
      (->> t-fields
           (reduce (fn [acc f]
                     (conj acc (do-fields-transformation f))) [])
           (clojure.string/join ",")))))

(comment

  (-> (list {:name   "gender_full",
             :schema {:type "string", :logicalType "string"},
             :transfer_fn
                     ["case"
                      "customer_re/gender"
                      ["=" "'M'" "'Male'"]
                      ["=" "'W'" "'FEMALE'"]]}

            {:name        "gender",
             :schema      {:type "string", :logicalType "string"},
             :transfer_fn ["as" "customer_cons/gender"]})
      (do-fields-transformation-batch)
      )


  (-> [{:name        "local_claim_id",
        :schema      {:type "string", :logicalType "string"},
        :transfer_fn ["replace" "raw_bnl_claim/local_claim_id" "'" "'" "''"]}
       {:name   "effective_loss_date",
        :schema {:type "string", :logicalType "string"},
        :transfer_fn
                ["replace" "raw_bnl_claim/effective_loss_date" "'/'" "'-'"]}]
      (do-fields-transformation-batch)
      )

  )

(defn make-with-clause-with-partitions
  ([topic-name] (make-with-clause-with-partitions topic-name nil))
  ([topic-name key]
   (let [topic-name (clojure.string/lower-case topic-name)
         replicas (or (get current-context :replicas) 1)
         partitions (or (get current-context :partitions) 1)]
     (if (or
           (nil? key)
           (clojure.string/blank? key))
       ;(str " WITH (kafka_topic='" topic-name "', value_format='AVRO') ")
       ;(str " WITH (kafka_topic='" topic-name "', key='" key "' , value_format='AVRO')")
       (str " WITH (kafka_topic='" topic-name "', value_format='AVRO',replicas=" replicas ", partitions=" partitions ") ")
       (str " WITH (kafka_topic='" topic-name "', key='" key "' , value_format='AVRO',replicas=" replicas ", partitions=" partitions ")"))
     )
    ))


(defn make-with-clause
  ([topic-name] (make-with-clause topic-name nil))
  ([topic-name key]
   (let [topic-name (clojure.string/lower-case topic-name)
         ;replicas (or (get current-context :replicas) 1)
         ;partitions (or (get current-context :partitions) 1)
         ]
     (if (or
           (nil? key)
           (clojure.string/blank? key))
       (str " WITH (kafka_topic='" topic-name "', value_format='AVRO' ) ")
       (str " WITH (kafka_topic='" topic-name "', key='" key "' , value_format='AVRO' )"))
     )
    ))


;(drop 2 [1 2 3])



#_(defn create-rekey-table-statement [source-entity-schema sink-name source-name source-key]

  (let [sink-name (clojure.string/upper-case sink-name)
        fields (get source-entity-schema :fields)
        ;    fields (into [] (drop 2 fields))
        fields-str (as-create-fields fields)]

    ;CREATE TABLE D_X WITH (KAFKA_TOPIC='D_REKEY', VALUE_FORMAT='AVRO', KEY='X');
    (str "CREATE TABLE " sink-name " " fields-str (make-with-clause-with-partitions source-name source-key) " ;")
    )
  )


(defn create-stream-statement
  ([sink-name fields source-name]
   (create-stream-statement sink-name fields source-name nil))
  ([sink-name fields source-name sink-key]
    ;(println "---------------" sink-name)
   (let [sink-name (clojure.string/upper-case sink-name)
         source-name (clojure.string/upper-case source-name)
         sink-key (when sink-key (clojure.string/upper-case sink-key))
         sql-column (as-create-fields fields)]
     (if sink-key
       (str "CREATE STREAM " sink-name " " sql-column " " (make-with-clause-with-partitions source-name sink-key) ";")
       (str "CREATE STREAM " sink-name " " sql-column " " (make-with-clause-with-partitions source-name) ";")))))


(defmethod p/gen-ksql p/gen-ksql-stream [stream-schema]
  (let [{:keys [name key fields]} stream-schema]
    ;(clojure.pprint/pprint stream-schema)
    [(create-stream-statement name fields name key)]))


(defmethod p/gen-ksql p/gen-ksql-stream-from-stream [stream-schema]
  ;(clojure.pprint/pprint stream-schema)
  (let [
        field-str (->> (get stream-schema :fields)
                       (map :name)
                       (clojure.string/join ", ")
                       )
        ;_ (println "--" field-str)
        source-stream (first (get stream-schema :source-name))
        sink-name (get stream-schema :sink-name)
        sink-key (get stream-schema :key)


        sql-str (str "CREATE STREAM " sink-name (make-with-clause sink-name) " AS  SELECT " field-str " FROM " source-stream)
        sql-str (if-let [where (get stream-schema :where)]
                  (let [w (ti/where-transformation where)]
                    (str sql-str " " w))
                  sql-str)
        sql-str (str sql-str " EMIT CHANGES;")

        ]
    ; (clojure.pprint/pprint stream-schema)
    [sql-str]))







(defmethod p/gen-ksql p/gen-ksql-stream-from-topic
  [m]
  ;(clojure.pprint/pprint m)
  (let [{:keys [name sink-name key fields]} m]
    (if (or (nil? key)
            (sequential? key))
      (list
        (create-stream-statement (or name sink-name)  fields (or name sink-name) ))

      (let [source-name (clojure.string/upper-case name)
            source-staging-name (clojure.string/upper-case (str source-name "_STAGING"))
            source-staging-rekey (clojure.string/upper-case (str source-name "_BY_" key))
            #_(clojure.string/upper-case (str source-name "_STAGING_REKEY"))
            sql-column (as-create-fields fields)
            source-key (clojure.string/upper-case key)]
        (list
          (str "CREATE STREAM " source-staging-name " " sql-column " " (make-with-clause-with-partitions source-name) ";")
          (str "CREATE STREAM " source-staging-rekey " " (make-with-clause-with-partitions source-staging-rekey) " AS SELECT * FROM " source-staging-name " PARTITION BY " source-key " ;")
          (str "CREATE TABLE " source-name " " sql-column (make-with-clause source-staging-rekey source-key) " ;"))))))



#_(ksql "CREATE TABLE net_policy_refined_by_local_policy_id AS
         SELECT local_policy_id, latest_by_offset(insurers_gross_policy_share) AS insurers_gross_policy_share,  latest_by_offset(underwriting_year) AS underwriting_year
         FROM net_policy_refined GROUP BY local_policy_id  EMIT CHANGES;")

;replicas


(defn get-sink-key [e-key-m sink-m]
  (let [sink-name (clojure.string/lower-case (get sink-m :sink-name))]
    (get e-key-m sink-name)))


#_(defn get-source-ref-key [m]
    ;(println "entity-key: " )
    ;(clojure.pprint/pprint e-key-m)
    ;(println "data: " m)
    (if-let [j (get m :join)]
      (into {} (comp (filter (fn [v] (clojure.string/includes? v "/")))
                     (map (fn [v] (clojure.string/split v #"/")))) j)
      {})
    )





(defn get-ref-source-name [m]
  ;(clojure.pprint/pprint m)
  (let [source-name (kutil/get-source-name-from-fields (:fields m))
        ;_ (println "--" source-name)
        source-name (if-let [w (or (get m :join) (get m :left_join))]
                      (let [[j-type f-source j-source] w #_(kutil/get-source-name-from-join w)
                            f-source-name (first (clojure.string/split f-source #"/"))
                            j-source-name (first (clojure.string/split j-source #"/"))]

                        ;(println "--join source name " w)
                     ;   (conj source-name w)
                        (conj (disj  source-name j-source-name) f-source-name) )
                      source-name)]
    ;(println "--" source-name)

    (if-let [w (->> source-name
                    (remove nil?)
                    (first)
                    )]
      (clojure.string/upper-case w)
      nil
      )
    ))


#_(defn get-source-type-m [mapping-schema]
  ;(clojure.pprint/pprint mapping-schema)
  (reduce-kv (fn [acc k v]
               ;(println "--" k "--" v)
               (let [n (str (clojure.string/lower-case k))
                     f (into [] (comp (map (fn [f]
                                             ;                             (println "--" f)
                                             {
                                              (clojure.string/lower-case (str n "/" (get f :name)))
                                              (clojure.string/lower-case (get-in f [:schema :type]))
                                              }
                                             ))) (get v :fields))

                     ]
                 (merge acc (into {} f))
                 )

               ) {} (get mapping-schema :source-schema)))


#_(defn map-source-schema [source-type-m fields]
  (into [] (map (fn [field]
                  (if (and (sequential? (get field :transfer_fn))
                           (= "as" (get-in field [:transfer_fn 0]))
                           )
                    (let [k (get-in field [:transfer_fn 1])
                          k (clojure.string/lower-case k)
                          t (get-in field [:schema :type])
                          ]
                      (assoc field :source-type (get source-type-m k))
                      ;field
                      )
                    field
                    )
                  )) fields))


#_(defn do-m-sort [schema mapping-schema]
    ;(clojure.pprint/pprint  (get schema :fields))
    (let [field-m (->> (mapv :name (get schema :fields))
                       (map (fn [index v]
                              {(clojure.string/lower-case v) index}
                              ) (range))
                       (into {}))
          ;_ (clojure.pprint/pprint field-m)
          fields (->> (get mapping-schema :fields)
                      (sort-by (fn [v]
                                 (get field-m (clojure.string/lower-case (get v :name)))
                                 ))
                      (into []))]
      ;    (clojure.pprint/pprint fields)
      ;(println "----------------")
      (assoc mapping-schema :fields fields)))


(defn get-partition-key [mapping-schema]
  (when-let [sink-key (get-in mapping-schema [:key])]
    (let [join (or (get mapping-schema :join)
                   (get mapping-schema :left_join)
                   )

            field-name (when-let [jk (nth join 1)]
                         (some-> (filter (fn [m]

                                           (clojure.string/includes? (pr-str m) jk)
                                           ) (get mapping-schema :fields))

                                 (first)
                                 (or {})
                                 (get :name "")
                                 (clojure.string/lower-case)
                                 )
                         )
            ]
        (when-not (= sink-key field-name)
          sink-key
          ;(str " PARTITION BY " (clojure.string/upper-case sink-key))
          )

        )

      )
    )



(defmethod p/gen-ksql p/gen-ksql-stream-from-mapping
  [mapping-schema]

  (let [sink-name (get mapping-schema :sink-name)


       ;   _ (clojure.pprint/pprint (get mapping-schema :key) )
        ;        source-type-m (get-source-type-m mapping-schema)

        partition-by (when-let [partition-key (get-partition-key mapping-schema)]
                       (str " PARTITION BY " (clojure.string/upper-case partition-key)))
        fields (get mapping-schema :fields)

        ;
        source-name (get-ref-source-name mapping-schema)
        ;_ (println "---source name " source-name)
        select-fields (do-fields-transformation-batch fields #_(get mapping-schema :fields))

        ;_ (println "--" select-fields)
        sql-str (str "SELECT " select-fields " FROM " source-name " " source-name)
        sql-str (if-let [join (or (get mapping-schema :join)
                                  (get mapping-schema :left_join)
                                  )]
                  (let [w (ti/join-transformation current-context (get mapping-schema :source-schema {}) join)]
                    ;(println "--" join)
                    (str sql-str " " w))
                  sql-str)
        sql-str (if-let [where (get mapping-schema :where)]
                  (let [w (ti/where-transformation where)]
                    (str sql-str " " w))
                  sql-str)]
    (if partition-by

      [(str "CREATE STREAM " (clojure.string/upper-case (str  sink-name "_stag")) " " (make-with-clause (str  sink-name "_stag")) " as " sql-str  ";")
       (str "CREATE STREAM " (clojure.string/upper-case sink-name) " " (make-with-clause sink-name) " as select * from " (clojure.string/upper-case (str  sink-name "_stag"))  " " partition-by ";")]
      [(str "CREATE STREAM " (clojure.string/upper-case sink-name) " " (make-with-clause sink-name) " as " sql-str ";")]
      )

    )
  )

(defmethod p/gen-ksql p/gen-ksql-stream-insert-from-mapping
  [mapping-schema]

  (let [sink-name (clojure.string/upper-case (get mapping-schema :sink-name))



        partition-by (when-let [partition-key (get-partition-key mapping-schema)]
                       (str " PARTITION BY " (clojure.string/upper-case partition-key)))
        #_(when-let [sink-key (get-in mapping-schema [:sink-schema :key])]
            (str " PARTITION BY " (clojure.string/upper-case sink-key))
            ;""
            )
        fields (get mapping-schema :fields)

        source-name (get-ref-source-name mapping-schema)
        ;_ (println "---source name " source-name)
        select-fields (do-fields-transformation-batch fields #_(get mapping-schema :fields))
        ;_ (println "--" select-fields)
        sql-str (str "SELECT " select-fields " FROM " source-name " " source-name)
        sql-str (if-let [join (or (get mapping-schema :join)
                                  (get mapping-schema :left_join)
                                  )]
                  (let [w (ti/join-transformation current-context (get mapping-schema :source-schema {}) join)]
                    (str sql-str " " w))
                  sql-str)
        sql-str (if-let [where (get mapping-schema :where)]
                  (let [w (ti/where-transformation where)]
                    (str sql-str " " w))
                  sql-str)
        ;sql-str (clojure.string/upper-case sql-str)
        ]

    (if partition-by
      [(str "INSERT INTO " (clojure.string/upper-case sink-name) " " sql-str " " partition-by ";")]
      [(str "INSERT INTO " (clojure.string/upper-case sink-name) " " sql-str ";")]
      )

    ))


#_(defn create-rekey-stream-statement [entity-schema sink-name source-name source-key]
  ;(println)
  (let []
    (str "CREATE STREAM " sink-name " " (make-with-clause-with-partitions sink-name) " AS SELECT * FROM " source-name " PARTITION BY " source-key " ;")))


(defmethod p/gen-ksql p/gen-ksql-rekey-stream-from-mapping [entity-schema]
  ;(clojure.pprint/pprint entity-schema)
  ;(println "------------" (get entity-schema :key))
  (let [sink-key (get entity-schema :key)
        sink-name (get entity-schema :sink-name)
        source-name (first (get entity-schema :source-name))

        fields (get entity-schema :fields)
        fields (into [] (drop 2 fields))
        fields-str (as-create-fields fields)
        ;_ (println fields-str)
        sink-name (clojure.string/upper-case sink-name)
        source-name (clojure.string/upper-case source-name)
        source-key (clojure.string/upper-case sink-key)]

    [
     ;(create-rekey-stream-statement entity-schema sink-name source-name sink-key)
     (str "CREATE STREAM " sink-name " " (make-with-clause sink-name) " AS SELECT * FROM " source-name " PARTITION BY " source-key " ;")
     ]

    ))




(defmethod p/gen-ksql p/gen-ksql-table-from-stream-after-rekey [table-schema]
  ;"Not implement yet"
  ;(clojure.pprint/pprint table-schema)
  (let [source-key (clojure.string/upper-case (get table-schema :key))
        sink-name (clojure.string/upper-case (get table-schema :sink-name))

       ; source-name (first (get table-schema :source-name))
        fields (get table-schema :fields)
        ;_ (clojure.pprint/pprint fields)
      ;  sql-column (as-create-fields fields)
        ;field-str
        #_(reduce (fn [acc k]
                    (if (= source-key (clojure.string/upper-case (get k :name)))
                      (conj acc source-key)
                      (conj acc (str "latest_by_offset(" (get k :name) " )" " AS " (get k :name)))
                      )

                    ) [] fields)
        ;source-staging-rekey (clojure.string/upper-case (str source-name "_BY_" source-key))
        ;  field-str (clojure.string/join ", " field-str)


        source-name (get-ref-source-name table-schema)
        ;_ (println "---source name " source-name)
        select-fields (do-fields-transformation-batch fields #_(get mapping-schema :fields))
        ;_ (println "--" select-fields)
        sql-str (str "SELECT " select-fields " FROM " source-name " " source-name)
        sql-str (if-let [join (or (get table-schema :join)
                                  (get table-schema :left_join)
                                  )]
                  (let [w (ti/join-transformation current-context (get table-schema :source-schema {}) join)]
                    (str sql-str " " w))
                  sql-str)
        sql-str (if-let [where (get table-schema :where)]
                  (let [w (ti/where-transformation where)]
                    (str sql-str " " w))
                  sql-str)

      ;  partition-by (str " PARTITION BY " (clojure.string/upper-case source-key))
        table-fields-v (into [] (comp
                            (remove (fn [field]
                                      ;(println "--" source-key "--" (get field :name))
                                      (= (clojure.string/lower-case source-key) (clojure.string/lower-case (get field :name))  )
                                      ))
                            (map (fn [field]
                                        (str "latest_by_offset ( " (get field :name) " ) as " (get field :name) )
                                        )) )  fields)
        table-fields-v (clojure.string/join "," table-fields-v)
        table-fields-v (str source-key ", " table-fields-v)
        ]

  ;  (clojure.pprint/pprint table-fields-v )
    (vector

      ;[(str "CREATE STREAM " (clojure.string/upper-case sink-name) " " (make-with-clause sink-name ) " as " sql-str " " partition-by ";")]
      (str "CREATE STREAM " (str sink-name "_STAG") " " (make-with-clause (str sink-name "_STAG") ) " AS " sql-str " "  " ;")

      (str "CREATE TABLE " sink-name " " (make-with-clause sink-name ) " as select " table-fields-v " from " (str sink-name "_STAG") " GROUP BY " source-key "  ;")
      )
    #_(vector
        (str "CREATE TABLE " sink-name " AS  SELECT " field-str " FROM " source-name " GROUP BY " pk " EMIT CHANGES;")
        )

    )

  )



#_(ksql "CREATE TABLE net_policy_refined_by_local_policy_id AS
         SELECT local_policy_id, latest_by_offset(insurers_gross_policy_share) AS insurers_gross_policy_share,  latest_by_offset(underwriting_year) AS underwriting_year
         FROM net_policy_refined GROUP BY local_policy_id  EMIT CHANGES;")


#_(defmethod p/gen-ksql p/gen-ksql-table-from-stream [table-schema]
  ;"Not implement yet"
  ;(clojure.pprint/pprint table-schema)
  (let [source-key (clojure.string/upper-case (get table-schema :key))
        sink-name (get table-schema :sink-name)

        source-name (first (get table-schema :source-name))
        fields (get table-schema :fields)
        ;_ (clojure.pprint/pprint fields)
        sql-column (as-create-fields fields)

        ]

    (vector

      ;[(str "CREATE STREAM " (clojure.string/upper-case sink-name) " " (make-with-clause sink-name ) " as " sql-str " " partition-by ";")]

      ;(str "CREATE TABLE " source-name " " sql-column (make-with-clause source-staging-rekey source-key) " ;")

      (str "CREATE TABLE " sink-name " " sql-column (make-with-clause-with-partitions source-name source-key) " ;")
      )
    #_(vector
        (str "CREATE TABLE " sink-name " AS  SELECT " field-str " FROM " source-name " GROUP BY " pk " EMIT CHANGES;")
        )

    ))







(defn as-select-fields [coll]
  (->> coll
       (mapv (fn [m]
               (let [n (get m :name)
                     alias (or (get m :aliases) n)
                     t (get-in m [:schema :type])]
                 (str " CAST ( " alias " AS " t " ) AS " n ""))))
       (clojure.string/join ",")
       (clojure.string/upper-case)))

(comment

  (as-select-fields (list {:name "name", :schema {:type "STRING"} :aliases "este"}
                          {:name "surname", :schema {:type "STRING"}}
                          {:name "gender", :schema {:type "STRING"}}))

  )


(defn stream-rekey [{:keys [topic key fields from-topic type]}]
  (if from-topic
    (if (= type "TABLE")
      (let [sql-column (as-create-fields fields)]
        (str "CREATE TABLE " topic " " sql-column " WITH (kafka_topic='" from-topic "', value_format='AVRO',KEY='" (clojure.string/upper-case key) "');"))
      (let [sql-colum (as-select-fields fields)]
        (str "CREATE STREAM " topic " AS SELECT " sql-colum " FROM " from-topic " PARTITION BY " (clojure.string/upper-case key) ";")))
    (let [sql-column (as-create-fields fields)]
      (str "CREATE STREAM " topic " " sql-column " WITH (kafka_topic='" topic "', value_format='AVRO');"))))


#_(defn as-ksql-schema [coll]
  (into [] (comp (map stream-rekey)
                 ) coll))


#_(defn topic-to-table [key topic-name]
  (let [stream-name (clojure.string/upper-case topic-name)
        stream-in (str stream-name "_IN")
        stream-rekey-name (str stream-name "_RE")
        table-name (str stream-name "_TB")
        key (clojure.string/upper-case key)]
    (vector
      (str "CREATE STREAM " stream-in "  WITH (kafka_topic='" topic-name "', value_format='AVRO');")
      (str "CREATE STREAM " stream-rekey-name " AS SELECT * FROM " stream-in " PARTITION BY " key ";")
      (str "CREATE TABLE " table-name "  WITH (kafka_topic='" stream-rekey-name "', value_format='AVRO', KEY='" key "');"))))



#_(defn topic-source-name-ksql [sql-str]
  (if-let [w (second (clojure.string/split sql-str #"KAFKA_TOPIC"))]
    (some-> (clojure.string/split w #",")
            (first)
            (clojure.string/split #"=")
            (second)
            (clojure.string/trim)
            (clojure.string/replace #"'" ""))
    (some-> (clojure.string/split sql-str #"kafka_topic")
            (second)
            (clojure.string/split #",")
            (first)
            (clojure.string/split #"=")
            (second)
            (clojure.string/trim)
            (clojure.string/replace #"'" ""))))

#_(defn topic-source-name-ksql-batch [sql-coll]
  (into #{} (comp (map topic-source-name-ksql) (remove nil?)) sql-coll))



