(ns kotr.pipeline.gen.emitter.ksql
  (:require [kotr.pipeline.gen.emitter.ksql.core :as kc]
            [clojure.tools.logging :as log]
            [kotr.pipeline.gen.protocol :as p]))


#_(defn make-order [coll]
    (->> coll
         (sort-by (fn [m]
                    (if (clojure.string/starts-with? m "CREATE")
                      0 1)))
         (distinct)
         (into [])))


#_(defn emit-ksql-batch-for-topic
    [context schema-coll]
    (binding [kc/current-context context]
      (let [xf (comp (map (fn [m]
                            (assoc m :type "TOPIC")))
                     (map p/gen-ksql)
                     cat
                     )]
        (->> schema-coll
             (into [] xf)
             (make-order)))))


#_(defn get-default-key-name [keys]
  ;(println "keys " keys)
  (let [partition-key (cond
                        (nil? keys) "P_ROWID"

                        (sequential? keys) "P_ROWID"
                        (clojure.string/blank? keys) "P_ROWID"
                        :else
                        keys)]
    (clojure.string/upper-case partition-key)))




#_(defn assoc-pk-key [fields source-name keys]
  (let [source-name (clojure.string/upper-case source-name)
        r-fields (first fields)

        partition-key (get-default-key-name keys)
        ;_ (println "--" partition-key)
        ffield (cond
                 (or (nil? keys) (empty? keys))
                 (let [keys-list (rest (mapv :name fields))
                       w (into ["hash"] (comp (map (fn [m]
                                                     (str source-name "/" m)
                                                     ))) keys-list)
                       pk {:name        partition-key
                           :schema      {:type "string"}
                           :transfer_fn w}]
                   pk
                   ;(assoc r-fields :transfer_fn w #_["as" (str source-name "/" "ROWTIME")])
                   )

                 (sequential? keys)
                 (let [w (into ["gen_id"] (comp (map (fn [m]
                                                       (str source-name "/" m)
                                                       ))) keys)]
                   (assoc r-fields :transfer_fn w))
                 :else
                 (assoc r-fields :transfer_fn ["as" (str source-name "/" (clojure.string/upper-case (get r-fields :name)))])

                 )

        f (into [] (comp
                     (map (fn [f] (update f :name clojure.string/upper-case)))
                     (map (fn [f]
                            (assoc f :transfer_fn ["as" (str source-name "/" (get f :name))])
                            ))) (rest fields))
        fields (if ffield
                 (into [ffield] f)
                 f)]
    ;(println "--" fields)
    fields
    ))


#_(defn create-insert-statement [sink-name fields source-name source-key]
  ;(println fields)
  (let [sink-name (clojure.string/upper-case sink-name)
        source-name (clojure.string/upper-case source-name)

        partition-key (get-default-key-name source-key)

        ;_ (println "--fields " fields)
        ;   _ (clojure.pprint/pprint fields)
        fields (assoc-pk-key fields source-name source-key)
        fields (kc/do-fields-transformation-batch fields)
        ;  _ (println "---------------" fields)
        f (str "SELECT " fields " FROM " source-name " " source-name)

        f (str f " PARTITION BY " partition-key)]
    (str "INSERT INTO " sink-name " " f)))


#_(defn emit-ksql-for-rekey
  [context m]
  ;(clojure.pprint/pprint m)
  (binding [kc/current-context context]
    (let [{:keys [sink-name source-key fields source-name sink-key]} m
          ;    m (assoc m :type p/gen-ksql-rekey-stream-from-mapping)
          ]
      ;(p/gen-ksql m)
      (list
        (kc/create-stream-statement sink-name fields sink-name sink-key)
        (create-insert-statement sink-name fields source-name source-key)))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(defn emit-ksql-batch [context new-schema-coll]
  (binding [kc/current-context context]
    (->> (into [] (comp (map p/gen-ksql) cat) new-schema-coll)
         (sort-by (fn [m]
                    (if (clojure.string/starts-with? m "CREATE")
                      0 1)))
         (distinct)
         (into [])
         #_(make-order))))



(defn emit-ksql-for-drop [quiries-id stream-m]
  (let [out (into [] (map (fn [v]
                            (str "TERMINATE " v "; ")
                            )) quiries-id)
        out (into out (map (fn [v]
                             (str "DROP TABLE IF EXISTS " v "  ; ")
                             )) (get stream-m "TABLE"))
        out (into out (map (fn [v]
                             (str "DROP STREAM IF EXISTS " v "  ; ")
                             )) (get stream-m "STREAM"))

        ]
    out
    )

  )
