(ns kotr.pipeline.gen.core
  (:require [kotr.pipeline.gen.macro-expand-join :as mc2]
            [kotr.pipeline.gen.macro-expand]
            [kotr.pipeline.gen.protocol :as p]
            [kotr.pipeline.gen.util :as u]
            [kotr.pipeline.gen.schema-gen :as sg]
            [clojure.tools.reader.edn :as edn]))



#_(defn create-mapping-name [schema-m]
    (let [sink-name (get schema-m :sink-name)
          source-name (get schema-m :source-name)
          mapping-name (if (clojure.string/includes? sink-name "step")
                         (str sink-name "-mapping")
                         (str (clojure.string/lower-case sink-name)
                              "-"
                              (->> source-name
                                   (clojure.string/join "-")
                                   (clojure.string/lower-case))
                              "-mapping"))]
      (assoc schema-m :name mapping-name)))






(defn log [v]

  (clojure.pprint/pprint v)
  v)








(defn do-m-sort [schema mapping-schema]
  ;(clojure.pprint/pprint  (get schema :fields))
  (let [field-m (->> (mapv :name (get schema :fields))
                     (map (fn [index v]
                            {(clojure.string/lower-case v) index}
                            ) (range))
                     (into {}))
        ;_ (clojure.pprint/pprint field-m)
        fields (->> (get mapping-schema :fields)
                    (sort-by (fn [v]
                               (get field-m (clojure.string/lower-case (get v :name)))
                               ))
                    (into []))]
    ;    (clojure.pprint/pprint fields)
    ;(println "----------------")
    (assoc mapping-schema :fields fields)))



#_(defn get-new-schema-coll [schema-m mapping-coll]
    (let [schema-set (into #{} (keys schema-m))
          xf (comp (map (fn [v] (first v)))
                   (remove (fn [m] (contains? schema-set (clojure.string/lower-case (get m :sink-name)))))
                   #_(map (fn [m]
                            {(clojure.string/upper-case (get m :sink-name)) m})))]
      (->> mapping-coll
           (into [] (remove (fn [m] (get m :mapping-schema))))
           (group-by :sink-name)
           (vals)
           (into [] xf))))


#_(defn get-mapping-schema [schema-m mapping-coll]
    (let [xf (comp
               (filter :mapping-schema)
               (map (fn [mapping-schema]
                      (let [schema (get schema-m (clojure.string/lower-case (get mapping-schema :sink-name)))]
                        (do-m-sort schema mapping-schema)))))]
      (into [] xf mapping-coll)))


(defn- update-rekey-referance [mapping-schema rekey-schema]
  (let [new-source (get rekey-schema :sink-name)
        old-source (first (get rekey-schema :source-name))
        mapping-schema (if (get mapping-schema :source-name)
                         (update-in mapping-schema [:source-name] (fn [v]
                                                                    (mapv (fn [n]
                                                                            (if (= (clojure.string/lower-case n)
                                                                                   (clojure.string/lower-case old-source))
                                                                              new-source
                                                                              n)) v)))
                         mapping-schema)
        s-name (str (clojure.string/lower-case old-source) "/")
        n-name (str (clojure.string/lower-case new-source) "/")]
    (-> (pr-str mapping-schema)
        (clojure.string/replace s-name n-name)
        (edn/read-string))))


(defn- create-rekey-join-schema [schema-m mapping-schema]
  (when-let [j (or (get mapping-schema :join)
                   (get mapping-schema :left_join))]
    (let [[j-entity-name j-entity-col-name :as w] (mapv clojure.string/lower-case (clojure.string/split (nth j 2) #"/"))
          new-source-entity (get schema-m j-entity-name)
          new-source-entity-name (clojure.string/lower-case (str j-entity-name "_BY_" j-entity-col-name))]
      (when (not= (get new-source-entity :key)
                  j-entity-col-name)
        (assoc new-source-entity :name new-source-entity-name
                                 :ksql-gen-type p/gen-ksql-rekey-stream-from-mapping
                                 :rekey true
                                 :sink-name new-source-entity-name
                                 :source-name [j-entity-name]
                                 :key j-entity-col-name)))))


(defn rekey-source-one [schema-m mapping-schema]
  ;  (println "------------------")
  ;  (clojure.pprint/pprint mapping-schema)
  ;  (println "----------------")
  (if-let [rekey-entity-schema (create-rekey-join-schema schema-m mapping-schema)]
    (let [w (update-rekey-referance mapping-schema rekey-entity-schema)]
      [w rekey-entity-schema])
    [mapping-schema]))



(defn merge-schema [old-schema-m mapping-list]
  (reduce (fn [acc v]
            ; (clojure.pprint/pprint v)
            (let [sink-name (clojure.string/lower-case (get v :sink-name))]
              (if (contains? acc sink-name)
                acc
                (assoc acc sink-name v)))
            ) old-schema-m mapping-list))





(defn remove-duplicate-schema [schema-m mapping-coll]
  ;(println "----------------")

  (let [xf (comp (map (fn [[k v]]
                        ;; server schema has topic name
                        (when (not (:topic v))
                          k
                          )
                        ))
                 (remove nil?)
                 )
        w (into #{} xf schema-m)
        ;     _ (println "--" w)
        m-coll (remove :generator-type mapping-coll)
        r (into []
                (comp
                  (filter :generator-type)
                  (remove (fn [v]

                            ;   (clojure.pprint/pprint (dissoc v :fields :source-schema :sink-schema))
                            (contains? w (clojure.string/lower-case (get v :sink-name)))
                            ))
                  )
                mapping-coll)
        ]
    (into r m-coll)
    )

  )




(defn expand-macro-impl [schema-m mapping]
  (let [mapping mapping #_(sort-by (fn [v]
                                     (let [v (first (get-in v [:transfer_fn] []))]
                                       (if v
                                         (get p/expand-macro-order (clojure.string/lower-case v) 0)
                                         0))
                                     ) mapping)]
    (loop [[f & r] mapping
           result []]
      (if (nil? f)
        result
        (let [w (p/expand-macro schema-m result f)
              field-name-set (into #{} (comp (map :field_name)
                                             (remove nil?)
                                             (remove clojure.string/blank?)
                                             ) w)
              result (into [] (remove (fn [v]
                                        ;     (println "--" v)
                                        (contains? field-name-set (get v :field_name))) result))
              out (into result w)]
          (recur r out))))))

(defn get-source-name-from-fields [transfer_fn]
  (->> transfer_fn
       rest
       (filter (fn [v]
                 (clojure.string/includes? v "/")))
       (remove (fn [v]
                 (clojure.string/starts-with? v "'")))
       (flatten)
       (first)))

(comment

  (get-source-name-from-fields ["as" "'ref_mapping2/id'"])

  )



(defn add-source-type-batch [schema-m mapping]
  (let [schema-m (reduce-kv (fn [acc k v]
                              (merge acc (into {} (map (fn [m]
                                                         {(str k "/" (get m :name)) (get-in m [:schema :type])}
                                                         )) (get v :fields)))
                              ) {} schema-m)]
    (into [] (map (fn [m]
                    (if (and (get m :field_name)
                             #_(nil? (get m :type)))
                      (let [

                            s-name (get-source-name-from-fields (get m :transfer_fn))
                            ;                  _ (println "--" s-name "--" (get schema-m s-name))
                            st (when-let [v (get schema-m s-name)]
                                 (clojure.string/lower-case v)

                                 )
                            sink-type (or (get m :type) st "string")
                            ]
                        ; (println "-- type " st)
                        (assoc m :type sink-type :source-type st))
                      m
                      )

                    )) mapping)
    ))



(defn get-key [schema-m source-names current-mapping]
  (if (get current-mapping :key)
    (get current-mapping :key)
    ;(assoc current-mapping :partition-key (get current-mapping :key) )
    (let [source-entity-name (first source-names)
          _ (println "--" source-entity-name)
          source-schema-key (get-in schema-m [source-entity-name :key])
          source-schema-key (if (clojure.string/blank? source-schema-key)
                              nil
                              source-schema-key
                              )
          ; _ (println "--" source-schema-key)
          k (get-in current-mapping [:fields 0 :name])]
      source-schema-key
      #_(assoc current-mapping :key source-schema-key #_(or k))
      )
    ))


(defn process-one [schema-m current-mapping]

  (let [current-mapping (sg/as-mapping-schema current-mapping)]
    ;(clojure.pprint/pprint current-mapping)
    (if (empty? (u/get-source-name2 (get current-mapping :fields)))
      (let [m (assoc current-mapping :ksql-gen-type p/gen-ksql-stream-from-topic)
            m (assoc m :source-name [(get m :sink-name)])]
        [m])
      (let [[current-mapping rekey-mapping] (rekey-source-one schema-m current-mapping)
            schema-m (if rekey-mapping
                       (merge-schema schema-m [rekey-mapping])
                       schema-m)
            source-names (u/get-source-name2 (get current-mapping :fields))
            source-schema (select-keys schema-m source-names)

            current-mapping (assoc current-mapping :source-schema source-schema :source-name source-names)

            current-mapping (if (= "table" (get current-mapping :type))

                              (assoc current-mapping :ksql-gen-type p/gen-ksql-table-from-stream-after-rekey)

                              (let [sink-schema (get schema-m (clojure.string/lower-case (get current-mapping :sink-name)))
                                    previous-source-name (u/get-source-entity-name-from-sink-schema (get current-mapping :source-name) sink-schema)]
                                (if (and
                                      sink-schema
                                      (not= (get current-mapping :source-name)
                                            previous-source-name))
                                  (let []
                                    (-> (do-m-sort sink-schema current-mapping)
                                        (assoc :sink-schema sink-schema
                                               :sink-key (get sink-schema :key)
                                               :ksql-gen-type p/gen-ksql-stream-insert-from-mapping)))
                                  (assoc current-mapping :ksql-gen-type p/gen-ksql-stream-from-mapping))))]
        (if rekey-mapping
          [rekey-mapping current-mapping]
          [current-mapping])))))



(defn do-post-valiedataion [schema-m]
  (when (and (= (get schema-m :type) "table")
             (nil? (get schema-m :key))
             )
    (throw (ex-info (p/msg :500) (select-keys schema-m [:sink-name :key])))))




(defn replace-this-macro [field-m field]
  ;(println "" field-m)
  (let [

        field (if (= "as" (first field))
                (second field)
                field
                )]
    (clojure.walk/postwalk (fn [v]
                             (if (and (u/is-namespace? v)
                                      (clojure.string/includes? v "this/")
                                      )  #_(and (string? v)

                                                )
                               (let [[_ fields-name] (clojure.string/split v #"/")

                                     v (get field-m fields-name)
                                     ]
                                 ;    (println "--" v fields-name )
                                 (when (nil? v)
                                   (throw (ex-info (get p/msg :100) field))
                                   )
                                 v

                                 )
                               v
                               )
                             ) field)
    )

  ;field
  )

(defn expand-this-macro [mapping]
  (let []
    ;(clojure.pprint/pprint m)
    (loop [[field & mapping] mapping
           out []]
      (if (nil? field)
        out
        (let [trans (get field :transfer_fn)
              new-trans (if (clojure.string/includes? (pr-str trans) "this/")
                          (let [m (into {} (comp (map (juxt :field_name :transfer_fn) #_(fn [v] (println v) [(second v) (nth 2 v)]))
                                                 (remove (fn [[v n]] (nil? v)))
                                                 ) out)]
                            ;(println "this exit")
                            (replace-this-macro m trans)
                            )
                          trans

                          )
              new-field (assoc field :transfer_fn new-trans)

              ]
          (recur mapping (conj out new-field))
          )
        )
      )
    )

  ;mapping
  )


(defn do-compile-one [curremt-schema-m mapping]

  ;(clojure.pprint/pprint mapping)
  (let [

        mapping (expand-macro-impl curremt-schema-m mapping)
  ;      _ (clojure.pprint/pprint mapping)
        mapping (expand-this-macro mapping)


        mapping (add-source-type-batch curremt-schema-m mapping)

        mapping-coll (mc2/join-expand mapping)

        ]
    ;(clojure.pprint/pprint mapping-coll)
    (loop [[current-mapping & mapping-coll] mapping-coll
           schema-m curremt-schema-m
           out []]
      (if (nil? current-mapping)
        (let [out (remove-duplicate-schema curremt-schema-m out)]
          ;(clojure.pprint/pprint (mapv (fn [v] (dissoc v :fields :source-schema :sink-schema) ) out ) )
          out
          )

        (let [v (process-one schema-m current-mapping)
              _ (run! do-post-valiedataion v)
              schema-m (merge-schema schema-m v)]
          (recur mapping-coll schema-m (into out v)))))))





(defn do-compile-batch [server-schema-m mapping-coll]
;  (clojure.pprint/pprint mapping-coll)
  (loop [[mapping & r] mapping-coll
         schema-m server-schema-m
         result []]
    (if (nil? mapping)
      (do
        result)
      (let [mapping-list (do-compile-one schema-m mapping)
            ;w (remove (fn [v] (= "MAPPING" (get v :type)) ) mapping-list  )
            schema-m (merge-schema schema-m mapping-list)
            result (into result mapping-list)]
        (recur r schema-m result)))))









(comment




  (compile-mapping-one
    (list {:name        "tnf_policy",
           :field_name  "policy_number",
           :transfer_fn ["as"                               ;"id3_poltblp_policy/B4DOCD_Policy_Number"
                         "id3_zvspolp_policy/FBFNCU_Policy_Id"],
           :doc         "",
           :type        "String"}

          {:name        "tnf_policy",
           :field_name  "issue_state",
           :transfer_fn ["as" "id3_zvspolp_policy/FBFPCU_State_Id"],
           :doc         "",
           :type        "String"}

          {:name       "tnf_policy",
           :field_name "",
           :transfer_fn
                       ["join"
                        "id3_zvspolp_policy/FBFNCU_Policy_Id"
                        "id3_poltblp_policy/B4DOCD_Policy_Number"
                        ],
           :doc        "",
           :type       ""}
          {:name       "tnf_policy",
           :field_name "product_id",
           :transfer_fn
                       ["lookup"
                        "tnf_product/Product_Code"
                        ["="
                         "id3_zvspolp_policy/FBFVCU_Plan_Code"
                         "tnf_product/Product_Code"
                         ]],
           :doc        "",
           :type       "String"})

    )

  )
;join-entity-name



;(disj #{1 2 3} 1)