(ns kotr.pipeline.gen
  (:require [kotr.pipeline.gen.core :as mc]
            [kotr.kafka.client :as client]
            [kotr.pipeline.gen.protocol :as p]
          ;  [kotr.pipeline.file-util :as fio]
            [kotr.pipeline.gen.reader.csv-data-reader :as r]
            [kotr.pipeline.gen.reader.csv-mapping-reader :as cdr]
            [kotr.pipeline.gen.emitter.ksql :as eksql]
            ))


(defn get-delta-ksql-statement [context ksql-coll]
  (let [stream-name-coll (->> (client/invoke context {:op "show-streams"})
                              (into #{} (comp (map :name))))
        table-name-coll (->> (client/invoke context {:op "show-tables-name"})
                             (into #{} #_(comp (map :name))))
        stream-name-coll (into stream-name-coll table-name-coll)
        ;  _ (println stream-name-coll)
        kafka-insert-query (->>                             ;(ksql/show-queries)
                             (client/invoke context {:op "show-queries"})
                             (into #{} (comp (map :queryString)
                                             (remove nil?)
                                             (filter (fn [v]
                                                       ;   (println "-----------" v)
                                                       (clojure.string/starts-with? v "INSERT")))
                                             (map (fn [v] (clojure.string/upper-case v))))))
        xf (comp (remove (fn [v]
                           (let [w (clojure.string/split v #" ")]
                             (if (and (= (first w) "CREATE")
                                      (contains? stream-name-coll (nth w 2)))
                               true false))))
                 (remove (fn [v]
                           (contains? kafka-insert-query (clojure.string/upper-case (str v ";"))))))]
    (into [] xf ksql-coll)))


(defn create-dataflow-req
  ([context mapping] (create-dataflow-req context mapping {}))
  ([context mapping schema-m]
   (->> (cdr/read-req mapping)
        (mc/do-compile-batch schema-m)
        ; (p/log-v)
        (eksql/emit-ksql-batch context))))



(defn get-delete-queries [select-schema]
  (let [

        ; stream-names (into [] xf (gen-dataflow-req v))

        queries-id (->> (vals select-schema)
                        (into [] (comp (map (fn [v]
                                              ; (clojure.pprint/pprint v)
                                              (into (get v :readQueries) (get v :writeQueries))
                                              ))
                                       cat
                                       (map :id)))
                        (distinct)
                        (into [])
                        )
        topics-name (->> (vals select-schema)
                         (into [] (map :topic))
                         (distinct)
                         (into [])
                         )
        stream-m (->> (vals select-schema)
                      (into [] (map (juxt :type :name)))
                      (group-by first)
                      (reduce-kv (fn [acc k v]
                                   (assoc acc k (distinct (mapv second v)))
                                   ) {}))
        ;out (assoc stream-m :topic )

        ]
    [queries-id stream-m topics-name]
    ;(clojure.pprint/pprint stream-m)
    ;(clojure.pprint/pprint topics-name)
    ;(clojure.pprint/pprint queries-id)

    #_(->> (gen-dataflow-req v)
           (into [] xf)
           ;(print-log)
           (kr/drop-stream-with-topic-req-batch context)
           (client/ksql-batch context)

           ))
  )


(defn delete-dataflow-req [context mapping schema-m]
  (let [out (create-dataflow-req context mapping schema-m)
      ;  _ (clojure.pprint/pprint out )
        xf (comp
             #_(filter (fn [v]
                       (clojure.string/starts-with? v "CREATE")))
             (map (fn [v] (-> (clojure.string/split v #" ")
                              (nth 2))))
             (remove nil?)
             (map clojure.string/lower-case))
        stream-names (into [] xf out)
        w (select-keys schema-m stream-names)
        [q-list stream-m-list topics-name :as out] (get-delete-queries w)

        ksql (eksql/emit-ksql-for-drop q-list stream-m-list)]
    ksql))



(defn delete-dataflow-req-with-data [context mapping schema-m]
  (let [out (create-dataflow-req context mapping schema-m)
        ;      _ (println "--" out)
        xf (comp
             #_(filter (fn [v]
                         (clojure.string/starts-with? v "CREATE")))
             (map (fn [v] (-> (clojure.string/split v #" ")
                              (nth 2))))
             (remove nil?)
             (map clojure.string/lower-case)
             )


        stream-names (into [] xf out)
        ;_ (println "-stream name " stream-names)
        w (select-keys schema-m stream-names)
        ;  _ (println "--" stream-names)
        ;_ (clojure.pprint/pprint w)
        [q-list stream-m-list topics-name :as out] (get-delete-queries w)

        ksql (eksql/emit-ksql-for-drop q-list stream-m-list)

        topic-req (into [] (map (fn [v]
                                  {:topic-name v}
                                  )) topics-name)
        schema-names (into [] (map (fn [v]
                                     (str v "-value")
                                     )) topics-name)
        ]
    {:ksql ksql :topic topic-req :schema schema-names}))


;;;;;;;;;;;;;;






#_(defn create-dataflow-req-by-file-name [context  source-mapping]
  (->> source-mapping
       (into [] (comp
                  (map first)
                  (map (fn [v]
                         (assoc {}
                           :name (r/get-file-name v)
                           :ksql-gen-type p/gen-ksql-stream-from-topic
                           :fields (->> (r/read-csv-header v)
                                        (mapv (fn [v]
                                                {:name v, :schema {:type "string"}}))))))))
       (eksql/emit-ksql-batch context)))



#_(defn delete-dataflow-req-by-source-mapping [context base-dir schema-m connector-mapping]
  ;(clojure.pprint/pprint req-coll)
  (let [req-coll (conn/as-source-connector-schema base-dir connector-mapping)
        ksql-coll (->> (into [] (comp
                                  (map assoc-field-schema)
                                  (map (fn [m]
                                         (assoc m :ksql-gen-type p/gen-ksql-stream-from-topic)))
                                  ) req-coll)
                       (eksql/emit-ksql-batch context)
                       ;                (client/get-delta-ksql-statement context)
                       )
        xf (comp
             (filter (fn [v]
                       (clojure.string/starts-with? v "CREATE")))
             (map (fn [v] (-> (clojure.string/split v #" ")
                              (nth 2))))
             (remove nil?)
             (map clojure.string/upper-case)
             )


        stream-names (into [] xf ksql-coll)
        ;  schema-m (client/get-server-schema context)
        w (select-keys schema-m stream-names)
        ;  _ (println "--" stream-names)
        ;   _ (clojure.pprint/pprint w)
        [q-list stream-m-list topics-name :as out] (get-delete-queries w)
        ;    _ (clojure.pprint/pprint out)
        ksql (eksql/emit-ksql-for-drop q-list stream-m-list)

        topic-req (into [] (map (fn [v]
                                  {:topic-name v}
                                  )) topics-name)
        ]
    ksql
    ;(client/ksql-batch context ksql)
    ;ksql-coll
    #_(when-not (empty? ksql-coll)
        (client/ksql-batch context ksql-coll))))












