(ns kotr.pipeline.connector
  (:require [cheshire.core :as json]
            [kotr.pipeline.gen.protocol :as p]
            [kotr.pipeline.connector.core :as c]
            [kotr.pipeline.gen.emitter.ksql :as eksql]
            [kotr.kafka.client :as client]
            [kotr.meta-data-repo :as md]
            [kotr.pipeline.connector.config-generator]
            [kotr.pipeline.gen.reader.csv-data-reader :as r]
            [kotr.pipeline.gen.file-util :as fio]))



;;;@todo this need to be override with file-path-extension using csv or json or anything else
(defn assoc-field-schema [e]
  (let [config (get e :connector)
        file-path (get e :file-path)
        fields (->> (r/read-header config file-path)
                    (mapv (fn [v]
                            {:name v, :schema {:type "string"}})))
        ]
    (assoc e :fields fields)))





(defn create-source-connector-req [ base-dir connector-mapping]
  (let [xf (comp
             (map assoc-field-schema)
             (map p/emit-connector ))]
    (->> (c/as-source-connector-schema base-dir connector-mapping)
         (into [] xf ))))


(comment

  (->>    (create-source-connector-req "app/azben/" [    ["mapping/config/csv_source.json" "data/source/raw_bnl_claim.csv"]])

          )

  )



(defn get-source-connector-names [ base-dir connector-mapping]
  (let [req-coll (c/as-source-connector-schema base-dir connector-mapping)]
    (into [] (comp
               ;(map (fn [m] (if schema-enable (assoc-file-schema m) m) ))
               (map p/emit-connector #_(fn [m]
                                         (p/emit-connector (get m :connector)
                                                           (get m :connector_source)
                                                           m)))
               (map :name)
               ) req-coll)
    )

  )



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;Sink connector ;;;;;;;;;;;;;;;;;;;;;;;;




(defn find-delta-connection [context connector-coll]
  (let [remote-conn-set (into #{} (map :name) (client/invoke context {:op "show-connectors-status"}))]
    (remove (fn [v] (contains? remote-conn-set (:name v))) connector-coll)))







(defn convert-schema-to-rekey-schema [topic-schema sink-schema]
  (let [fields (get topic-schema :fields)
        source-name (get topic-schema :name)
        fields (mapv (fn [f]
                       (assoc f :transfer_fn ["as" (str source-name "/" (get f :name))])
                       ) fields)
        keys (get sink-schema :key)


        ffield (cond
                 (or (nil? keys) (empty? keys))
                 (let [tf (into ["hash"] (comp (map (fn [m]
                                                      ["cast" (str source-name "/" (get m :name)) " string"]
                                                      ))) fields)]
                   {:name        "P_ROWID"
                    :schema      {:type "string"}
                    :transfer_fn tf})

                 (sequential? keys)
                 (let [tf (into ["gen_id"] (comp (map (fn [m]
                                                        (str source-name "/" m)
                                                        ))) keys)
                       v (clojure.string/join "_" keys)]
                   {:name        v
                    :schema      {:type "string"}
                    :transfer_fn tf})
                 :else
                 {})

        f-name (get ffield :name keys)
        new-name (clojure.string/lower-case (str (get topic-schema :name) "_by_" f-name))

        fields (into [ffield] fields)]
    (assoc topic-schema :fields fields
                        :key f-name
                        :sink-name new-name
                        :ksql-gen-type p/gen-ksql-stream-from-mapping
                        :source-name [(get topic-schema :name)])))


(defn apply-rekey? [schema-m sink-schema-m]
  (if (and (= "io.confluent.connect.jdbc.JdbcSinkConnector"
              (get-in sink-schema-m [:template :config :connector.class]))
           (not= (get sink-schema-m :key)
                 (get-in schema-m [(get sink-schema-m :entity_name) :key]))
           )
    true
    false

    )
  )



(defn update-sink-connector-mapping [context  connector-mapping-coll]
  (let [schema-m (md/get-kafka-schema context)]
    (loop [[m & connector-mapping-coll] connector-mapping-coll
           connector-schema-coll []
           stream-schema-coll []]
      (if (nil? m)
        [connector-schema-coll stream-schema-coll]
        (let [ ;[m] (conn/as-sink-connector-schema base-dir [connector-connector])
              [connector-schema-temp stream-schema-temp] (if (apply-rekey? schema-m m)
                                                           (let [topic-schema-m (get-in schema-m [(get m :entity_name)])
                                                                 s (convert-schema-to-rekey-schema topic-schema-m m)
                                                                 sink-connector (-> (assoc m :entity_name (get s :sink-name))
                                                                                    (assoc :key (get s :key))
                                                                                    )]
                                                             [sink-connector s])
                                                           [m]
                                                           )
              connector-schema-coll (conj connector-schema-coll connector-schema-temp)
              stream-schema-coll (if stream-schema-temp (conj stream-schema-coll stream-schema-temp) stream-schema-coll)]
          (recur connector-mapping-coll connector-schema-coll stream-schema-coll))))))




(defn create-sink-connector

  [context base-dir sink-connector-mapping]
  (let [sink-connector-mapping (c/as-sink-connector-schema base-dir sink-connector-mapping )
        [connector-schema stream-schema] (update-sink-connector-mapping context  sink-connector-mapping)
        ksql-coll (eksql/emit-ksql-batch context stream-schema)
        conn-coll (mapv p/emit-connector  connector-schema)
        ]

    [conn-coll ksql-coll]


    )
  )