(ns kotr.meta-data-repo
  (:require [kotr.pipeline.gen.protocol :as p]
            [kotr.kafka.client :as c]))


(defn get-kafka-schema [context]
  (let [stream-xf (map (fn [m]
                         (let [out (c/invoke context {:op "describe-stream" :request (get m :name)})
                             ;  _ (println "--" out )
                               out (-> out                  ;(dissoc out :writeQueries :readQueries)
                                       (update :name clojure.string/lower-case)
                                       (update :key (fn [v]
                                                      ;  (println "--" v)
                                                      (clojure.string/lower-case (last (clojure.string/split v #"\.")))))
                                       (update :fields (fn [v]
                                                         (into []
                                                               (comp
                                                                 (remove (fn [m]
                                                                           (= "rowkey" (clojure.string/lower-case (get m :name)))
                                                                           ))
                                                                 (map (fn [m]
                                                                        (assoc m :name (clojure.string/lower-case (get m :name)))
                                                                        )))
                                                               v #_(drop 2 v)))))]
                           {(clojure.string/lower-case (get m :name)) out})))
        table-xf (map (fn [m]
                        (let [out (c/invoke context {:op "describe-table" :request (get m :name)})
                              out (-> out #_(dissoc out :writeQueries :readQueries)
                                      (update :name clojure.string/lower-case)
                                      ;(update :key clojure.string/lower-case)
                                      (update :key (fn [v]
                                                     (clojure.string/lower-case (last (clojure.string/split v #"\.")))
                                                     ))
                                      (update :fields (fn [v]
                                                        (into []
                                                              (comp (remove (fn [m]
                                                                              (= "rowkey" (clojure.string/lower-case (get m :name)))
                                                                              ))
                                                                    (map (fn [m]
                                                                           (assoc m :name (clojure.string/lower-case (get m :name)))
                                                                           )))
                                                              v #_(drop 2 v)))))]
                          {(clojure.string/lower-case (get m :name)) out})))

        server-entity-schema-m (into {} stream-xf (c/invoke context {:op "show-streams"}))
        server-entity-schema-m (into server-entity-schema-m table-xf (c/invoke context {:op "show-tables"}))]
    server-entity-schema-m))
