/*
 * Decompiled with CFR 0.152.
 */
package com.mdn.tools.sparketl.models;

import com.mdn.tools.sparketl.models.datastore.DataStore;
import com.mdn.tools.sparketl.models.transform.Transformation;

public class Plan {
    private DataStore source;
    private DataStore lookup;
    private DataStore target;
    private Transformation transformation;

    public Plan(DataStore source, DataStore target, Transformation transformation) {
        this.source = source;
        this.target = target;
        this.transformation = transformation;
    }

    public Plan(DataStore source, DataStore target, DataStore lookup, Transformation transformation) {
        this.source = source;
        this.target = target;
        this.transformation = transformation;
    }

    public static PlanBuilder builder() {
        return new PlanBuilder();
    }

    public DataStore getSource() {
        return this.source;
    }

    public DataStore getLookup() {
        return this.lookup;
    }

    public DataStore getTarget() {
        return this.target;
    }

    public Transformation getTransformation() {
        return this.transformation;
    }

    public Plan() {
    }

    public static class PlanBuilder {
        private DataStore source;
        private DataStore lookup;
        private DataStore target;
        private Transformation transformation;

        PlanBuilder() {
        }

        public PlanBuilder source(DataStore source) {
            this.source = source;
            return this;
        }

        public PlanBuilder lookup(DataStore lookup) {
            this.lookup = lookup;
            return this;
        }

        public PlanBuilder target(DataStore target) {
            this.target = target;
            return this;
        }

        public PlanBuilder transformation(Transformation transformation) {
            this.transformation = transformation;
            return this;
        }

        public Plan build() {
            return new Plan(this.source, this.lookup, this.target, this.transformation);
        }

        public String toString() {
            return "Plan.PlanBuilder(source=" + this.source + ", lookup=" + this.lookup + ", target=" + this.target + ", transformation=" + this.transformation + ")";
        }
    }
}

