/*
 * Decompiled with CFR 0.152.
 */
package com.mdn.tools.sparketl.utils;

import com.mdn.tools.sparketl.models.datastore.DataStore;
import com.mdn.tools.sparketl.models.datastore.DataStoreType;
import com.mdn.tools.sparketl.models.datastore.impl.Csv;
import com.mdn.tools.sparketl.models.datastore.impl.Jdbc;
import com.mdn.tools.sparketl.models.datastore.impl.Json;
import com.mdn.tools.sparketl.utils.SparkJdbcUtils;
import java.util.Properties;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;

public class SparkUtils {
    private SparkSession sparkSession = null;
    private static SparkUtils sparkUtils;

    private SparkUtils() {
        SparkConf conf = new SparkConf().setMaster("local").setAppName("SparkEtl");
        conf.set("spark.driver.allowMultipleContexts", "true");
        this.sparkSession = SparkSession.builder().config(conf).getOrCreate();
    }

    public static SparkUtils getSparkUtils() {
        if (sparkUtils == null) {
            sparkUtils = new SparkUtils();
        }
        return sparkUtils;
    }

    public static void main(String[] args) {
        new SparkUtils().getSchema("test-data/sample.json", DataStoreType.JSON);
    }

    public String getSchema(String fileName, DataStoreType dataStoreType) {
        Dataset sourceDataset = this.readDataset(fileName, dataStoreType, this.sparkSession);
        return sourceDataset.schema().json();
    }

    public Dataset readDataset(String fileName, DataStoreType dataStoreType, SparkSession session) {
        switch (dataStoreType) {
            case CSV: {
                return session.read().format("csv").option("header", "true").load(fileName);
            }
            case JSON: {
                return session.read().format("json").option("multiline", "true").option("header", "true").load(fileName);
            }
        }
        return null;
    }

    public Dataset readDataset(DataStore dataStore, SparkSession session) {
        switch (dataStore.getDataStoreType()) {
            case CSV: {
                Csv csv = (Csv)dataStore;
                return session.read().format("csv").option("header", "true").load(csv.getFilePath());
            }
            case JSON: {
                Json json = (Json)dataStore;
                return session.read().format("json").option("multiline", "true").option("header", "true").load(json.getFilePath());
            }
            case JDBC: {
                Jdbc jdbc = (Jdbc)dataStore;
                Properties prop = new Properties();
                prop.setProperty("driver", jdbc.getDriver());
                prop.setProperty("user", jdbc.getUserName());
                prop.setProperty("password", jdbc.getPassword());
                return session.read().jdbc(jdbc.getUrl(), jdbc.getTable(), prop);
            }
        }
        return null;
    }

    public Boolean writeDataset(Dataset ds, DataStore target) {
        switch (target.getDataStoreType()) {
            case CSV: {
                return true;
            }
            case JDBC: {
                Jdbc jdbc = (Jdbc)target;
                ds.write().mode("append").jdbc(((Jdbc)target).getUrl(), ((Jdbc)target).getTable(), SparkJdbcUtils.getJdbcProperties(jdbc));
                return true;
            }
        }
        return null;
    }

    public SparkSession getSparkSession() {
        return this.sparkSession;
    }
}

