/*
 * Decompiled with CFR 0.152.
 */
package com.mdn.tools.sparketl;

import com.mdn.tools.sparketl.PlanExecutor;
import com.mdn.tools.sparketl.models.datastore.DataStoreType;
import com.mdn.tools.sparketl.utils.SparkUtils;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.spark.sql.AnalysisException;

public class SparketlMain {
    public static void main(String[] args) throws AnalysisException {
        PlanExecutor planExecutor = new PlanExecutor();
        DefaultParser parser = new DefaultParser();
        Option optPlan = Option.builder((String)"plan").argName("plan").longOpt("plan").hasArg(true).desc("Plan Json File Input").build();
        Option optSchema = Option.builder((String)"schema").argName("schema").hasArg(false).longOpt("schema").desc("schema of the given file").build();
        Option optInputFile = Option.builder((String)"file").argName("file").hasArg(true).longOpt("file").desc("file input for schema option").build();
        Option optInputType = Option.builder((String)"fileType").argName("fileType").hasArg(true).longOpt("fileType").desc("type of the file, valid options are JSON,CSV and XLSX").build();
        Options opts = new Options();
        opts.addOption(optPlan);
        opts.addOption(optSchema);
        opts.addOption(optInputFile);
        opts.addOption(optInputType);
        String header = "sparketl options\n\n";
        String footer = "\nPlease report issues at http://example.com/issues";
        HelpFormatter formatter = new HelpFormatter();
        try {
            CommandLine cmd = parser.parse(opts, args);
            if (cmd.hasOption("plan")) {
                String planJson = cmd.getOptionValue("plan");
                planExecutor.executePlan(planJson);
            } else if (cmd.hasOption("schema") && cmd.hasOption("file") && cmd.hasOption("fileType")) {
                String file = cmd.getOptionValue("file");
                DataStoreType dataStoreType = DataStoreType.valueOf(cmd.getOptionValue("fileType"));
                SparkUtils sparkUtils = SparkUtils.getSparkUtils();
                System.out.println(sparkUtils.getSchema(file, dataStoreType));
            }
        }
        catch (ParseException e) {
            formatter.printHelp("sparketl", header, opts, footer, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

