/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions.repository;

import com.lyncode.jtwig.functions.JtwigFunction;
import com.lyncode.jtwig.functions.annotations.JtwigFunctionDeclaration;
import com.lyncode.jtwig.functions.exceptions.FunctionNotFoundException;
import com.lyncode.jtwig.functions.internal.bool.Constant;
import com.lyncode.jtwig.functions.internal.bool.Defined;
import com.lyncode.jtwig.functions.internal.bool.DivisableBy;
import com.lyncode.jtwig.functions.internal.bool.Empty;
import com.lyncode.jtwig.functions.internal.bool.Even;
import com.lyncode.jtwig.functions.internal.bool.IsIterable;
import com.lyncode.jtwig.functions.internal.bool.IsNull;
import com.lyncode.jtwig.functions.internal.bool.Odd;
import com.lyncode.jtwig.functions.internal.cast.ToDouble;
import com.lyncode.jtwig.functions.internal.cast.ToInt;
import com.lyncode.jtwig.functions.internal.date.DateFormat;
import com.lyncode.jtwig.functions.internal.date.DateModify;
import com.lyncode.jtwig.functions.internal.generic.Default;
import com.lyncode.jtwig.functions.internal.generic.First;
import com.lyncode.jtwig.functions.internal.generic.JsonEncode;
import com.lyncode.jtwig.functions.internal.generic.Last;
import com.lyncode.jtwig.functions.internal.generic.Length;
import com.lyncode.jtwig.functions.internal.generic.Reverse;
import com.lyncode.jtwig.functions.internal.list.Batch;
import com.lyncode.jtwig.functions.internal.list.Concatenate;
import com.lyncode.jtwig.functions.internal.list.Join;
import com.lyncode.jtwig.functions.internal.list.Merge;
import com.lyncode.jtwig.functions.internal.list.Slice;
import com.lyncode.jtwig.functions.internal.map.MapKeys;
import com.lyncode.jtwig.functions.internal.math.Abs;
import com.lyncode.jtwig.functions.internal.math.JNumberFormat;
import com.lyncode.jtwig.functions.internal.math.Round;
import com.lyncode.jtwig.functions.internal.string.Capitalize;
import com.lyncode.jtwig.functions.internal.string.ConvertEncoding;
import com.lyncode.jtwig.functions.internal.string.Escape;
import com.lyncode.jtwig.functions.internal.string.Format;
import com.lyncode.jtwig.functions.internal.string.Lower;
import com.lyncode.jtwig.functions.internal.string.Nl2Br;
import com.lyncode.jtwig.functions.internal.string.Replace;
import com.lyncode.jtwig.functions.internal.string.Split;
import com.lyncode.jtwig.functions.internal.string.StripTags;
import com.lyncode.jtwig.functions.internal.string.Title;
import com.lyncode.jtwig.functions.internal.string.Trim;
import com.lyncode.jtwig.functions.internal.string.Upper;
import com.lyncode.jtwig.functions.internal.string.UrlEncode;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractFunctionRepository {
    private Map<String, JtwigFunction> functionMap = new HashMap<String, JtwigFunction>();

    public AbstractFunctionRepository(JtwigFunction ... jtwigFunctions) {
        this.add(new Concatenate(), new Join(), new Batch(), new Merge(), new Slice(), new MapKeys(), new Upper(), new Lower(), new StripTags(), new Trim(), new Split(), new Capitalize(), new Title(), new Replace(), new Format(), new Nl2Br(), new UrlEncode(), new Escape(), new DateModify(), new DateFormat(), new ConvertEncoding(), new Abs(), new JNumberFormat(), new Round(), new ToDouble(), new ToInt(), new Length(), new Default(), new First(), new Last(), new JsonEncode(), new Reverse(), new Empty(), new Constant(), new Defined(), new Even(), new Odd(), new IsIterable(), new IsNull(), new DivisableBy());
        this.add(jtwigFunctions);
    }

    public void add(JtwigFunction ... jtwigFunctions) {
        for (JtwigFunction jtwigFunction : jtwigFunctions) {
            this.add(jtwigFunction);
        }
    }

    public void add(JtwigFunction jtwigFunction) {
        Class<?> functionClass = jtwigFunction.getClass();
        if (functionClass.isAnnotationPresent(JtwigFunctionDeclaration.class)) {
            JtwigFunctionDeclaration declaration = functionClass.getAnnotation(JtwigFunctionDeclaration.class);
            this.add(jtwigFunction, this.getName(declaration, functionClass), declaration.aliases());
        } else {
            this.add(jtwigFunction, this.getNameFromClass(functionClass), new String[0]);
        }
    }

    private String getName(JtwigFunctionDeclaration declaration, Class<? extends JtwigFunction> functionClass) {
        if (!declaration.name().equals("")) {
            return declaration.name();
        }
        return this.getNameFromClass(functionClass);
    }

    private String getNameFromClass(Class<? extends JtwigFunction> functionClass) {
        String functionName = functionClass.getSimpleName();
        if (functionName == null || functionName.equals("")) {
            throw new RuntimeException("Function without name, try to use add(function, name) method");
        }
        return functionName.substring(0, 1).toLowerCase() + functionName.substring(1);
    }

    public void add(JtwigFunction jtwigFunction, String name, String ... aliases) {
        this.functionMap.put(name, jtwigFunction);
        for (String alias : aliases) {
            this.functionMap.put(alias, jtwigFunction);
        }
    }

    public JtwigFunction retrieve(String functionName) throws FunctionNotFoundException {
        if (!this.functionMap.containsKey(functionName)) {
            throw new FunctionNotFoundException();
        }
        return this.functionMap.get(functionName);
    }
}

