/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions.internal.list;

import com.lyncode.jtwig.functions.JtwigFunction;
import com.lyncode.jtwig.functions.annotations.JtwigFunctionDeclaration;
import com.lyncode.jtwig.functions.exceptions.FunctionException;
import com.lyncode.jtwig.functions.util.Requirements;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

@JtwigFunctionDeclaration(name="merge")
public class Merge
implements JtwigFunction {
    @Override
    public Object execute(Object ... arguments) throws FunctionException {
        Requirements.requires(arguments).withNumberOfArguments((Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(1))).withArgument(0, (Matcher<Object>)Matchers.anyOf((Matcher)Matchers.instanceOf(Iterable.class), (Matcher)Matchers.instanceOf(Map.class), Requirements.isArray()));
        if (arguments[0] instanceof Iterable) {
            return this.mergeList(arguments);
        }
        if (arguments[0] instanceof Map) {
            return this.mergeMap(arguments);
        }
        return this.mergeArray(arguments);
    }

    private Object mergeArray(Object ... arguments) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object obj : arguments) {
            Object[] list;
            if (obj == null) continue;
            for (Object value : list = (Object[])obj) {
                result.add(value);
            }
        }
        return result.toArray();
    }

    private Object mergeMap(Object ... arguments) {
        AbstractMap result = arguments[0] instanceof TreeMap ? new TreeMap() : new HashMap();
        for (Object obj : arguments) {
            if (obj == null) continue;
            result.putAll((Map)obj);
        }
        return result;
    }

    private Object mergeList(Object ... arguments) {
        ArrayList result = new ArrayList();
        for (Object obj : arguments) {
            if (obj == null) continue;
            result.addAll((List)obj);
        }
        return result;
    }
}

